/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.jdbc;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.ColumnMapping;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;

@Plugin(name="Column", category="Core", printObject=true)
public final class ColumnConfig {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String columnName;
    private final String columnNameKey;
    private final PatternLayout layout;
    private final String literalValue;
    private final boolean eventTimestamp;
    private final boolean unicode;
    private final boolean clob;

    @Deprecated
    public static ColumnConfig createColumnConfig(Configuration configuration, String string, String string2, String string3, String string4, String string5, String string6) {
        if (Strings.isEmpty(string)) {
            LOGGER.error("The column config is not valid because it does not contain a column name.");
            return null;
        }
        boolean bl2 = Boolean.parseBoolean(string4);
        boolean bl3 = Booleans.parseBoolean(string5, true);
        boolean bl4 = Boolean.parseBoolean(string6);
        return ColumnConfig.newBuilder().setConfiguration(configuration).setName(string).setPattern(string2).setLiteral(string3).setEventTimestamp(bl2).setUnicode(bl3).setClob(bl4).build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private ColumnConfig(String string, PatternLayout patternLayout, String string2, boolean bl2, boolean bl3, boolean bl4) {
        this.columnName = string;
        this.columnNameKey = ColumnMapping.toKey(string);
        this.layout = patternLayout;
        this.literalValue = string2;
        this.eventTimestamp = bl2;
        this.unicode = bl3;
        this.clob = bl4;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnNameKey() {
        return this.columnNameKey;
    }

    public PatternLayout getLayout() {
        return this.layout;
    }

    public String getLiteralValue() {
        return this.literalValue;
    }

    public boolean isClob() {
        return this.clob;
    }

    public boolean isEventTimestamp() {
        return this.eventTimestamp;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public String toString() {
        return "{ name=" + this.columnName + ", layout=" + this.layout + ", literal=" + this.literalValue + ", timestamp=" + this.eventTimestamp + " }";
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<ColumnConfig> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        @Required(message="No name provided")
        private String name;
        @PluginBuilderAttribute
        private String pattern;
        @PluginBuilderAttribute
        private String literal;
        @PluginBuilderAttribute
        private boolean isEventTimestamp;
        @PluginBuilderAttribute
        private boolean isUnicode = true;
        @PluginBuilderAttribute
        private boolean isClob;

        @Override
        public ColumnConfig build() {
            if (Strings.isEmpty(this.name)) {
                LOGGER.error("The column config is not valid because it does not contain a column name.");
                return null;
            }
            boolean bl2 = Strings.isNotEmpty(this.pattern);
            boolean bl3 = Strings.isNotEmpty(this.literal);
            if (bl2 && bl3 || bl2 && this.isEventTimestamp || bl3 && this.isEventTimestamp) {
                LOGGER.error("The pattern, literal, and isEventTimestamp attributes are mutually exclusive.");
                return null;
            }
            if (this.isEventTimestamp) {
                return new ColumnConfig(this.name, null, null, true, false, false);
            }
            if (bl3) {
                return new ColumnConfig(this.name, null, this.literal, false, false, false);
            }
            if (bl2) {
                PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(this.pattern).withConfiguration(this.configuration).withAlwaysWriteExceptions(false).build();
                return new ColumnConfig(this.name, patternLayout, null, false, this.isUnicode, this.isClob);
            }
            LOGGER.error("To configure a column you must specify a pattern or literal or set isEventDate to true.");
            return null;
        }

        public Builder setClob(boolean bl2) {
            this.isClob = bl2;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setEventTimestamp(boolean bl2) {
            this.isEventTimestamp = bl2;
            return this;
        }

        public Builder setLiteral(String string) {
            this.literal = string;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setPattern(String string) {
            this.pattern = string;
            return this;
        }

        public Builder setUnicode(boolean bl2) {
            this.isUnicode = bl2;
            return this;
        }
    }
}

