/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rewrite;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ContextDataFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Plugin(name="PropertiesRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public final class PropertiesRewritePolicy
implements RewritePolicy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<Property, Boolean> properties;
    private final Configuration config;

    private PropertiesRewritePolicy(Configuration configuration, List<Property> list) {
        this.config = configuration;
        this.properties = new HashMap<Property, Boolean>(list.size());
        for (Property property : list) {
            Boolean bl2 = property.getValue().contains("${");
            this.properties.put(property, bl2);
        }
    }

    @Override
    public LogEvent rewrite(LogEvent logEvent) {
        StringMap stringMap = ContextDataFactory.createContextData(logEvent.getContextData());
        for (Map.Entry<Property, Boolean> entry : this.properties.entrySet()) {
            Property property = entry.getKey();
            stringMap.putValue(property.getName(), entry.getValue() != false ? this.config.getStrSubstitutor().replace(property.getValue()) : property.getValue());
        }
        return new Log4jLogEvent.Builder(logEvent).setContextData(stringMap).build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" {");
        boolean bl2 = true;
        for (Map.Entry<Property, Boolean> entry : this.properties.entrySet()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            Property property = entry.getKey();
            stringBuilder.append(property.getName()).append('=').append(property.getValue());
            bl2 = false;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @PluginFactory
    public static PropertiesRewritePolicy createPolicy(@PluginConfiguration Configuration configuration, @PluginElement(value="Properties") Property[] propertyArray) {
        if (propertyArray == null || propertyArray.length == 0) {
            LOGGER.error("Properties must be specified for the PropertiesRewritePolicy");
            return null;
        }
        List<Property> list = Arrays.asList(propertyArray);
        return new PropertiesRewritePolicy(configuration, list);
    }
}

