/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.lang.reflect.Method;

@Plugin(name="OnStartupTriggeringPolicy", category="Core", printObject=true)
public class OnStartupTriggeringPolicy
extends AbstractTriggeringPolicy {
    private static final long JVM_START_TIME = OnStartupTriggeringPolicy.initStartTime();
    private final long minSize;

    private OnStartupTriggeringPolicy(long l2) {
        this.minSize = l2;
    }

    private static long initStartTime() {
        try {
            Class<?> clazz = Loader.loadSystemClass("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getRuntimeMXBean", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Class<?> clazz2 = Loader.loadSystemClass("java.lang.management.RuntimeMXBean");
            Method method2 = clazz2.getMethod("getStartTime", new Class[0]);
            Long l2 = (Long)method2.invoke(object, new Object[0]);
            return l2;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            StatusLogger.getLogger().error("Unable to call ManagementFactory.getRuntimeMXBean().getStartTime(), using system time for OnStartupTriggeringPolicy", throwable2);
            return System.currentTimeMillis();
        }
    }

    @Override
    public void initialize(RollingFileManager rollingFileManager) {
        if (rollingFileManager.getFileTime() < JVM_START_TIME && rollingFileManager.getFileSize() >= this.minSize) {
            StatusLogger.getLogger().debug("Initiating rollover at startup");
            if (this.minSize == 0L) {
                rollingFileManager.setRenameEmptyFiles(true);
            }
            rollingFileManager.skipFooter(true);
            rollingFileManager.rollover();
            rollingFileManager.skipFooter(false);
        }
    }

    @Override
    public boolean isTriggeringEvent(LogEvent logEvent) {
        return false;
    }

    public String toString() {
        return "OnStartupTriggeringPolicy";
    }

    @PluginFactory
    public static OnStartupTriggeringPolicy createPolicy(@PluginAttribute(value="minSize", defaultLong=1L) long l2) {
        return new OnStartupTriggeringPolicy(l2);
    }
}

