/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.commons.compress.compressors.CompressorException;
import com.contrastsecurity.thirdparty.org.apache.commons.compress.compressors.CompressorStreamFactory;
import com.contrastsecurity.thirdparty.org.apache.commons.compress.utils.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Objects;

public final class CommonsCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final String name;
    private final File source;
    private final File destination;
    private final boolean deleteSource;

    public CommonsCompressAction(String string, File file, File file2, boolean bl2) {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        this.name = string;
        this.source = file;
        this.destination = file2;
        this.deleteSource = bl2;
    }

    @Override
    public boolean execute() throws IOException {
        return CommonsCompressAction.execute(this.name, this.source, this.destination, this.deleteSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(String string, File file, File file2, boolean bl2) throws IOException {
        Object object;
        block26: {
            if (!file.exists()) {
                return false;
            }
            LOGGER.debug("Starting {} compression of {}", (Object)string, (Object)file.getPath());
            try {
                block27: {
                    Object object2;
                    object = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        block24: {
                            block25: {
                                object2 = new BufferedOutputStream((OutputStream)new CompressorStreamFactory().createCompressorOutputStream(string, (OutputStream)new FileOutputStream(file2)));
                                Throwable throwable2 = null;
                                try {
                                    IOUtils.copy((InputStream)object, (OutputStream)object2, (int)8192);
                                    LOGGER.debug("Finished {} compression of {}", (Object)string, (Object)file.getPath());
                                    if (object2 == null) break block24;
                                    if (throwable2 == null) break block25;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        Throwable throwable6;
                                        Throwables.throwIfCritical(throwable3);
                                        throwable2 = throwable6 = throwable3;
                                        throw throwable6;
                                    }
                                    catch (Throwable throwable7) {
                                        if (object2 == null) throw throwable7;
                                        if (throwable2 == null) {
                                            ((FilterOutputStream)object2).close();
                                            throw throwable7;
                                        }
                                        try {
                                            ((FilterOutputStream)object2).close();
                                            throw throwable7;
                                        }
                                        catch (Throwable throwable4) {
                                            Throwables.throwIfCritical(throwable4);
                                            Throwable throwable9 = throwable4;
                                            throwable2.addSuppressed(throwable9);
                                            throw throwable7;
                                        }
                                    }
                                }
                                try {
                                    ((FilterOutputStream)object2).close();
                                }
                                catch (Throwable throwable5) {
                                    Throwables.throwIfCritical(throwable5);
                                    Throwable throwable4 = throwable5;
                                    throwable2.addSuppressed(throwable4);
                                }
                                break block24;
                            }
                            ((FilterOutputStream)object2).close();
                        }
                        if (object == null) break block26;
                        if (throwable == null) break block27;
                    }
                    catch (Throwable throwable6) {
                        try {
                            Throwable throwable12;
                            Throwables.throwIfCritical(throwable6);
                            throwable = throwable12 = throwable6;
                            throw throwable12;
                        }
                        catch (Throwable throwable13) {
                            if (object == null) throw throwable13;
                            if (throwable == null) {
                                ((FileInputStream)object).close();
                                throw throwable13;
                            }
                            try {
                                ((FileInputStream)object).close();
                                throw throwable13;
                            }
                            catch (Throwable throwable7) {
                                Throwables.throwIfCritical(throwable7);
                                Throwable throwable15 = throwable7;
                                throwable.addSuppressed(throwable15);
                                throw throwable13;
                            }
                        }
                    }
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable8) {
                        Throwables.throwIfCritical(throwable8);
                        object2 = throwable8;
                        throwable.addSuppressed((Throwable)object2);
                    }
                    break block26;
                }
                ((FileInputStream)object).close();
            }
            catch (CompressorException compressorException) {
                throw new IOException(compressorException);
            }
        }
        if (!bl2) return true;
        try {
            if (Files.deleteIfExists(file.toPath())) {
                LOGGER.debug("Deleted {}", (Object)file.toString());
                return true;
            }
            LOGGER.warn("Unable to delete {} after {} compression. File did not exist", (Object)file.toString(), (Object)string);
            return true;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            object = exception;
            LOGGER.warn("Unable to delete {} after {} compression, {}", (Object)file.toString(), (Object)string, (Object)((Throwable)object).getMessage());
        }
        return true;
    }

    @Override
    protected void reportException(Exception exception) {
        LOGGER.warn("Exception during " + this.name + " compression of '" + this.source.toString() + "'.", (Throwable)exception);
    }

    public String toString() {
        return CommonsCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public String getName() {
        return this.name;
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }
}

