/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.ThreadContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.ContextDataInjector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.CopyOnWrite;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.DefaultThreadContextMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;

public class ContextDataInjectorFactory {
    public static ContextDataInjector createInjector() {
        String string = PropertiesUtil.getProperties().getStringProperty("com.contrastsecurity.thirdparty.log4j2.ContextDataInjector");
        if (string == null) {
            return ContextDataInjectorFactory.createDefaultInjector();
        }
        try {
            Class<ContextDataInjector> clazz = Loader.loadClass(string).asSubclass(ContextDataInjector.class);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            ContextDataInjector contextDataInjector = ContextDataInjectorFactory.createDefaultInjector();
            StatusLogger.getLogger().warn("Could not create ContextDataInjector for '{}', using default {}: {}", (Object)string, (Object)contextDataInjector.getClass().getName(), (Object)exception2);
            return contextDataInjector;
        }
    }

    private static ContextDataInjector createDefaultInjector() {
        ReadOnlyThreadContextMap readOnlyThreadContextMap = ThreadContext.getThreadContextMap();
        if (readOnlyThreadContextMap instanceof DefaultThreadContextMap || readOnlyThreadContextMap == null) {
            return new ThreadContextDataInjector.ForDefaultThreadContextMap();
        }
        if (readOnlyThreadContextMap instanceof CopyOnWrite) {
            return new ThreadContextDataInjector.ForCopyOnWriteThreadContextMap();
        }
        return new ThreadContextDataInjector.ForGarbageFreeThreadContextMap();
    }
}

