/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationAware;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.LoggerContextAware;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.AbstractConfigurationAwareLookup;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.LookupResult;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.PropertiesLookup;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrLookup;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.JndiManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.ReflectionUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Interpolator
extends AbstractConfigurationAwareLookup
implements LoggerContextAware {
    public static final char PREFIX_SEPARATOR = ':';
    private static final String LOOKUP_KEY_WEB = "web";
    private static final String LOOKUP_KEY_DOCKER = "docker";
    private static final String LOOKUP_KEY_KUBERNETES = "kubernetes";
    private static final String LOOKUP_KEY_SPRING = "spring";
    private static final String LOOKUP_KEY_JNDI = "jndi";
    private static final String LOOKUP_KEY_JVMRUNARGS = "jvmrunargs";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<String, StrLookup> strLookupMap = new HashMap<String, StrLookup>();
    private final StrLookup defaultLookup;
    protected WeakReference<LoggerContext> loggerContext;

    public Interpolator(StrLookup strLookup) {
        this(strLookup, null);
    }

    public Interpolator(StrLookup strLookup, List<String> list) {
        this.defaultLookup = strLookup == null ? new PropertiesLookup(new HashMap<String, String>()) : strLookup;
        PluginManager pluginManager = new PluginManager("Lookup");
        pluginManager.collectPlugins(list);
        Map<String, PluginType<?>> map = pluginManager.getPlugins();
        for (Map.Entry<String, PluginType<?>> entry : map.entrySet()) {
            Serializable serializable;
            try {
                serializable = entry.getValue().getPluginClass().asSubclass(StrLookup.class);
                if (((Class)serializable).getName().equals("com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.JndiLookup") && !JndiManager.isJndiLookupEnabled()) continue;
                this.strLookupMap.put(entry.getKey().toLowerCase(), (StrLookup)ReflectionUtil.instantiate(serializable));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                serializable = throwable;
                this.handleError(entry.getKey(), (Throwable)serializable);
            }
        }
    }

    public Interpolator() {
        this((Map<String, String>)null);
    }

    public Interpolator(Map<String, String> map) {
        this(new PropertiesLookup(map), Collections.emptyList());
    }

    public StrLookup getDefaultLookup() {
        return this.defaultLookup;
    }

    public Map<String, StrLookup> getStrLookupMap() {
        return this.strLookupMap;
    }

    private void handleError(String string, Throwable throwable) {
        switch (string) {
            case "jndi": {
                LOGGER.warn("JNDI lookup class is not available because this JRE does not support JNDI. JNDI string lookups will not be available, continuing configuration. Ignoring " + throwable);
                break;
            }
            case "jvmrunargs": {
                LOGGER.warn("JMX runtime input lookup class is not available because this JRE does not support JMX. JMX lookups will not be available, continuing configuration. Ignoring " + throwable);
                break;
            }
            case "web": {
                LOGGER.info("Log4j appears to be running in a Servlet environment, but there's no log4j-web module available. If you want better web container support, please add the log4j-web JAR to your web archive or server lib directory.");
                break;
            }
            case "docker": 
            case "spring": {
                break;
            }
            case "kubernetes": {
                if (!(throwable instanceof NoClassDefFoundError)) break;
                LOGGER.warn("Unable to create Kubernetes lookup due to missing dependency: {}", (Object)throwable.getMessage());
                break;
            }
            default: {
                LOGGER.error("Unable to create Lookup for {}", (Object)string, (Object)throwable);
            }
        }
    }

    @Override
    public String lookup(LogEvent logEvent, String string) {
        LookupResult lookupResult = this.evaluate(logEvent, string);
        return lookupResult == null ? null : lookupResult.value();
    }

    @Override
    public LookupResult evaluate(LogEvent logEvent, String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            String string2 = string.substring(0, n2).toLowerCase(Locale.US);
            String string3 = string.substring(n2 + 1);
            StrLookup strLookup = this.strLookupMap.get(string2);
            if (strLookup instanceof ConfigurationAware) {
                ((ConfigurationAware)((Object)strLookup)).setConfiguration(this.configuration);
            }
            if (strLookup instanceof LoggerContextAware) {
                ((LoggerContextAware)((Object)strLookup)).setLoggerContext((LoggerContext)this.loggerContext.get());
            }
            LookupResult lookupResult = null;
            if (strLookup != null) {
                LookupResult lookupResult2 = lookupResult = logEvent == null ? strLookup.evaluate(string3) : strLookup.evaluate(logEvent, string3);
            }
            if (lookupResult != null) {
                return lookupResult;
            }
            string = string.substring(n2 + 1);
        }
        if (this.defaultLookup != null) {
            return logEvent == null ? this.defaultLookup.evaluate(string) : this.defaultLookup.evaluate(logEvent, string);
        }
        return null;
    }

    @Override
    public void setLoggerContext(LoggerContext loggerContext) {
        if (loggerContext == null) {
            return;
        }
        this.loggerContext = new WeakReference<LoggerContext>(loggerContext);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.strLookupMap.keySet()) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append('{');
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }
}

