/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.javax.naming.NamingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.MarkerManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.AbstractLookup;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.JndiManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.Objects;

@Plugin(name="jndi", category="Lookup")
public class JndiLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Marker LOOKUP = MarkerManager.getMarker("LOOKUP");
    static final String CONTAINER_JNDI_RESOURCE_PATH_PREFIX = "java:comp/env/";

    public JndiLookup() {
        if (!JndiManager.isJndiLookupEnabled()) {
            throw new IllegalStateException("JNDI must be enabled by setting log4j2.enableJndiLookup=true");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String lookup(LogEvent logEvent, String string) {
        if (string == null) {
            return null;
        }
        String string3 = this.convertJndiName(string);
        try {
            String string2;
            JndiManager jndiManager;
            block12: {
                jndiManager = JndiManager.getDefaultManager();
                Throwable throwable = null;
                try {
                    string2 = Objects.toString(jndiManager.lookup(string3), null);
                    if (jndiManager == null) return string2;
                    if (throwable == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable5;
                        Throwables.throwIfCritical(throwable2);
                        throwable = throwable5 = throwable2;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (jndiManager == null) throw throwable6;
                        if (throwable == null) {
                            jndiManager.close();
                            throw throwable6;
                        }
                        try {
                            jndiManager.close();
                            throw throwable6;
                        }
                        catch (Throwable throwable3) {
                            Throwables.throwIfCritical(throwable3);
                            Throwable throwable8 = throwable3;
                            throwable.addSuppressed(throwable8);
                            throw throwable6;
                        }
                    }
                }
                try {
                    jndiManager.close();
                    return string2;
                }
                catch (Throwable throwable4) {
                    Throwables.throwIfCritical(throwable4);
                    Throwable throwable3 = throwable4;
                    throwable.addSuppressed(throwable3);
                    return string2;
                }
            }
            jndiManager.close();
            return string2;
        }
        catch (NamingException namingException) {
            LOGGER.warn(LOOKUP, "Error looking up JNDI resource [{}].", (Object)string3, (Object)namingException);
            return null;
        }
    }

    private String convertJndiName(String string) {
        if (!string.startsWith(CONTAINER_JNDI_RESOURCE_PATH_PREFIX) && string.indexOf(58) == -1) {
            return CONTAINER_JNDI_RESOURCE_PATH_PREFIX + string;
        }
        return string;
    }
}

