/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.slf4j;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.MarkerManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.slf4j.Log4jMarker;
import com.contrastsecurity.thirdparty.org.slf4j.IMarkerFactory;
import com.contrastsecurity.thirdparty.org.slf4j.Marker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Log4jMarkerFactory
implements IMarkerFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConcurrentMap<String, Marker> markerMap = new ConcurrentHashMap<String, Marker>();

    @Override
    public Marker getMarker(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        Marker marker = (Marker)this.markerMap.get(string);
        if (marker != null) {
            return marker;
        }
        com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker marker2 = MarkerManager.getMarker(string);
        return this.addMarkerIfAbsent(string, marker2);
    }

    private Marker addMarkerIfAbsent(String string, com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker marker) {
        Log4jMarker log4jMarker = new Log4jMarker(this, marker);
        Marker marker2 = this.markerMap.putIfAbsent(string, log4jMarker);
        return marker2 == null ? log4jMarker : marker2;
    }

    public Marker getMarker(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        Marker marker2 = (Marker)this.markerMap.get(marker.getName());
        if (marker2 != null) {
            return marker2;
        }
        return this.addMarkerIfAbsent(marker.getName(), Log4jMarkerFactory.convertMarker(marker));
    }

    com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker getLog4jMarker(Marker marker) {
        if (marker == null) {
            return null;
        }
        if (marker instanceof Log4jMarker) {
            return ((Log4jMarker)marker).getLog4jMarker();
        }
        return ((Log4jMarker)this.getMarker(marker)).getLog4jMarker();
    }

    static com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker convertMarker(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        return Log4jMarkerFactory.convertMarker(marker, new ArrayList<Marker>());
    }

    private static com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker convertMarker(Marker marker, Collection<Marker> collection) {
        com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker marker2 = MarkerManager.getMarker(marker.getName());
        if (marker.hasReferences()) {
            Iterator<Marker> iterator = marker.iterator();
            while (iterator.hasNext()) {
                Marker marker3 = iterator.next();
                if (collection.contains(marker3)) {
                    LOGGER.warn("Found a cycle in Marker [{}]. Cycle will be broken.", (Object)marker3.getName());
                    continue;
                }
                collection.add(marker3);
                marker2.addParents(Log4jMarkerFactory.convertMarker(marker3, collection));
            }
        }
        return marker2;
    }

    @Override
    public boolean exists(String string) {
        return this.markerMap.containsKey(string);
    }

    @Override
    public boolean detachMarker(String string) {
        return false;
    }

    @Override
    public Marker getDetachedMarker(String string) {
        LOGGER.warn("Log4j does not support detached Markers. Returned Marker [{}] will be unchanged.", (Object)string);
        return this.getMarker(string);
    }
}

