/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jctools.queues;

import com.contrastsecurity.thirdparty.org.jctools.queues.BaseSpscLinkedArrayQueue;
import com.contrastsecurity.thirdparty.org.jctools.queues.LinkedArrayQueueUtil;
import com.contrastsecurity.thirdparty.org.jctools.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.org.jctools.util.Pow2;
import com.contrastsecurity.thirdparty.org.jctools.util.RangeUtil;
import com.contrastsecurity.thirdparty.org.jctools.util.SpscLookAheadUtil;
import com.contrastsecurity.thirdparty.org.jctools.util.UnsafeRefArrayAccess;

public class SpscGrowableArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    private final int maxQueueCapacity;
    private long lookAheadStep;

    public SpscGrowableArrayQueue(int n2) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(n2 / 8)), n2);
    }

    public SpscGrowableArrayQueue(int n2, int n3) {
        RangeUtil.checkGreaterThanOrEqual(n3, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(n2, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(n3);
        int n4 = Pow2.roundToPowerOfTwo(n2);
        RangeUtil.checkLessThan(n4, this.maxQueueCapacity, "chunkCapacity");
        long l2 = n4 - 1;
        E[] EArray = UnsafeRefArrayAccess.allocateRefArray(n4 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l2;
        this.consumerBuffer = EArray;
        this.consumerMask = l2;
        this.producerBufferLimit = l2 - 1L;
        this.adjustLookAheadStep(n4);
    }

    @Override
    final boolean offerColdPath(E[] EArray, long l2, long l3, long l4, E e2, MessagePassingQueue.Supplier<? extends E> supplier) {
        int n2;
        long l5 = this.lookAheadStep;
        if (l5 > 0L) {
            long l6 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3 + l5, l2);
            if (null == UnsafeRefArrayAccess.lvRefElement(EArray, l6)) {
                this.producerBufferLimit = l3 + l5 - 1L;
                this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
                return true;
            }
            int n3 = this.maxQueueCapacity;
            if (l2 + 1L == (long)n3) {
                if (null == UnsafeRefArrayAccess.lvRefElement(EArray, l4)) {
                    this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
                    return true;
                }
                return false;
            }
            if (null == UnsafeRefArrayAccess.lvRefElement(EArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l3 + 1L, l2))) {
                this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
            } else {
                Object[] objectArray = UnsafeRefArrayAccess.allocateRefArray((int)(2L * (l2 + 1L) + 1L));
                this.producerBuffer = objectArray;
                this.producerMask = LinkedArrayQueueUtil.length(objectArray) - 2;
                long l7 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, this.producerMask);
                this.linkOldToNew(l3, EArray, l4, objectArray, l7, e2 == null ? supplier.get() : e2);
                int n4 = (int)(this.producerMask + 1L);
                if (n4 == n3) {
                    long l8 = this.lvConsumerIndex();
                    this.lookAheadStep = -(l3 - l8);
                    this.producerBufferLimit = l8 + (long)n3;
                } else {
                    this.producerBufferLimit = l3 + this.producerMask - 1L;
                    this.adjustLookAheadStep(n4);
                }
            }
            return true;
        }
        long l9 = -l5;
        long l10 = this.lvConsumerIndex();
        int n5 = (int)(l3 - l10);
        if (n5 == (n2 = (int)l2 + 1)) {
            return false;
        }
        long l11 = this.producerBufferLimit - (long)n2 + l9;
        if (l10 >= l11) {
            this.adjustLookAheadStep(n2);
        } else {
            this.lookAheadStep = (int)(l10 - l11);
        }
        this.producerBufferLimit = l10 + (long)n2;
        this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
        return true;
    }

    private void adjustLookAheadStep(int n2) {
        this.lookAheadStep = SpscLookAheadUtil.computeLookAheadStep(n2);
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

