/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.AppActivity;
import com.contrastsecurity.agent.apps.InventoryException;
import com.contrastsecurity.agent.apps.c;
import com.contrastsecurity.agent.apps.exclusions.ChainedExclusionProcessor;
import com.contrastsecurity.agent.apps.exclusions.DefaultExclusionProcessor;
import com.contrastsecurity.agent.apps.exclusions.f;
import com.contrastsecurity.agent.apps.exclusions.i;
import com.contrastsecurity.agent.apps.java.codeinfo.LibraryFacts;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ApplicationExecutionContext;
import com.contrastsecurity.agent.context.ApplicationExecutionContextImpl;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.RuleExceptionDTM;
import com.contrastsecurity.agent.messages.mq.ScreenerApplication;
import com.contrastsecurity.agent.messages.routes.DiscoveredRoute;
import com.contrastsecurity.agent.opentelemetry.OtelGlobalConfig;
import com.contrastsecurity.agent.opentelemetry.g;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.dev.failsafe.Failsafe;
import com.contrastsecurity.thirdparty.dev.failsafe.Policy;
import com.contrastsecurity.thirdparty.dev.failsafe.RetryPolicy;
import com.contrastsecurity.thirdparty.dev.failsafe.RetryPolicyBuilder;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

@DontObfuscate
public class Application {
    public static final String DEFAULT_LAST_MODIFIED_DATE = "Thu, 01 Jan 1970 00:00:00 GMT";
    public static final ExecutionContext.Key<Map> DISCOVERED_ROUTES_KEY = ExecutionContext.Key.create(Map.class);
    private final e config;
    @Deprecated
    private volatile i testExclusionProcessor;
    private final WeakReference<ClassLoader> classloaderRef;
    private final ApplicationExecutionContext context;
    private final ConcurrentMap<String, LibraryFacts> libraryUsage;
    private final String classLoader;
    private final AtomicReference<AppActivity> activity;
    private final Set<String> technologies;
    private final String key;
    private final String resolvedFilePath;
    private final Collection<DiscoveredRoute> discoveredRoutes;
    private final InventoryProvider inventoryProvider;
    private final String version;
    private final Object createdLock = new Object();
    private final com.contrastsecurity.agent.o.c eventListener;
    private final g otelApp;
    private final EnumSet<b> dirtyReasons = EnumSet.noneOf(b.class);
    private String name;
    private String contextPath;
    private File artifact;
    private volatile boolean unwanted;
    private Collection<SoftReference<Runnable>> actionsBuffer = new ArrayList<SoftReference<Runnable>>();
    private long lastReportedTime;
    private long lastActivityReportedTime;
    private long lastChangeOccurred;
    private boolean configuredAppNameUsed;
    private volatile i exclusionProcessor;
    private volatile long lastAppSettingsUpdatedProcessed;
    private volatile ApplicationSettingsDTM settingsDTM;
    private volatile c applicationState = c.a;
    private String settingsLastModified = "Thu, 01 Jan 1970 00:00:00 GMT";
    private static final String UNABLE_TO_CALCULATE_ARTIFACT_HASH = Application.class.getTypeName() + ".UNABLE_TO_CALCULATE_ARTIFACT_HASH";
    private static final ExecutionContext.Key<String> ARTIFACT_HASH_SESSION_METADATA = ExecutionContext.Key.create(String.class);
    @p
    static final String DEFAULT_ROOT_APP_NAME = "ROOT";
    @p
    static final String DEFAULT_CONTEXT_PATH = "/";
    private static final RetryPolicy<LibraryFacts> RETRY_POLICY = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(throwable -> throwable instanceof ConcurrentModificationException)).withMaxRetries(3).build();
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    Application(String string, String string2, String string3, e e2, String string4, String string5, InventoryProvider inventoryProvider, ApplicationExecutionContext applicationExecutionContext, ClassLoader classLoader, com.contrastsecurity.agent.o.c c2, OtelGlobalConfig otelGlobalConfig, File file) {
        this(string, string2, string3, e2, string4, string5, inventoryProvider, applicationExecutionContext, classLoader, true, c2, otelGlobalConfig, file);
    }

    private Application(String string, String string2, String string3, e e2, String string4, String string5, InventoryProvider inventoryProvider, ApplicationExecutionContext applicationExecutionContext, ClassLoader classLoader, boolean bl2, com.contrastsecurity.agent.o.c c2, OtelGlobalConfig otelGlobalConfig, File file) {
        this.config = Objects.requireNonNull(e2);
        this.classloaderRef = new WeakReference<ClassLoader>(classLoader);
        this.classLoader = JVMUtils.getSafeToString(classLoader);
        this.technologies = new CopyOnWriteArraySet<String>();
        this.context = applicationExecutionContext == null ? new ApplicationExecutionContextImpl() : applicationExecutionContext;
        this.libraryUsage = new ConcurrentHashMap<String, LibraryFacts>();
        this.exclusionProcessor = i.a;
        this.activity = new AtomicReference<AppActivity>(new AppActivity());
        this.contextPath = Application.checkContextPath(string2);
        this.key = StringUtils.defaultIfBlank(StringUtils.trimToEmpty(string3), this.contextPath);
        this.discoveredRoutes = new HashSet<DiscoveredRoute>();
        this.artifact = file;
        String string6 = StringUtils.trimToNull(string5);
        if (string6 != null && string6.length() > 256) {
            string6 = string6.substring(0, 256);
        }
        this.version = string6;
        String string7 = StringUtils.trimToNull(e2.getOrNull(this.context, ConfigProperty.APPLICATION_NAME));
        if (StringUtils.isNotBlank(string7)) {
            this.name = string7;
            this.configuredAppNameUsed = true;
        } else {
            this.name = StringUtils.isBlank(string) ? (DEFAULT_CONTEXT_PATH.equals(this.contextPath) ? StringUtils.defaultIfBlank(e2.getOrNull(this.context, ConfigProperty.ROOTAPP), DEFAULT_ROOT_APP_NAME) : StringUtils.removeStart(this.contextPath, DEFAULT_CONTEXT_PATH)) : string;
        }
        this.resolvedFilePath = string4 != null ? string4 : "";
        this.inventoryProvider = inventoryProvider;
        this.eventListener = Objects.requireNonNull(c2);
        g g2 = this.otelApp = otelGlobalConfig.isOtelEnabled() ? g.a(otelGlobalConfig, e2, this) : g.a;
        if (bl2) {
            this.readyForCreation();
        }
    }

    public String getSettingsLastModified() {
        return this.settingsLastModified;
    }

    public void setSettingsLastModified(String string) {
        this.settingsLastModified = string;
    }

    public void addDiscoveredRoutes(Collection<DiscoveredRoute> collection) {
        this.addDiscoveredRoutes(collection, false, com.contrastsecurity.agent.plugins.route.a::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveredRoutes(Collection<DiscoveredRoute> collection, boolean bl2, Supplier<com.contrastsecurity.agent.plugins.route.c> supplier) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Collection<DiscoveredRoute> collection2 = this.discoveredRoutes;
        synchronized (collection2) {
            this.discoveredRoutes.addAll(collection);
            if (bl2 || this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
                Map map = this.context.getOrComputeIfAbsent(DISCOVERED_ROUTES_KEY, HashMap::new);
                for (DiscoveredRoute discoveredRoute : collection) {
                    com.contrastsecurity.agent.plugins.route.c c2 = map.computeIfAbsent(discoveredRoute.signature(), string -> (com.contrastsecurity.agent.plugins.route.c)supplier.get());
                    c2.b(discoveredRoute.url());
                }
            }
            logger.debug("{} routes added to application: {}", (Object)collection.size(), (Object)this);
        }
    }

    private void mergeDiscoveredRouteMappingsFromContext(Map<String, com.contrastsecurity.agent.plugins.route.c> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Map<String, com.contrastsecurity.agent.plugins.route.c> map2 = this.context().putIfAbsent(DISCOVERED_ROUTES_KEY, map);
        if (map2 == null) {
            return;
        }
        for (String string : map.keySet()) {
            com.contrastsecurity.agent.plugins.route.c c2;
            com.contrastsecurity.agent.plugins.route.c c3 = map2.putIfAbsent(string, c2 = map.get(string));
            if (c3 == null) continue;
            for (String string2 : c2.a()) {
                c3.b(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<DiscoveredRoute> getUnreportedDiscoveredRoutes() {
        Collection<DiscoveredRoute> collection = this.discoveredRoutes;
        synchronized (collection) {
            Set<DiscoveredRoute> set = Sets.copy(this.discoveredRoutes);
            this.discoveredRoutes.clear();
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDiscoveredRoutesDirty() {
        Collection<DiscoveredRoute> collection = this.discoveredRoutes;
        synchronized (collection) {
            return !this.discoveredRoutes.isEmpty();
        }
    }

    public void addIfAbsentLibraryFacts(String string, LibraryFacts libraryFacts) {
        this.setInventoryTags(libraryFacts);
        LibraryFacts libraryFacts2 = this.libraryUsage.putIfAbsent(string, libraryFacts);
        if (libraryFacts2 == null) {
            this.sendEventLibraryFound(libraryFacts);
        }
    }

    public void addLibraryFacts(String string, LibraryFacts libraryFacts) {
        this.setInventoryTags(libraryFacts);
        this.sendEventLibraryFound(libraryFacts);
        this.libraryUsage.put(string, libraryFacts);
    }

    public void addTechnology(String string) {
        this.technologies.add(string);
        this.sendEventTechnologyDiscovered(string);
        this.markDirty(b.c);
    }

    @Deprecated
    @p
    public void addTestRuleExceptionDTM(RuleExceptionDTM ruleExceptionDTM) {
        if (this.testExclusionProcessor == null) {
            this.testExclusionProcessor = new DefaultExclusionProcessor();
        }
        logger.debug("Adding test exclusion");
        this.testExclusionProcessor.addRuleExceptionDTM(ruleExceptionDTM);
        logger.debug("Exclusion added to test processor, rebuilding app exclusions");
        this.refreshAppExclusions(this.settingsDTM);
    }

    @p
    public void clearTestRuleExceptions() {
        this.testExclusionProcessor = null;
    }

    @p
    public void applySettings(ApplicationSettingsDTM applicationSettingsDTM, long l2) {
        Objects.requireNonNull(applicationSettingsDTM);
        if (logger.isDebugEnabled()) {
            logger.debug("Applying app settings to {}", (Object)this.key);
        }
        this.settingsDTM = applicationSettingsDTM;
        this.refreshAppExclusions(applicationSettingsDTM);
        this.lastAppSettingsUpdatedProcessed = l2;
    }

    public AppActivity clearActivity() {
        return this.activity.getAndSet(new AppActivity());
    }

    public boolean containsTechnology(String string) {
        return this.technologies.contains(string);
    }

    public ApplicationExecutionContext context() {
        return this.context;
    }

    public AppActivity getActivity() {
        return this.activity.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @p
    Collection<SoftReference<Runnable>> getActionsBuffer() {
        Object object = this.createdLock;
        synchronized (object) {
            return this.actionsBuffer;
        }
    }

    public Collection<LibraryFacts> getAllLibraryFacts() {
        return Collections.unmodifiableCollection(this.getLibraryUsage().values());
    }

    public ClassLoader getClassloader() {
        return (ClassLoader)this.classloaderRef.get();
    }

    public i getExclusionProcessor() {
        return this.exclusionProcessor;
    }

    @Deprecated
    @p
    public void setExclusionProcessor(i i2) {
        this.exclusionProcessor = i2;
    }

    public c getState() {
        return this.applicationState;
    }

    String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public long getLastActivityReportedTime() {
        return this.lastActivityReportedTime;
    }

    public void setLastActivityReportedTime(long l2) {
        this.lastActivityReportedTime = l2;
    }

    public long getLastAppSettingsUpdatedProcessed() {
        return this.lastAppSettingsUpdatedProcessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastChangeOccurred() {
        EnumSet<b> enumSet = this.dirtyReasons;
        synchronized (enumSet) {
            return this.lastChangeOccurred;
        }
    }

    public long getLastReportedTime() {
        return this.lastReportedTime;
    }

    @p
    public void setLastReportedTime(long l2) {
        this.lastReportedTime = l2;
    }

    public Set<String> getLibraryFactNames() {
        return this.getLibraryUsage().keySet();
    }

    public LibraryFacts getLibraryFactsFor(String string) {
        return this.getLibraryUsage().get(string);
    }

    @p
    public Map<String, LibraryFacts> getLibraryUsage() {
        return this.libraryUsage;
    }

    public String getResolvedFilePath() {
        return this.resolvedFilePath;
    }

    public String getSessionId() {
        return this.config.getOrNull(this.context(), ConfigProperty.SESSION_ID);
    }

    public final String getOrCalculateSessionMetadata() {
        String string = this.config.getOrNull(this.context(), ConfigProperty.SESSION_METADATA);
        if (string != null) {
            return string;
        }
        String string2 = this.getSessionId();
        if (string2 != null) {
            return null;
        }
        String string3 = this.context().getOrComputeIfAbsent(ARTIFACT_HASH_SESSION_METADATA, this::calculateSessionMetadata);
        if (string3 == UNABLE_TO_CALCULATE_ARTIFACT_HASH) {
            return null;
        }
        return string3;
    }

    private String calculateSessionMetadata() {
        long l2 = com.contrastsecurity.agent.services.ngreporting.c.a(this.artifact);
        if (l2 != 0L) {
            return "artifactHash=" + Long.toHexString(l2);
        }
        return UNABLE_TO_CALCULATE_ARTIFACT_HASH;
    }

    @p
    public final ScreenerApplication newScreenerApplicationDtm(String string) {
        String string2 = this.calculateSessionMetadata();
        if (string2 == UNABLE_TO_CALCULATE_ARTIFACT_HASH) {
            string2 = null;
        }
        return new ScreenerApplication(this.getName(), this.getContextPath(), string, string2);
    }

    @Deprecated
    @p
    public ApplicationSettingsDTM getSettingsDTM() {
        return this.settingsDTM;
    }

    public Set<String> getTechnologies() {
        return this.technologies;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasLibraryFactsFor(String string) {
        return this.getLibraryUsage().containsKey(string);
    }

    public com.contrastsecurity.agent.apps.b id() {
        return com.contrastsecurity.agent.apps.b.a(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppUpdateDirty() {
        EnumSet<b> enumSet = this.dirtyReasons;
        synchronized (enumSet) {
            return !this.dirtyReasons.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<b> appUpdateDirtyReasons() {
        EnumSet<b> enumSet = this.dirtyReasons;
        synchronized (enumSet) {
            return EnumSet.copyOf(this.dirtyReasons);
        }
    }

    boolean isDirty() {
        return this.isAppUpdateDirty() || this.isDiscoveredRoutesDirty();
    }

    public boolean isUnwanted() {
        return this.unwanted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @p
    void markClean() {
        EnumSet<b> enumSet = this.dirtyReasons;
        synchronized (enumSet) {
            this.dirtyReasons.clear();
        }
        logger.debug("Application marked clean: {}", (Object)this);
    }

    void readyForCreation() {
        if (this.applicationState == c.a) {
            logger.debug("App ready for creation on remote server: {}", (Object)this);
            this.applicationState = c.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void created() {
        if (this.applicationState.f()) {
            Collection<SoftReference<Runnable>> collection;
            logger.debug("App successfully created and ready for inventory: {}", (Object)this);
            Iterator<SoftReference<Runnable>> iterator = this.createdLock;
            synchronized (iterator) {
                this.applicationState = c.c;
                collection = this.actionsBuffer;
                this.actionsBuffer = new ArrayList<SoftReference<Runnable>>();
            }
            for (SoftReference<Runnable> softReference : collection) {
                Runnable runnable = softReference.get();
                if (runnable == null) continue;
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty(b b2) {
        long l2;
        long l3;
        EnumSet<b> enumSet = this.dirtyReasons;
        synchronized (enumSet) {
            this.dirtyReasons.add(b2);
            l3 = this.lastChangeOccurred;
            this.lastChangeOccurred = l2 = System.currentTimeMillis();
        }
        logger.debug("Application marked dirty for: {}, {}", (Object)b2, (Object)this);
        logger.debug("Changing last change time for {} from {} to {}", this, l3, l2);
    }

    void inventoried() {
        if (this.applicationState == c.d) {
            logger.debug("App successfully inventoried: {}", (Object)this);
            this.applicationState = c.e;
            this.markDirty(b.b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.contrastsecurity.agent.plugins.apps.i reportForAppUpdate(long l2) {
        EnumSet<b> enumSet = this.dirtyReasons;
        synchronized (enumSet) {
            this.dirtyReasons.clear();
            com.contrastsecurity.agent.plugins.apps.i i2 = new com.contrastsecurity.agent.plugins.apps.i(this, l2);
            this.lastReportedTime = l2;
            return i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenCreated(Runnable runnable) {
        Runnable runnable2 = null;
        Object object = this.createdLock;
        synchronized (object) {
            if (this.unwanted) {
                return;
            }
            if (this.applicationState.c()) {
                runnable2 = runnable;
            } else {
                this.actionsBuffer.add(new SoftReference<Runnable>(runnable));
            }
        }
        if (runnable2 != null) {
            runnable2.run();
        }
    }

    public void recreate() {
        if (this.applicationState.b()) {
            logger.debug("Remote server requested app recreation");
            this.applicationState = c.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnwanted() {
        Object object = this.createdLock;
        synchronized (object) {
            this.unwanted = true;
            this.actionsBuffer.clear();
        }
    }

    public int numberOfLibraryFacts() {
        return this.getLibraryUsage().size();
    }

    boolean startInventory() {
        if (this.applicationState.a()) {
            this.applicationState = c.d;
            logger.debug("App inventory in progress {}", (Object)this);
            if (this.inventoryProvider != null) {
                this.inventoryProvider.inventory(this);
            }
        }
        return this.applicationState == c.d;
    }

    private void inventoryFailed(InventoryException inventoryException) {
        if (this.applicationState == c.d) {
            this.applicationState = c.c;
            logger.debug("App inventory failed {}", (Object)this, (Object)inventoryException);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public g otel() {
        return this.otelApp;
    }

    public String toString() {
        return "Application{classLoader='" + this.classLoader + '\'' + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", resolvedFilePath='" + this.resolvedFilePath + '\'' + ", contextPath='" + this.contextPath + '\'' + ", applicationState=" + (Object)((Object)this.applicationState) + ", version='" + this.version + '\'' + '}';
    }

    private void refreshAppExclusions(ApplicationSettingsDTM applicationSettingsDTM) {
        i i2 = this.exclusionProcessor;
        if (applicationSettingsDTM != null) {
            try {
                i2 = f.a(applicationSettingsDTM.getExceptions());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Problem parsing TeamServer exclusion settings", illegalArgumentException);
            }
        }
        this.exclusionProcessor = this.testExclusionProcessor == null ? i2 : new ChainedExclusionProcessor(Lists.of(i2, this.testExclusionProcessor));
    }

    private void sendEventLibraryFound(LibraryFacts libraryFacts) {
        this.eventListener.a(this, libraryFacts);
    }

    private void sendEventTechnologyDiscovered(String string) {
        this.eventListener.a(string);
    }

    private void setInventoryTags(LibraryFacts libraryFacts) {
        if (libraryFacts == null) {
            return;
        }
        libraryFacts.setTags(StringUtils.trimToNull(this.config.getOrNull(this.context, ConfigProperty.INVENTORY_TAGS)));
    }

    private static String checkContextPath(String string) {
        return StringUtils.defaultIfBlank(StringUtils.trimToEmpty(string), DEFAULT_CONTEXT_PATH);
    }

    @p
    static i mergeExclusionProcessors(Application application, Application application2) {
        LinkedHashSet<i> linkedHashSet = new LinkedHashSet<i>();
        linkedHashSet.addAll(application.getExclusionProcessor().getProcessors());
        linkedHashSet.addAll(application2.getExclusionProcessor().getProcessors());
        linkedHashSet.remove(i.a);
        if (linkedHashSet.isEmpty()) {
            return i.a;
        }
        if (linkedHashSet.size() == 1) {
            return (i)linkedHashSet.iterator().next();
        }
        return new ChainedExclusionProcessor(linkedHashSet);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Application application = (Application)object;
        return Objects.equals(this.key, application.key);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public static enum b {
        a,
        b,
        c;

    }

    @Deprecated
    @DontObfuscate
    public static abstract class InventoryProvider {
        private int attemptCount;
        static final Integer MAX_ALLOWED_ATTEMPTS = 5;

        void inventory(Application application) {
            if (++this.attemptCount <= MAX_ALLOWED_ATTEMPTS) {
                try {
                    this.doInventory(application);
                }
                catch (InventoryException inventoryException) {
                    application.inventoryFailed(inventoryException);
                }
                return;
            }
            logger.debug("Stopped trying to inventory after the maximum number of attempts {}", (Object)MAX_ALLOWED_ATTEMPTS);
        }

        protected abstract void doInventory(Application var1) throws InventoryException;
    }

    static final class a {
        private final Application a;
        private final boolean b;

        a(e e2, com.contrastsecurity.agent.o.c c2, OtelGlobalConfig otelGlobalConfig) {
            this.a = new Application(null, null, null, e2, null, null, null, null, m.a(Thread.currentThread()), false, c2, otelGlobalConfig, null);
            String string = StringUtils.trimToNull(e2.getOrNull(ConfigProperty.STANDALONE_APPNAME));
            if (string != null) {
                this.a.name = string;
                this.b = true;
            } else {
                this.b = false;
            }
        }

        boolean a() {
            return this.b;
        }

        Application b() {
            return this.a;
        }

        void a(String string, String string2, File file, e e2) {
            if (this.a.getState().b()) {
                logger.debug("Cannot prepare app for creation as app is already resolved: {}", (Object)this.a);
                return;
            }
            if (!this.b && !this.a.configuredAppNameUsed && StringUtils.isNotBlank(string)) {
                this.a.name = string;
            }
            this.a.otel().a(this.a, e2);
            this.a.contextPath = Application.checkContextPath(string2);
            this.a.artifact = file;
            this.a.readyForCreation();
            this.a.unwanted = false;
        }

        void c() {
            if (this.a.getState().d()) {
                this.a.applicationState = c.c;
                logger.debug("Marking app ready for re-inventory: {}", (Object)this);
            }
        }

        void a(Application application) {
            for (String object22 : application.getTechnologies()) {
                this.a.addTechnology(object22);
            }
            this.a.exclusionProcessor = Application.mergeExclusionProcessors(this.a, application);
            Map<String, LibraryFacts> map = application.getLibraryUsage();
            for (Map.Entry entry : map.entrySet()) {
                LibraryFacts libraryFacts = (LibraryFacts)this.a.libraryUsage.get(entry.getKey());
                if (libraryFacts == null) {
                    this.a.libraryUsage.put((String)entry.getKey(), (LibraryFacts)entry.getValue());
                    continue;
                }
                Failsafe.with((Policy)RETRY_POLICY, (Policy[])new RetryPolicy[0]).run(() -> libraryFacts.merge((LibraryFacts)entry.getValue()));
            }
            AppActivity appActivity = this.a.getActivity();
            appActivity.merge(application.clearActivity());
            this.a.activity.set(appActivity);
            this.a.addDiscoveredRoutes(application.getUnreportedDiscoveredRoutes());
            Map map2 = application.context().get(DISCOVERED_ROUTES_KEY);
            this.a.mergeDiscoveredRouteMappingsFromContext(map2);
            application.markClean();
            logger.debug("Application successfully merged into DefaultApp: {}", (Object)application);
        }

        void d() {
            if (!this.a.unwanted) {
                logger.debug("Disabling the default application {}", (Object)this.a);
            }
            this.a.markUnwanted();
            this.a.applicationState = c.a;
            this.a.clearActivity();
            this.a.libraryUsage.clear();
        }
    }
}

