/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.msgpack.core.annotations.VisibleForTesting;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@DontObfuscate
public final class ApplicationContext
implements b<ApplicationContext> {
    private static final ConcurrentReferenceHashMap<ClassLoader, Set<Application>> APPLICATION_CLASS_LOADERS = new ConcurrentReferenceHashMap(10, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private static final Map<String, Application> APPLICATION_KEYS = new ConcurrentHashMap<String, Application>();
    private static final AtomicReference<Application.a> DEFAULT_APP_REF = new AtomicReference<Object>(null);
    private static final AtomicBoolean IS_STANDALONE_MODE = new AtomicBoolean(false);
    private Application currentApplication;

    public ApplicationContext() {
        this(null);
    }

    private ApplicationContext(Application application) {
        this.currentApplication = application;
    }

    public void clear() {
        this.currentApplication = null;
    }

    @VisibleForTesting
    public void resetForTesting() {
        this.clear();
        APPLICATION_KEYS.clear();
        APPLICATION_CLASS_LOADERS.clear();
        IS_STANDALONE_MODE.set(false);
    }

    @Override
    public ApplicationContext copy() {
        return new ApplicationContext(this.currentApplication);
    }

    public Application current() {
        Application application = this._current();
        return application == null || application.isUnwanted() ? null : application;
    }

    public Application current(Application application) {
        if (application == null) {
            this.currentApplication = null;
            return null;
        }
        Application application2 = DEFAULT_APP_REF.get().b();
        if (application == application2) {
            return application;
        }
        this.currentApplication = application;
        return IS_STANDALONE_MODE.get() ? application2 : application;
    }

    public static Collection<Application> all() {
        return IS_STANDALONE_MODE.get() ? Collections.singleton(DEFAULT_APP_REF.get().b()) : Collections.unmodifiableCollection(APPLICATION_KEYS.values());
    }

    public static Application findByKey(String string) {
        Map<String, Application> map = ApplicationContext.applicationKeys();
        if (string == null || map.isEmpty()) {
            a.a.trace("Key was null or there were no applications, key: {}", (Object)string);
            return null;
        }
        Application application = map.get(StringUtils.defaultIfBlank(StringUtils.trimToEmpty(string), "/"));
        a.a.trace("ApplicationManager#findByKey: key: {}, app: {}", (Object)string, (Object)application);
        return application;
    }

    public static Collection<Application> findByClassLoader(ClassLoader classLoader) {
        Collection collection;
        if (!APPLICATION_CLASS_LOADERS.keys().hasMoreElements()) {
            return Collections.emptySet();
        }
        if (classLoader == null) {
            a.a.trace("ClassLoader was null, assuming Bootstrap ClassLoader and returning all apps");
            collection = APPLICATION_KEYS.values();
        } else {
            collection = APPLICATION_CLASS_LOADERS.getOrDefault(classLoader, Collections.emptySet());
        }
        a.a.trace("ApplicationManager#findByClassLoader: classLoader: {}, apps: {}", (Object)classLoader, (Object)collection);
        return Collections.unmodifiableCollection(collection);
    }

    static Application.a defaultApplication() {
        return DEFAULT_APP_REF.get();
    }

    static void defaultApplication(Application.a a2) {
        DEFAULT_APP_REF.getAndSet(Objects.requireNonNull(a2));
    }

    static ConcurrentReferenceHashMap<ClassLoader, Set<Application>> applicationClassLoaders() {
        return APPLICATION_CLASS_LOADERS;
    }

    static Map<String, Application> applicationKeys() {
        return APPLICATION_KEYS;
    }

    static boolean isStandaloneMode() {
        return IS_STANDALONE_MODE.get();
    }

    static void enableStandaloneMode() {
        IS_STANDALONE_MODE.getAndSet(true);
    }

    private Application _current() {
        if (IS_STANDALONE_MODE.get()) {
            return ApplicationContext.defaultApplication().b();
        }
        if (this.currentApplication != null) {
            return this.currentApplication;
        }
        Collection<Application> collection = ApplicationContext.findByClassLoader(m.a(Thread.currentThread()));
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return null;
    }

    private static final class a {
        private static final Logger a = LoggerFactory.getLogger(ApplicationContext.class);

        private a() {
        }
    }
}

