/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationContext;
import com.contrastsecurity.agent.apps.RouteDiscoveryListener;
import com.contrastsecurity.agent.apps.java.c;
import com.contrastsecurity.agent.apps.java.codeinfo.b;
import com.contrastsecurity.agent.apps.java.codeinfo.d;
import com.contrastsecurity.agent.apps.java.e;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Pair;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.context.ApplicationExecutionContextImpl;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.core.ContrastAgent;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.opentelemetry.OtelGlobalConfig;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.plugins.frameworks.h;
import com.contrastsecurity.agent.plugins.frameworks.l;
import com.contrastsecurity.agent.plugins.security.RegexSecurityControls;
import com.contrastsecurity.agent.services.Purgeable;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DontObfuscate
@n
public class ApplicationManager
implements Purgeable {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationManager.class);
    private final PluginManager pluginManager;
    private final com.contrastsecurity.agent.h.b environmentInfo;
    private final com.contrastsecurity.agent.config.e config;
    private final a jarAnalyzerFactory;
    private final RouteDiscoveryListener routeDiscoveryListener;
    private final com.contrastsecurity.agent.config.l effectiveConfigListener;
    private final com.contrastsecurity.agent.o.c eventListener;
    private final OtelGlobalConfig otelGlobalConfig;
    private final RegexSecurityControls regexSecurityControls;
    @p
    static final String GAUGE_NUMBER_APPLICATIONS = "numberOfApplications";

    public ApplicationManager(com.contrastsecurity.agent.h.b b2, ConfigUpdatable configUpdatable, b b3, PluginManager pluginManager, Clock clock, RouteDiscoveryListener routeDiscoveryListener, com.contrastsecurity.agent.config.l l2, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.o.c c2, OtelGlobalConfig otelGlobalConfig) {
        this(b2, configUpdatable, b3, pluginManager, clock, routeDiscoveryListener, new Application.a(configUpdatable, c2, otelGlobalConfig), l2, telemetryMetrics, c2, otelGlobalConfig);
    }

    @p
    ApplicationManager(com.contrastsecurity.agent.h.b b2, ConfigUpdatable configUpdatable, b b3, PluginManager pluginManager, Clock clock, RouteDiscoveryListener routeDiscoveryListener, Application.a a2, com.contrastsecurity.agent.config.l l2, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.o.c c2, OtelGlobalConfig otelGlobalConfig) {
        this.pluginManager = Objects.requireNonNull(pluginManager);
        this.environmentInfo = Objects.requireNonNull(b2);
        this.config = Objects.requireNonNull(configUpdatable);
        this.routeDiscoveryListener = Objects.requireNonNull(routeDiscoveryListener);
        this.jarAnalyzerFactory = new a(Objects.requireNonNull(b3), clock, configUpdatable);
        ApplicationContext.defaultApplication(a2);
        if (a2.a()) {
            this.enableStandaloneModeFromConfig(null, null);
        }
        this.effectiveConfigListener = l2;
        configUpdatable.initializeEffectiveConfigUpdateListener(this.effectiveConfigListener);
        telemetryMetrics.newGauge(GAUGE_NUMBER_APPLICATIONS, TelemetryMetrics.TelemetryCategory.ENVIRONMENT_PARAMETERS).a("Describes the number of applications currently served by this Agent instance.").a(this, object -> ApplicationContext.isStandaloneMode() ? 1.0 : (double)ApplicationContext.applicationKeys().size()).a();
        this.eventListener = Objects.requireNonNull(c2);
        this.otelGlobalConfig = Objects.requireNonNull(otelGlobalConfig);
        this.regexSecurityControls = new RegexSecurityControls();
    }

    @Override
    public void purgeStale(ContrastContext contrastContext) {
        this.jarAnalyzerFactory.purgeStale(contrastContext);
        ApplicationContext.applicationClassLoaders().purgeStaleEntries();
    }

    @Override
    public int purgeableCount(ContrastContext contrastContext) {
        return this.jarAnalyzerFactory.purgeableCount(contrastContext);
    }

    public Application enableStandaloneModeFromEmbedded(String string, String string2, File file, h h2) {
        return this.enableStandaloneMode(string, string2, file, "EMBEDDED_" + h2.toString());
    }

    public Application enableStandaloneModeFromEmbedded(String string, String string2, h h2) {
        Pair pair = m.a(() -> com.contrastsecurity.agent.apps.a.a.a(string));
        return this.enableStandaloneModeFromEmbedded((String)pair.left(), string2, (File)pair.right(), h2);
    }

    public Application enableStandaloneModeFromConfig(String string, String string2) {
        return this.enableStandaloneMode(string, string2, null, "CONFIG");
    }

    private Application enableStandaloneMode(String string, String string2, File file, String string3) {
        Application.a a2 = ApplicationContext.defaultApplication();
        if (ApplicationContext.isStandaloneMode()) {
            logger.debug("Standalone mode already turned on, attempted for appName={}, contextPath={}, reason={}", string, string2, string3);
            return a2.b();
        }
        logger.debug("Enabling standalone app mode: appName={}, contextPath={}, reason={}", string, string2, string3);
        a2.a(string, string2, file, this.config);
        ApplicationManager.updateClassLoaders(a2.b(), null);
        ApplicationContext.enableStandaloneMode();
        return a2.b();
    }

    public Application createApplication(ContrastContext contrastContext, String string, String string2, String string3, String string4, String string5, String string6, ClassLoader classLoader, Application.InventoryProvider inventoryProvider) {
        return this.createApplication(contrastContext, string, string2, string3, string4, string5, string6, classLoader, inventoryProvider, null);
    }

    public Application createApplication(ContrastContext contrastContext, String string, String string2, String string3, String string4, String string5, String string6, ClassLoader classLoader, Application.InventoryProvider inventoryProvider, File file) {
        ApplicationExecutionContextImpl applicationExecutionContextImpl = new ApplicationExecutionContextImpl();
        if (StringUtils.isNotBlank(string4)) {
            if (com.contrastsecurity.agent.config.p.a(string4)) {
                this.config.initializeApplicationConfig(applicationExecutionContextImpl, string4);
            } else {
                logger.error(com.contrastsecurity.agent.config.p.c(string4));
            }
        }
        ClassLoader classLoader2 = classLoader == null ? m.a(Thread.currentThread()) : classLoader;
        Application application = new Application(string, string2, string3, this.config, string5, string6, inventoryProvider, applicationExecutionContextImpl, classLoader2, this.eventListener, this.otelGlobalConfig, file);
        logger.debug("Created new application {}", (Object)application);
        String string7 = StringUtils.trimToNull(this.config.getOrNull(applicationExecutionContextImpl, ConfigProperty.APPLICATION_NAME));
        Map<String, Application> map = ApplicationContext.applicationKeys();
        boolean bl2 = ApplicationContext.isStandaloneMode();
        if (!map.isEmpty() && !bl2 && StringUtils.isNotBlank(string7)) {
            String string8 = "Multiple apps detected with the same name on the same server. Indicates misuse of `contrast.application.name`. This action can cause issues with reporting data to TeamServer. This behavior can be fixed by grouping via application tags. More information found here: https://support.contrastsecurity.com/hc/en-us/articles/360052187171-Multi-Application-configuration-with-Contrast-Profiles";
            com.contrastsecurity.agent.logging.a.c("APPLICATION_NAME_MISUSED", logger, "Multiple apps detected with the same name on the same server. Indicates misuse of `contrast.application.name`. This action can cause issues with reporting data to TeamServer. This behavior can be fixed by grouping via application tags. More information found here: https://support.contrastsecurity.com/hc/en-us/articles/360052187171-Multi-Application-configuration-with-Contrast-Profiles");
        }
        map.put(application.getKey(), application);
        ApplicationManager.updateClassLoaders(application, classLoader2);
        if (bl2) {
            logger.debug("Marking application {} as unwanted because it is not the default app and the agent is in standalone mode", (Object)application);
            application.markUnwanted();
            ApplicationContext.defaultApplication().c();
        } else if (ContrastAgent.isDelayedBoot(this.config)) {
            logger.warn("Delayed boot should be used with {} in order to ensure that Contrast discovers the application correctly.", (Object)ConfigProperty.STANDALONE_APPNAME.commonConfigPathOrNull());
        }
        this.effectiveConfigListener.a(application);
        logger.debug("App {} has been created and is ready for creation on remote server", (Object)application);
        return application;
    }

    public com.contrastsecurity.agent.h.b getEnvironmentInfo() {
        return this.environmentInfo;
    }

    public void onApplicationUpdate(ContrastContext contrastContext, Application application) {
        if (application == null || application.isUnwanted()) {
            return;
        }
        this.routeDiscoveryListener.onRoutesDiscovered(contrastContext, application.getUnreportedDiscoveredRoutes(), application);
    }

    public void inventory(l l2, Application application) {
        boolean bl2 = ApplicationContext.isStandaloneMode();
        if (!application.getState().a() && !bl2) {
            logger.debug("Application is not ready or has already been inventoried: {}", (Object)application);
        }
        if (bl2) {
            Application.a a2 = ApplicationContext.defaultApplication();
            for (Application application2 : ApplicationContext.applicationKeys().values()) {
                application2.created();
                if ((!application2.getState().a() || !this._inventory(l2, application2, bl2)) && !application2.isDirty()) continue;
                a2.a(application2);
            }
        } else {
            ApplicationContext.defaultApplication().d();
        }
        this._inventory(l2, application, bl2);
    }

    private boolean _inventory(l l2, Application application, boolean bl2) {
        if (application.startInventory()) {
            if (com.contrastsecurity.agent.apps.e.a(this.config, ConfigProperty.INVENTORY_LIBRARIES)) {
                this.determineLibrariesByFramework(l2, application, bl2);
            } else {
                logger.debug("Ignoring framework library analysis");
            }
            application.inventoried();
            logger.debug("Application successfully inventoried: {}", (Object)application);
            for (ContrastPlugin contrastPlugin : this.pluginManager.getPlugins()) {
                contrastPlugin.onApplicationInventoried(application);
            }
            return true;
        }
        return false;
    }

    private static void updateClassLoaders(Application application, ClassLoader classLoader2) {
        if (classLoader2 == null && (classLoader2 = m.a(Thread.currentThread())) == null) {
            logger.debug("ClassLoader was null, assuming Bootstrap ClassLoader");
            return;
        }
        ConcurrentReferenceHashMap<ClassLoader, Set<Application>> concurrentReferenceHashMap = ApplicationContext.applicationClassLoaders();
        ApplicationManager.accessibleClassloaders(classLoader2).forEach(classLoader -> concurrentReferenceHashMap.merge((ClassLoader)classLoader, Collections.singleton(application), (set, set2) -> Stream.of(set, set2).flatMap(Collection::stream).collect(Collectors.toSet())));
    }

    @p
    Set<d> getLibraryFinders(l l2, Application application, boolean bl2) {
        LinkedHashSet<d> linkedHashSet = new LinkedHashSet<d>();
        List<com.contrastsecurity.agent.plugins.frameworks.n> list = l2.c();
        com.contrastsecurity.agent.apps.java.codeinfo.a a2 = this.jarAnalyzerFactory.a();
        if (bl2 || this.config.getBoolean(application.context(), ConfigProperty.CLASSPATH_LIBS)) {
            linkedHashSet.add(new c(this.environmentInfo, a2));
        }
        for (com.contrastsecurity.agent.plugins.frameworks.n object : list) {
            object.a(linkedHashSet, application, a2);
        }
        String string = this.config.getOrNull(application.context(), ConfigProperty.EXTERNAL_LIB_DIR);
        if (StringUtils.isNotBlank(string)) {
            List<String> list2 = Collections.unmodifiableList(Arrays.asList(string.split(File.pathSeparator)));
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string2 : list2) {
                File file = new File(string2);
                if (file.exists() && file.isDirectory()) {
                    arrayList.add(new File(string2));
                    continue;
                }
                logger.warn("Skipping external library directory: {} because it does not exist or is not a directory.", (Object)string2);
            }
            linkedHashSet.add(new e(a2, arrayList));
        }
        logger.debug("Application {} will use the following LibraryFinders: {}", (Object)application, (Object)linkedHashSet);
        return linkedHashSet;
    }

    private void determineLibrariesByFramework(l l2, Application application, boolean bl2) {
        Set<d> set = this.getLibraryFinders(l2, application, bl2);
        for (d d2 : set) {
            d2.a(application);
        }
    }

    public RouteDiscoveryListener getRouteDiscoveryListener() {
        return this.routeDiscoveryListener;
    }

    public RegexSecurityControls regexSecurityControls() {
        return this.regexSecurityControls;
    }

    @p
    static Set<ClassLoader> accessibleClassloaders(ClassLoader classLoader) {
        Sets.Builder<ClassLoader> builder = Sets.builder();
        for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            builder.add(classLoader2);
        }
        return builder.build();
    }

    private static final class a
    implements Purgeable {
        private final b a;
        private final long b;
        private final Clock c;
        private com.contrastsecurity.agent.apps.java.codeinfo.a d;
        private long e;

        private a(b b2, Clock clock, com.contrastsecurity.agent.config.e e2) {
            this.a = b2;
            this.c = clock;
            this.b = e2.getLong(ConfigProperty.APPMGR_JARANALYZER_TTL);
        }

        private synchronized com.contrastsecurity.agent.apps.java.codeinfo.a a() {
            if (this.d == null) {
                this.e = this.c.now();
                this.d = this.a.a();
            }
            return this.d;
        }

        @Override
        public synchronized void purgeStale(ContrastContext contrastContext) {
            if (this.c.now() - this.e >= this.b) {
                this.d = null;
            }
        }

        @Override
        public int purgeableCount(ContrastContext contrastContext) {
            return this.d == null ? 0 : 1;
        }
    }
}

