/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.contrastapi_v1_0;

import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.commons.NVP;
import com.contrastsecurity.agent.http.d;
import com.contrastsecurity.agent.http.e;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Maskable;
import com.contrastsecurity.agent.messages.Protocol;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class HttpRequestDTM
implements Maskable<HttpRequestDTM> {
    private final String body;
    private transient String cachedEncodedBody;
    private final String contextPath;
    private final Map<String, List<String>> headers;
    private final String method;
    private final transient int requestID;
    private final String standardNormalizedUri;
    private final Map<String, List<String>> parameters;
    private final Integer port;
    private final Protocol protocol;
    private final String queryString;
    private final String serverVersionInfo;
    private final String uri;
    private final HttpVersion version;
    private final transient String template;
    private final transient String normalizedTemplate;
    private final transient boolean isFormEncodedContentType;
    private final transient boolean isMultipartContentType;
    private final transient boolean isXMLContentType;
    private final transient String boundary;
    private final transient String path;
    private final transient String normalizedPath;
    private static final char BOM = '\ufeff';
    private static final Collection<Integer> ALLOWED_BODY_SPECIAL_CHARS = new HashSet<Integer>();

    private HttpRequestDTM(Builder builder) {
        this.body = builder.body;
        this.contextPath = builder.contextPath;
        this.headers = builder.headers;
        this.method = builder.method;
        this.requestID = builder.requestID;
        this.standardNormalizedUri = builder.normalizedUri;
        this.parameters = builder.parameters;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.queryString = builder.queryString;
        this.serverVersionInfo = builder.serverVersionInfo;
        this.uri = builder.uri;
        this.version = builder.version;
        this.template = builder.template;
        this.normalizedTemplate = builder.normalizedTemplate;
        this.isFormEncodedContentType = builder.isFormEncodedContentType;
        this.isMultipartContentType = builder.isMultipartContentType;
        this.isXMLContentType = builder.isXMLContentType;
        this.boundary = builder.boundary;
        this.path = builder.path;
        this.normalizedPath = builder.normalizedPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String body() {
        return this.body;
    }

    public String getEncodedBody() {
        if (this.cachedEncodedBody == null) {
            this.cachedEncodedBody = HttpRequestDTM.encode(this.body);
        }
        return this.cachedEncodedBody;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String getCookie() {
        return this.getHeader("Cookie");
    }

    public String getHeader(String string) {
        List<String> list = this.getHeaders(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getHeaders(String string) {
        if (this.headers == null || this.headers.isEmpty() || StringUtils.isBlank(string)) {
            return null;
        }
        List<String> list = this.headers.get(string);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        return null;
    }

    public NVP[] parseCookies() {
        String string = this.getCookie();
        if (string == null || string.isEmpty()) {
            return d.a;
        }
        return d.a(string);
    }

    public String method() {
        return this.method;
    }

    public String normalizedUri() {
        return this.standardNormalizedUri;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Integer port() {
        return this.port;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String queryString() {
        return this.queryString;
    }

    public String serverVersionInfo() {
        return this.serverVersionInfo;
    }

    public String uri() {
        return this.uri;
    }

    public HttpVersion version() {
        return this.version;
    }

    public String template() {
        return this.template;
    }

    public String normalizedTemplate() {
        return this.normalizedTemplate;
    }

    public boolean isFormEncodedContentType() {
        return this.isFormEncodedContentType;
    }

    public boolean isMultipartContentType() {
        return this.isMultipartContentType;
    }

    public boolean isXMLContentType() {
        return this.isXMLContentType;
    }

    public String boundary() {
        return this.boundary;
    }

    public int requestID() {
        return this.requestID;
    }

    public Builder toBuilder() {
        return new Builder().body(this.body).contextPath(this.contextPath).headers(this.headers).method(this.method).requestID(this.requestID).normalizedUri(this.standardNormalizedUri).parameters(this.parameters).port(this.port).protocol(this.protocol).queryString(this.queryString).serverVersionInfo(this.serverVersionInfo).uri(this.uri).version(this.version).template(this.template).isFormEncodedContentType(this.isFormEncodedContentType).isMultipartContentType(this.isMultipartContentType).isXMLContentType(this.isXMLContentType).boundary(this.boundary).template(this.template).path(this.path).normalizedPath(this.normalizedPath);
    }

    @Override
    public HttpRequestDTM mask() {
        Object object;
        Builder builder = this.toBuilder();
        String string = builder.contextPath;
        String string2 = builder.template;
        if (string2 != null) {
            Object object2 = object = builder.normalizedTemplate != null ? builder.normalizedTemplate : builder.template;
            if (string != null && !string2.startsWith(string)) {
                builder.uri(string + string2);
                builder.normalizedUri(string + (String)object);
            } else {
                builder.uri(string2);
                builder.normalizedUri((String)object);
            }
        } else {
            builder.uri(string + Maskable.maskUri(builder.path));
            builder.normalizedUri(string + Maskable.maskUri(builder.normalizedPath));
        }
        object = new HashMap();
        for (Object object3 : builder.headers.keySet()) {
            object.put(object3, Collections.singletonList("xxx"));
        }
        builder.headers((Map<String, List<String>>)object);
        HashMap hashMap = new HashMap();
        for (String string3 : builder.parameters.keySet()) {
            hashMap.put(string3, Collections.singletonList("xxx"));
        }
        builder.parameters(hashMap);
        builder.queryString("xxx");
        builder.body("xxx");
        return builder.build();
    }

    public String toString() {
        return "HttpRequestDTM{body='" + this.body + '\'' + ", contextPath='" + this.contextPath + '\'' + ", headers=" + this.headers + ", method='" + this.method + '\'' + ", standardNormalizedUri='" + this.standardNormalizedUri + '\'' + ", parameters=" + this.parameters + ", port=" + this.port + ", protocol=" + (Object)((Object)this.protocol) + ", queryString='" + this.queryString + '\'' + ", serverVersionInfo='" + this.serverVersionInfo + '\'' + ", uri='" + this.uri + '\'' + ", version=" + (Object)((Object)this.version) + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpRequestDTM httpRequestDTM = (HttpRequestDTM)object;
        return Objects.equals(this.body, httpRequestDTM.body) && Objects.equals(this.contextPath, httpRequestDTM.contextPath) && Objects.equals(this.headers, httpRequestDTM.headers) && Objects.equals(this.method, httpRequestDTM.method) && Objects.equals(this.standardNormalizedUri, httpRequestDTM.standardNormalizedUri) && Objects.equals(this.parameters, httpRequestDTM.parameters) && Objects.equals(this.port, httpRequestDTM.port) && this.protocol == httpRequestDTM.protocol && Objects.equals(this.queryString, httpRequestDTM.queryString) && Objects.equals(this.serverVersionInfo, httpRequestDTM.serverVersionInfo) && Objects.equals(this.uri, httpRequestDTM.uri) && this.version == httpRequestDTM.version;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.body, this.contextPath, this.headers, this.method, this.standardNormalizedUri, this.parameters, this.port, this.protocol, this.queryString, this.serverVersionInfo, this.uri, this.version});
    }

    public static String encode(String string) {
        int n2;
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = n2 = string.charAt(0) == '\ufeff' ? 1 : 0; i2 < string.length(); ++i2) {
            int n3 = string.codePointAt(i2);
            if (Character.isWhitespace(n3) || Character.isLetterOrDigit(n3)) {
                stringBuilder.append(Character.toChars(n3));
                continue;
            }
            if (ALLOWED_BODY_SPECIAL_CHARS.contains(n3)) {
                stringBuilder.append(e.a(n3));
                continue;
            }
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    static {
        char[] cArray = new char[]{'<', '>', '\"', '\'', '&', ';', '[', ']', '{', '}', '!', '@', '#', '$', '%', '^', '_', '-', '+', '=', ':', ';', '.', ',', '(', ')', '?', '|', '\\', '/'};
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            ALLOWED_BODY_SPECIAL_CHARS.add(Character.codePointAt(cArray, i2));
        }
    }

    public static final class Builder {
        private String body;
        private String contextPath;
        private Map<String, List<String>> headers;
        private String method;
        private int requestID;
        private String normalizedUri;
        private Map<String, List<String>> parameters;
        private Integer port;
        private Protocol protocol;
        private String queryString;
        private String serverVersionInfo;
        private String uri;
        private HttpVersion version;
        private String template;
        private String normalizedTemplate;
        private boolean isFormEncodedContentType;
        private boolean isMultipartContentType;
        private boolean isXMLContentType;
        private String boundary;
        private String path;
        private String normalizedPath;

        public Builder() {
        }

        public Builder(HttpRequestDTM httpRequestDTM) {
            this.body = httpRequestDTM.body;
            this.contextPath = httpRequestDTM.contextPath;
            this.headers = httpRequestDTM.headers;
            this.method = httpRequestDTM.method;
            this.requestID = httpRequestDTM.requestID;
            this.normalizedUri = httpRequestDTM.standardNormalizedUri;
            this.parameters = httpRequestDTM.parameters;
            this.port = httpRequestDTM.port;
            this.protocol = httpRequestDTM.protocol;
            this.queryString = httpRequestDTM.queryString;
            this.serverVersionInfo = httpRequestDTM.serverVersionInfo;
            this.uri = httpRequestDTM.uri;
            this.version = httpRequestDTM.version;
            this.template = httpRequestDTM.template;
            this.normalizedTemplate = httpRequestDTM.normalizedTemplate;
            this.isFormEncodedContentType = httpRequestDTM.isFormEncodedContentType;
            this.isMultipartContentType = httpRequestDTM.isMultipartContentType;
            this.isXMLContentType = httpRequestDTM.isXMLContentType;
            this.boundary = httpRequestDTM.boundary;
            this.path = httpRequestDTM.path;
        }

        public Builder body(String string) {
            this.body = string;
            return this;
        }

        public Builder contextPath(String string) {
            this.contextPath = string;
            return this;
        }

        public Builder headers(Map<String, List<String>> map) {
            if (map == null) {
                this.headers = Collections.emptyMap();
                return this;
            }
            this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(map);
            return this;
        }

        public Builder method(String string) {
            this.method = string;
            return this;
        }

        public Builder requestID(int n2) {
            this.requestID = n2;
            return this;
        }

        public Builder normalizedUri(String string) {
            this.normalizedUri = string;
            return this;
        }

        public Builder parameters(Map<String, List<String>> map) {
            this.parameters = map != null ? Maps.copy(map) : Collections.emptyMap();
            return this;
        }

        public Builder port(Integer n2) {
            this.port = n2;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder queryString(String string) {
            this.queryString = string;
            return this;
        }

        public Builder serverVersionInfo(String string) {
            this.serverVersionInfo = string;
            return this;
        }

        public Builder uri(String string) {
            this.uri = string;
            return this;
        }

        public Builder version(HttpVersion httpVersion) {
            this.version = httpVersion;
            return this;
        }

        public Builder template(String string) {
            this.template = string;
            return this;
        }

        public Builder normalizedTemplate(String string) {
            this.normalizedTemplate = string;
            return this;
        }

        public Builder isFormEncodedContentType(boolean bl2) {
            this.isFormEncodedContentType = bl2;
            return this;
        }

        public Builder isMultipartContentType(boolean bl2) {
            this.isMultipartContentType = bl2;
            return this;
        }

        public Builder isXMLContentType(boolean bl2) {
            this.isXMLContentType = bl2;
            return this;
        }

        public Builder boundary(String string) {
            this.boundary = string;
            return this;
        }

        public Builder path(String string) {
            this.path = string;
            return this;
        }

        public Builder normalizedPath(String string) {
            this.normalizedPath = string;
            return this;
        }

        public HttpRequestDTM build() {
            return new HttpRequestDTM(this);
        }
    }
}

