/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.c;
import com.contrastsecurity.agent.c.a;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Memoizer;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.core.ContrastVersion;
import com.contrastsecurity.agent.core.b;
import com.contrastsecurity.agent.f;
import com.contrastsecurity.agent.f.k;
import com.contrastsecurity.agent.g;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.e;
import com.contrastsecurity.agent.startup.x;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.telemetry.i;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.G;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.agent.util.VMArguments;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@DontObfuscate
public class ContrastAgent {
    private static final String DELAYED_BOOT_STRATEGY = "boot";
    private static final String DELAYED_ACTIVATION_STRATEGY = "activation";
    private static final String ERROR_PROBABILISTIC_VALUE = "Unable to process probabilistic startup value";

    public static void setup(String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        Objects.requireNonNull(instrumentation);
        ContrastContext.enableThreadLocal();
        ContrastAgent.scopedSetup(string, instrumentation, file, startupTiming);
    }

    @ScopedSensor
    public static void scopedSetup(String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            ConfigUpdatable configUpdatable;
            com.contrastsecurity.agent.s.a.a(file);
            G g2 = H.b();
            ContrastAgent.patchLiferayLocaleErrors();
            e e2 = new e();
            try {
                configUpdatable = e2.a(string);
            }
            catch (com.contrastsecurity.agent.config.c.c c2) {
                PreConfigUtil.err("Couldn't initialize Contrast. Invalid configuration: " + c2.getMessage());
                c2.printStackTrace(System.err);
                ContrastAgent.logStartingWithoutContrast();
                scopeProvider.leaveScope();
                return;
            }
            com.contrastsecurity.agent.config.f.a(configUpdatable);
            g2.b();
            startupTiming.configLoadTimeNs(g2.e());
            boolean bl2 = configUpdatable.getBoolean(ConfigProperty.SUPPRESS_STDOUT);
            if (bl2) {
                PreConfigUtil.quiet();
            }
            if (ContrastAgent.isAgentStartupDisabled(configUpdatable)) {
                scopeProvider.leaveScope();
                return;
            }
            int n2 = ContrastAgent.getStartupDelay(configUpdatable);
            if (n2 > 0) {
                ContrastAgent.delayedStartup(instrumentation, configUpdatable, file, n2, startupTiming);
            } else {
                ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, configUpdatable, file, startupTiming);
                if (contrastEngine != null) {
                    contrastEngine.activatePlugins();
                }
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @p
    static boolean isAgentStartupDisabled(com.contrastsecurity.agent.config.e e2) {
        if (!e2.getBoolean(ConfigProperty.ENABLED)) {
            return true;
        }
        try {
            a a2 = ContrastAgent.probabilisticStartupCheck(e2);
            return a2 != null && !a2.a();
        }
        catch (FatalStartupException fatalStartupException) {
            return true;
        }
    }

    private static a probabilisticStartupCheck(com.contrastsecurity.agent.config.e e2) throws FatalStartupException {
        int n2;
        try {
            n2 = e2.getInt(ConfigProperty.PROBABILISTIC_STARTUP);
        }
        catch (com.contrastsecurity.agent.config.c.c c2) {
            ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with non-numeric value");
            throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
        }
        if (n2 != -1) {
            try {
                return new a(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with an invalid value: " + n2);
                throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
            }
        }
        return null;
    }

    private static void logProbabilisticStartupConfigError(String string) {
        PreConfigUtil.err(string);
        PreConfigUtil.err("Please specify a number between 1 and 99 (percentage)");
        ContrastAgent.logStartingWithoutContrast();
    }

    private static void logStartingWithoutContrast() {
        PreConfigUtil.err("Continuing without Contrast...");
    }

    private static void delayedStartup(Instrumentation instrumentation, ConfigUpdatable configUpdatable, File file, int n2, StartupTiming startupTiming) {
        String string = configUpdatable.getOrNull(ConfigProperty.DELAYED_STARTUP_STRATEGY);
        if (string == null || DELAYED_ACTIVATION_STRATEGY.equalsIgnoreCase(string)) {
            ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, configUpdatable, file, startupTiming);
            f f2 = new f(contrastEngine, n2, contrastEngine.getErrorEmitter());
            f2.setDaemon(true);
            f2.start();
        } else if (ContrastAgent.isDelayedBoot(string)) {
            g g2 = new g(n2, instrumentation, configUpdatable, file, startupTiming);
            g2.setDaemon(true);
            g2.start();
        } else {
            PreConfigUtil.err("Invalid delayed startup strategy (" + string + ")");
        }
    }

    static int getStartupDelay(com.contrastsecurity.agent.config.e e2) {
        int n2 = 0;
        try {
            n2 = e2.getInt(ConfigProperty.DELAYED_STARTUP);
        }
        catch (com.contrastsecurity.agent.config.c.c c2) {
            // empty catch block
        }
        return Math.max(n2, 0);
    }

    public static ContrastEngine startup(Instrumentation instrumentation, ConfigUpdatable configUpdatable, File file, StartupTiming startupTiming) {
        G g2 = H.b();
        PreConfigUtil.out("Starting Contrast (build " + ContrastVersion.VERSION + ") Pat. 8,458,789 B2");
        com.contrastsecurity.agent.services.b b2 = new com.contrastsecurity.agent.services.b();
        com.contrastsecurity.agent.h.b b3 = com.contrastsecurity.agent.h.b.a((com.contrastsecurity.agent.config.e)configUpdatable, file);
        com.contrastsecurity.agent.logging.c c2 = com.contrastsecurity.agent.logging.log4j2.f.a(configUpdatable, b3, b2);
        Logger logger = LoggerFactory.getLogger(ContrastAgent.class);
        try {
            k k2 = new k();
            ObjectShare.initGson(configUpdatable, k2);
            SystemClock systemClock = new SystemClock();
            Memoizer<List<com.contrastsecurity.agent.a.a>> memoizer = Suppliers.memoize(() -> com.contrastsecurity.agent.a.a.a(VMArguments.getVMArguments()));
            i i2 = i.a((com.contrastsecurity.agent.config.e)configUpdatable, b3, (Clock)systemClock, memoizer);
            TelemetryMetrics telemetryMetrics = i2.a();
            c2.a(b2, telemetryMetrics);
            com.contrastsecurity.agent.telemetry.c c3 = new com.contrastsecurity.agent.telemetry.c(telemetryMetrics.isEnabled());
            com.contrastsecurity.agent.p.b b4 = com.contrastsecurity.agent.p.b.a();
            ContrastEngine contrastEngine = ContrastAgent.createContrastEngine(instrumentation, configUpdatable, new com.contrastsecurity.agent.plugins.apps.f(), c2, startupTiming, b3, b2, systemClock, i2, c3, b4, k2, memoizer);
            g2.b();
            String string = "JVM uptime time before agent: " + startupTiming.getJvmUptimeAtPremainMs() + "ms";
            PerfUtil.printStartupTimingMessage(string);
            long l2 = TimeUnit.NANOSECONDS.toMillis(startupTiming.getTimeForJarTmpInjectionNs());
            PerfUtil.printStartupTimingMessage(PerfUtil.a.a, "jar-injection", l2);
            c3.a(PerfUtil.a.a, "load-config", startupTiming.configLoadMs());
            c3.a(PerfUtil.a.a, "primordial", g2);
            contrastEngine.start(startupTiming);
            PreConfigUtil.out("Contrast engine started.");
            logger.info("Contrast engine started.");
            return contrastEngine;
        }
        catch (FatalStartupException fatalStartupException) {
            PreConfigUtil.err("Couldn't initialize Contrast. See log for details.");
            logger.error("Unexpected error starting up. Continuing without Contrast", fatalStartupException);
            return null;
        }
    }

    @p
    static void patchLiferayLocaleErrors() {
        String string = m.b("java.locale.providers");
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = string.toUpperCase(Locale.ROOT);
        if (!string2.contains("COMPAT")) {
            return;
        }
        String[] stringArray = string2.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (string3.trim().equals("COMPAT")) {
                stringBuilder.append("JRE");
                continue;
            }
            stringBuilder.append(string3.trim());
        }
        m.a("java.locale.providers", stringBuilder.toString());
    }

    @p
    static ContrastEngine createContrastEngine(Instrumentation instrumentation, ConfigUpdatable configUpdatable, com.contrastsecurity.agent.plugins.apps.f f2, com.contrastsecurity.agent.logging.c c2, StartupTiming startupTiming, com.contrastsecurity.agent.h.b b2, com.contrastsecurity.agent.services.b b3, Clock clock, i i2, com.contrastsecurity.agent.telemetry.c c3, com.contrastsecurity.agent.p.b b4, k k2, Supplier<List<com.contrastsecurity.agent.a.a>> supplier) throws FatalStartupException {
        WorkingDirectories workingDirectories;
        try {
            workingDirectories = WorkingDirectories.fromConfig(configUpdatable);
        }
        catch (IOException iOException) {
            throw new c("Unable to create references to working directories", iOException);
        }
        b b5 = new b(f2, b4, clock, configUpdatable, b3, instrumentation, c2, k2, b2, startupTiming, c3, i2, workingDirectories, supplier);
        com.contrastsecurity.agent.m.a a2 = b5.j();
        PluginManager pluginManager = b5.e();
        o o2 = i2.d();
        f2.addListener(configUpdatable);
        List<com.contrastsecurity.agent.services.a> list = b5.m();
        com.contrastsecurity.agent.services.ngreporting.f f3 = b5.l();
        List<x> list2 = b5.n();
        return new ContrastEngine(instrumentation, b2, configUpdatable, list2, clock, list, pluginManager, f3, workingDirectories, i2.a(), o2, a2.a(), c2, b3, c3, b5.k(), b5.o());
    }

    public static boolean isDelayedBoot(com.contrastsecurity.agent.config.e e2) {
        return ContrastAgent.getStartupDelay(e2) > 0 && ContrastAgent.isDelayedBoot(e2.getOrNull(ConfigProperty.DELAYED_STARTUP_STRATEGY));
    }

    private static boolean isDelayedBoot(String string) {
        return DELAYED_BOOT_STRATEGY.equalsIgnoreCase(string);
    }
}

