/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpRequestFactory;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MemoryBuffer;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.a;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.http.g;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.i;
import com.contrastsecurity.agent.http.j;
import com.contrastsecurity.agent.http.l;
import com.contrastsecurity.agent.http.m;
import com.contrastsecurity.agent.http.o;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.o.c;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.plugins.protect.rules.f.d;
import com.contrastsecurity.agent.pool.PurgeableObjectPool;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.DistributionSummary;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@DontObfuscate
@n
public class HttpManager
implements a {
    private final PluginManager pluginManager;
    private final AtomicBoolean isFirstRequest;
    private final f firstRequestEndListener;
    private final c eventBus;
    private final PurgeableObjectPool<MemoryBuffer> memoryBufferPool;
    private final DistributionSummary contentLengthDistributionSummary;
    private final DistributionSummary memoryBufferDistributionSummary;
    private final Counter multipartContentTypeCounter;
    private final DistributionSummary multipartContentLengthDistributionSummary;
    private final boolean featureSamplingEnabled;
    private final int featureSamplingFrequency;
    private static final String[] ALLOWED_CONTENT_TYPES = new String[]{"text/html", "text/plain", "application/xhtml", "application/xml"};
    private static final Logger logger = LoggerFactory.getLogger(HttpManager.class);

    public HttpManager(e e2, PluginManager pluginManager, f f2, c c2, Clock clock, TelemetryMetrics telemetryMetrics) {
        this.pluginManager = pluginManager;
        this.firstRequestEndListener = f2;
        this.isFirstRequest = new AtomicBoolean(true);
        this.eventBus = c2;
        this.featureSamplingEnabled = e2.getBoolean(ConfigProperty.FEATURE_REQUEST_SAMPLING_ENABLED);
        this.featureSamplingFrequency = e2.getInt(ConfigProperty.FEATURE_REQUEST_SAMPLING_FREQUENCY);
        this.memoryBufferPool = new MemoryBuffer.MemoryBufferPool(clock, e2);
        this.contentLengthDistributionSummary = telemetryMetrics.newDistributionSummary("requestContentLengthExpanded", TelemetryMetrics.TelemetryCategory.MEMORY_BUFFER).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The Content-Length of requests as defined by the content-length header").withBucketBoundaries(d.j).withBaseUnit("bytes").register();
        this.memoryBufferDistributionSummary = telemetryMetrics.newDistributionSummary("memoryBufferTotalCountExpanded", TelemetryMetrics.TelemetryCategory.MEMORY_BUFFER).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("Number of Objects Currently Being Managed by MemoryBufferPool").withBucketBoundaries(d.j).withBaseUnit("count").register();
        this.multipartContentTypeCounter = telemetryMetrics.newCounter("multipartContentTypeCount", TelemetryMetrics.TelemetryCategory.GENERAL).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The number of requests seen with a Multipart Content-Type").register();
        this.multipartContentLengthDistributionSummary = telemetryMetrics.newDistributionSummary("multipartContentLengths", TelemetryMetrics.TelemetryCategory.GENERAL).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The Content-Length of Multipart requests as defined by the content-length header").withBucketBoundaries(d.j).withBaseUnit("bytes").register();
    }

    public PurgeableObjectPool<MemoryBuffer> getMemoryBufferPool() {
        return this.memoryBufferPool;
    }

    public HttpRequest onRequestStart(ContrastContext contrastContext, HttpRequestFactory httpRequestFactory) {
        if (contrastContext == null) {
            logger.debug("ContrastContext was null, cannot continue");
            return null;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Application is null, cannot continue");
            return null;
        }
        if (httpRequestFactory == null) {
            logger.debug("HttpRequestFactory is null, cannot continue");
            return null;
        }
        HttpRequest httpRequest = httpRequestFactory.create();
        if (httpRequest == null) {
            logger.debug("HttpRequest was null, cannot continue");
            return null;
        }
        httpRequestFactory.postcreateProcessing(contrastContext);
        contrastContext.http().setRequest(httpRequest);
        this.preCalculateUrlExclusions(application, httpRequest);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            List<m> list = contrastPlugin.getRequestLifecycleListeners();
            for (m m2 : list) {
                m2.a(contrastContext);
            }
            if (!contrastPlugin.requiresHttpRequestBodyBuffering(contrastContext)) {
                return;
            }
            httpRequest.enableCapturing();
            atomicInteger.set(Math.max(atomicInteger.get(), contrastPlugin.limitRequestBodySizeCapturing()));
            contrastContext.http().addRequestBodyListeners(contrastPlugin.getRequestBodyListeners());
        });
        if (atomicInteger.get() > 0) {
            httpRequest.maxBufferSize(Math.min(atomicInteger.get(), httpRequest.getContentLength()));
        }
        this.pluginManager.forEachDisabled(contrastContext, contrastPlugin -> {
            List<m> list = contrastPlugin.getRequestLifecycleListeners();
            for (m m2 : list) {
                m2.b(contrastContext);
            }
        });
        return httpRequest;
    }

    @ScopedSensor
    public void onByteRead(ContrastContext contrastContext, int n2) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpRequest httpRequest = contrastContext.http().getRequest();
            if (httpRequest != null && n2 > -1 && httpRequest.writeToBuffer(this.memoryBufferPool, n2)) {
                HttpManager.notifyListenersOnRequestBodyRead(contrastContext);
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesRead(ContrastContext contrastContext, byte[] byArray, int n2) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.onBytesRead(contrastContext, n2, byArray, 0, n2);
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesRead(ContrastContext contrastContext, int n2, byte[] byArray, int n3, int n4) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpRequest httpRequest = contrastContext.http().getRequest();
            if (httpRequest != null && httpRequest.writeToBuffer(this.memoryBufferPool, byArray, n3, n4, n2)) {
                HttpManager.notifyListenersOnRequestBodyRead(contrastContext);
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    public void onResponseStart(ContrastContext contrastContext, HttpResponse httpResponse) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current HTTPRequest was null");
            return;
        }
        if (httpResponse == null) {
            logger.debug("HttpResponse was null");
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application was null");
            return;
        }
        contrastContext.http().setResponse(httpResponse);
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            if (contrastPlugin.requiresHttpResponseBuffering(contrastContext)) {
                httpResponse.enableCapturing();
                logger.debug("Capturing response to memory");
            }
        });
    }

    public void onResponseHeaderSet(ContrastContext contrastContext, String string, String string2) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            logger.debug("Header name or value was blank, header: {}, headerVal: {}", (Object)string, (Object)string2);
            return;
        }
        HttpContext httpContext = contrastContext.http();
        HttpResponse httpResponse = httpContext.getResponse();
        if (httpContext.getRequest() == null) {
            logger.debug("Request was null");
            return;
        }
        if (httpResponse == null) {
            logger.debug("Response was null");
            return;
        }
        boolean bl2 = false;
        g g2 = g.a(string);
        if (g2 == o.k && string2.contains("attachment")) {
            bl2 = true;
        } else if (g2 == o.t && !StringUtils.startsWithAny(string2.toLowerCase(), ALLOWED_CONTENT_TYPES)) {
            bl2 = true;
        }
        Map<String, List<String>> map = httpResponse.getHeaders();
        List list = map.getOrDefault(g2.headerName(), new ArrayList());
        list.add(string2);
        map.put(g2.headerName(), list);
        if (bl2) {
            httpResponse.disableCapturing();
            logger.debug("Disabling saving response to memory:{}: {}, {}", string, string2, contrastContext.http().getRequest().getUri());
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            List<m> list = contrastPlugin.getRequestLifecycleListeners();
            for (m m2 : list) {
                m2.a(contrastContext, string, string2);
            }
        });
    }

    public void onRequestEnd(ContrastContext contrastContext) {
        HttpContext httpContext = contrastContext.http();
        HttpRequest httpRequest = httpContext.getRequest();
        if (httpRequest == null || !httpRequest.endRequest()) {
            return;
        }
        HttpResponse httpResponse = httpContext.getResponse();
        if (httpResponse != null) {
            this.eventBus.a(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled()) {
            Object object = httpResponse != null ? httpResponse.getOutputMechanism() : null;
            logger.debug("Request ending for {} - response is {} and output mechanism is {}", httpRequest.getUri(), JVMUtils.getSafeToString(httpResponse, true), httpResponse != null ? JVMUtils.getSafeToString(object, true) : "response-null");
            if (httpResponse != null && httpResponse.getOutputMechanism() != null) {
                Object object2 = httpResponse.getOutputMechanism();
                logger.debug("De-assigning output mechanism {}", (Object)JVMUtils.getSafeToString(object2, true));
            }
        }
        this.analyzeResponseContents(contrastContext);
        if (logger.isDebugEnabled() && httpResponse == null) {
            this.logCrumbData(httpRequest);
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            List<m> list = contrastPlugin.getRequestLifecycleListeners();
            for (m m2 : list) {
                try {
                    m2.onRequestEnd(contrastContext);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)m2, (Object)throwable2);
                }
            }
        });
        this.pluginManager.forEachDisabled(contrastContext, contrastPlugin -> {
            List<m> list = contrastPlugin.getRequestLifecycleListeners();
            for (m m2 : list) {
                try {
                    m2.c(contrastContext);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)m2, (Object)throwable2);
                }
            }
        });
        this.contentLengthDistributionSummary.record(httpRequest.getContentLength());
        this.memoryBufferDistributionSummary.record(this.getMemoryBufferPool().totalCount());
        if (httpRequest.getContentType().isMultipart()) {
            this.multipartContentTypeCounter.increment();
            this.multipartContentLengthDistributionSummary.record(httpRequest.getContentLength());
        }
        httpRequest.closeBuffer();
        if (httpResponse != null) {
            httpResponse.closeBuffer();
        }
        httpContext.setRequest(null);
        httpContext.setResponse(null);
        contrastContext.application().current(null);
        long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - httpRequest.startTimeNs());
        httpRequest.getJfrEvent().a(httpRequest, httpResponse);
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|RequestEnded|uri={}&elapsed={}", "!LM!", "RequestTime", httpRequest.getNormalizedUri(), l2);
        }
        if (this.isFirstRequest.get() && this.isFirstRequest.getAndSet(false)) {
            this.firstRequestEndListener.onFirstRequestEnd(l2);
        }
    }

    public void onMultipartHeaderRead(ContrastContext contrastContext, MultipartItem multipartItem) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            i i2 = contrastPlugin.getMultipartListener();
            i2.onHeaderRead(contrastContext, multipartItem);
        });
    }

    public void onParametersResolved(ContrastContext contrastContext) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            j j2 = contrastPlugin.getParameterListener();
            j2.a(contrastContext);
        });
    }

    public void onMoreParametersResolved(ContrastContext contrastContext, Map<String, String[]> map) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            j j2 = contrastPlugin.getParameterListener();
            j2.a(contrastContext, map);
        });
    }

    @Override
    public void onBodyInputReceived(ContrastContext contrastContext, com.contrastsecurity.agent.plugins.protect.d.h h2, String string, String string2) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            a a2 = contrastPlugin.getBodyInputListener();
            a2.onBodyInputReceived(contrastContext, h2, string, string2);
        });
    }

    public boolean isSamplingCurrentRequest(ContrastContext contrastContext, h h2) {
        if (!this.featureSamplingEnabled) {
            return false;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        return httpRequest != null && httpRequest.isSampling(h2, this::initialIsSamplingValue);
    }

    private void analyzeResponseContents(ContrastContext contrastContext) {
        HttpResponse httpResponse = contrastContext.http().getResponse();
        if (httpResponse == null || !contrastContext.http().getResponse().isCapturingEnabled()) {
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        String string = httpRequest.getUri();
        if (httpResponse.isBufferEmpty()) {
            logger.debug("Response was empty for URI {}", (Object)string);
            return;
        }
        String string2 = httpResponse.getBufferAsString();
        logger.debug("Scanning {} response text with length {}/charset {}", string, string2.length(), httpResponse.getCharset());
        Application application = contrastContext.application().current();
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            List<m> list = contrastPlugin.getRequestLifecycleListeners();
            for (m m2 : list) {
                try {
                    m2.a(contrastContext, string2);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)m2, (Object)throwable2);
                }
            }
        });
    }

    private void logCrumbData(HttpRequest httpRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\t\t").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")\n");
        }
        logger.debug("Unexpected null response for request=[{}], CRUMB:\n{}", (Object)httpRequest, (Object)stringBuilder);
    }

    private boolean initialIsSamplingValue(h h2) {
        return ThreadLocalRandom.current().nextInt(1, this.featureSamplingFrequency + 1) == 1;
    }

    private void preCalculateUrlExclusions(Application application, HttpRequest httpRequest) {
        com.contrastsecurity.agent.apps.exclusions.d.a(application, httpRequest);
    }

    private static void notifyListenersOnRequestBodyRead(ContrastContext contrastContext) {
        HttpContext httpContext = contrastContext.http();
        for (l l2 : httpContext.getRequestBodyListeners()) {
            l2.onBodyChunkRead(contrastContext);
        }
    }
}

