/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.logging.log4j2;

import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Pair;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.logging.LoggingConstants;
import com.contrastsecurity.agent.logging.log4j2.plugins.AsyncAppenderThreadFilter;
import com.contrastsecurity.agent.logging.log4j2.plugins.OtelAppender;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.util.I;
import com.contrastsecurity.agent.util.NumberUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.LoggerType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.AbstractConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Node;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Reconfigurable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Clock;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.ClockFactory;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

public final class c
extends AbstractConfiguration
implements com.contrastsecurity.agent.logging.b,
Reconfigurable {
    public static final String a = ".sync";
    private static final Level c = Objects.requireNonNull(Level.toLevel(LoggingConstants.DEFAULT_LOGGER_LEVEL.toString(), null));
    private static final long d = 3600000L;
    private static final long e = 86400000L;
    static final d b = new d();
    private final ConfigUpdatable f;
    private final com.contrastsecurity.agent.h.b g;
    private final boolean h;
    private final boolean i;
    private final boolean j;
    private final String k;
    private final ScheduledExecutorService l;
    private volatile ScheduledFuture<?> m;

    c(LoggerContext loggerContext, ConfigUpdatable configUpdatable, com.contrastsecurity.agent.h.b b2, boolean bl2, String string, ScheduledExecutorService scheduledExecutorService) {
        super(Objects.requireNonNull(loggerContext), ConfigurationSource.NULL_SOURCE);
        this.f = Objects.requireNonNull(configUpdatable);
        this.g = Objects.requireNonNull(b2);
        this.j = bl2;
        this.k = Preconditions.checkNotEmpty(string);
        this.l = scheduledExecutorService;
        this.setName(c.class.getSimpleName());
        this.pluginPackages.add("com.contrastsecurity.agent.logging.log4j2.plugins");
        this.h = configUpdatable.getBoolean(ConfigProperty.LOGGER_STDOUT);
        this.i = configUpdatable.getBoolean(ConfigProperty.LOGGER_STDERR);
    }

    @Override
    public ConfigUpdatable a() {
        return this.f;
    }

    @Override
    public com.contrastsecurity.agent.h.b b() {
        return this.g;
    }

    private String a(ConfigProperty configProperty, long l2, boolean bl2) {
        long l3;
        long l4 = l3 = bl2 ? (long)this.f.getInt(configProperty) : this.f.getLong(configProperty);
        if (l3 > 0L) {
            return Long.toString(l3);
        }
        if (l3 == -1L) {
            return Long.toString(l2);
        }
        com.contrastsecurity.agent.logging.log4j2.c.b.a(configProperty.canonicalName() + " was a negative value. Defaulting to " + l2);
        return Long.toString(l2);
    }

    @Override
    public void setup() {
        int n2;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        String string;
        Level level;
        Object object4;
        Level level2;
        Object object5;
        a a2 = new a(this.rootNode, this.pluginManager);
        a a3 = a2.a("Appenders");
        a a4 = a2.a("Loggers");
        LoggerContext loggerContext = this.getLoggerContext();
        e e2 = com.contrastsecurity.agent.logging.log4j2.c$e.b(this.f, this.j, this.l);
        Level level3 = com.contrastsecurity.agent.logging.log4j2.c$b.a.a(this);
        if (e2.b) {
            object5 = com.contrastsecurity.agent.logging.log4j2.c$b.a(this.f, ConfigProperty.DIAGNOSTICS_LOGGER_LEVEL, Level.DEBUG);
            if (level3 == object5) {
                level2 = level3;
                object4 = null;
                level = null;
            } else {
                level2 = level3.isLessSpecificThan((Level)object5) ? level3 : object5;
                object4 = object5;
                level = level3;
            }
        } else {
            level2 = level3;
            object4 = null;
            level = null;
        }
        object5 = com.contrastsecurity.agent.logging.log4j2.c$b.a.a(a4, a3, level2, level, this);
        if (e2.b) {
            long l2 = OtelAppender.newIndex();
            string = OtelAppender.asyncName(l2);
            String string2 = OtelAppender.syncName(l2);
            object3 = StringUtils.trimToNull(this.f.getOrNull(ConfigProperty.DIAGNOSTICS_LOGGER_UUID));
            if (object3 == null) {
                com.contrastsecurity.agent.logging.log4j2.c.b.a(ConfigProperty.DIAGNOSTICS_LOGGER_UUID.canonicalName() + " was unset. Defaulting to: " + this.k);
                object3 = this.k;
            } else if (!I.b.matcher((CharSequence)object3).matches()) {
                com.contrastsecurity.agent.logging.log4j2.c.b.a(ConfigProperty.DIAGNOSTICS_LOGGER_UUID.canonicalName() + " set to invalid value \"" + (String)object3 + "\". Defaulting to: " + this.k);
                object3 = this.k;
            }
            a3.a("OtelAppender").a("parentAppenderName", string).a("name", string2).a("teamserverUrl", e2.d).a("uuid", (String)object3).a("timeoutMs", this.a(ConfigProperty.TIMEOUT_MS, 10000L, true)).a("backoffFactorMs", this.a(ConfigProperty.DIAGNOSTICS_LOGGER_BACKOFF_FACTOR_MS, 1000L, false)).a("maxTotalBackoffMs", this.a(ConfigProperty.DIAGNOSTICS_LOGGER_MAX_TOTAL_BACKOFF_MS, 60000L, false)).a("maxBatchSize", this.a(ConfigProperty.DIAGNOSTICS_LOGGER_MAX_BATCH_SIZE, 32L, true)).a("batchTimeoutMs", this.a(ConfigProperty.DIAGNOSTICS_LOGGER_BATCHING_TIMEOUT_MS, 5000L, false));
            a a5 = com.contrastsecurity.agent.logging.log4j2.c.b(a3, string, string2, com.contrastsecurity.agent.logging.log4j2.c.a(ConfigProperty.DIAGNOSTICS_LOGGER_BUFFER_SIZE, this.f, (Level)(object4 != null ? object4 : level2))).right();
            a5.a(AsyncAppenderThreadFilter.class.getSimpleName()).a("previousAsyncAppenderName", OtelAppender.asyncName(l2 - 1L)).a("newAsyncAppenderName", string);
            object2 = ((a)object5).a("AppenderRef").a("ref", string);
            if (object4 != null) {
                ((a)object2).a("level", ((Level)object4).toString());
            }
            if (this.l == null) {
                throw new IllegalStateException("commonExecutor was null when diagnostics logger was enabled.");
            }
            object = this.f;
            this.m = this.l.schedule(() -> c.a((com.contrastsecurity.agent.config.e)object, loggerContext), e2.c, TimeUnit.MILLISECONDS);
        }
        com.contrastsecurity.agent.logging.log4j2.c$b.b.a(a4, a3, com.contrastsecurity.agent.logging.log4j2.c$b.b.a(this), null, this);
        boolean bl3 = this.f.getBoolean(ConfigProperty.CEF_SYSLOGGER_ENABLE);
        if (!bl3) {
            bl2 = true;
            n2 = -1;
            string = "";
        } else {
            n2 = this.f.getInt(ConfigProperty.CEF_SYSLOGGER_PORT);
            string = this.f.get(ConfigProperty.CEF_SYSLOGGER_HOST);
            if (string.isEmpty()) {
                string = "localhost";
            }
            try {
                object3 = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                string = "";
            }
            bl2 = n2 > 0 && !string.isEmpty();
        }
        object3 = a4.a("Logger").a("name", LoggerType.CONTRAST_SECURITY_SYSLOGGER.toString()).a("additivity", "false").a("includeLocation", "false");
        if (bl3 && bl2) {
            int n3 = this.f.getInt(ConfigProperty.CEF_SYSLOGGER_FACILITY);
            if (n3 < 0 || 11 < n3 && n3 < 16 || 23 < n3) {
                com.contrastsecurity.agent.logging.log4j2.c.b.a(n3 + " is an unknown syslog facility. Defaulting to USER facility of: " + 1);
                n3 = 1;
            }
            object2 = (Object)((Object)LoggerType.CONTRAST_SECURITY_SYSLOGGER) + a;
            a3.a("Socket").a("name", (String)object2).a("host", string).a("port", Integer.toString(n2)).a("protocol", "UDP").a("PatternLayout").a("pattern", "<%priority{" + n3 * 8 + "}>" + com.contrastsecurity.agent.logging.log4j2.c$b.b.j);
            object = Level.ALL;
            ((a)object3).a("level", ((Level)object).toString()).a("AppenderRef").a("ref", com.contrastsecurity.agent.logging.log4j2.c.b(a3, LoggerType.CONTRAST_SECURITY_SYSLOGGER.toString(), (String)object2, com.contrastsecurity.agent.logging.log4j2.c.a(ConfigProperty.CEF_SYSLOGGER_BUFFER_SIZE, this.f, (Level)object)).left());
        } else {
            if (!bl2) {
                if (n2 < 1) {
                    com.contrastsecurity.agent.logging.log4j2.c.b.a("Failed to configure syslog: invalid port of " + n2 + " provided. Port must be a positive integer.");
                }
                if (string.isEmpty()) {
                    com.contrastsecurity.agent.logging.log4j2.c.b.a("Failed to configure syslog: provided host name was invalid/unknown.");
                }
            }
            ((a)object3).a("level", Level.OFF.toString());
        }
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        if (this.m != null && !this.m.isDone()) {
            this.m.cancel(false);
        }
        return super.stop(l2, timeUnit);
    }

    private static Pair<String, a> b(a a2, String string, String string2, int n2) {
        return com.contrastsecurity.agent.logging.log4j2.c.b(a2, string, Lists.of(Preconditions.checkNotEmpty(string2)), n2);
    }

    private static Pair<String, a> b(a a2, String string, List<String> list, int n2) {
        Objects.requireNonNull(a2);
        Preconditions.checkNotEmpty(string);
        Preconditions.checkNotEmpty(list);
        a a3 = a2.a("Async").a("name", string).a("includeLocation", "false").a("blocking", "false").a("bufferSize", Integer.toString(n2));
        for (String string2 : list) {
            a3.a("AppenderRef").a("ref", string2);
            a3.a("ContrastJCToolsBlockingQueue");
        }
        return Pair.of(string, a3);
    }

    @p
    static int a(ConfigProperty configProperty, com.contrastsecurity.agent.config.e e2, Level level) {
        int n2;
        Objects.requireNonNull(configProperty);
        Objects.requireNonNull(e2);
        Objects.requireNonNull(level);
        switch (configProperty) {
            case LOGGER_BUFFER_SIZE: 
            case DIAGNOSTICS_LOGGER_BUFFER_SIZE: {
                n2 = 16384;
                break;
            }
            case SECURITY_LOGGER_BUFFER_SIZE: 
            case CEF_SYSLOGGER_BUFFER_SIZE: {
                n2 = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)configProperty) + " is not a valid buffer size property.");
            }
        }
        int n3 = e2.getInt(configProperty);
        if (NumberUtil.isPowerOf2(n3)) {
            return n3;
        }
        int n4 = n2 > 0 && level.isLessSpecificThan(Level.DEBUG) ? n2 : 128;
        if (n3 != -1) {
            if (n3 < 1) {
                com.contrastsecurity.agent.logging.log4j2.c.b.a(configProperty.canonicalName() + " was not a positive integer. Buffer size must be a positive integer. Ignoring configured buffer size of " + n3 + ". Defaulting to " + n4);
            } else {
                com.contrastsecurity.agent.logging.log4j2.c.b.a(configProperty.canonicalName() + " was not a power of 2. Buffer size must be a power of 2. Ignoring configured buffer size of " + n3 + ". Defaulting to " + n4);
            }
        }
        return n4;
    }

    @Override
    public Configuration reconfigure() {
        return new c(this.getLoggerContext(), this.f, this.g, this.j, this.k, this.l);
    }

    private static /* synthetic */ void a(com.contrastsecurity.agent.config.e e2, LoggerContext loggerContext) {
        if (e2 instanceof com.contrastsecurity.agent.features.e) {
            ((com.contrastsecurity.agent.features.e)((Object)e2)).updateServerSettings(OtelAppender::disableDiagnosticsLogger);
        }
        loggerContext.reconfigure();
    }

    private static final class a {
        private final Node a;
        private final PluginManager b;

        private a(Node node, PluginManager pluginManager) {
            this.a = Objects.requireNonNull(node);
            this.b = Objects.requireNonNull(pluginManager);
        }

        private a(a a2, String string, PluginManager pluginManager) {
            this.b = Objects.requireNonNull(pluginManager);
            this.a = new Node(a2.a, string, pluginManager.getPluginType(string));
            a2.a.getChildren().add(this.a);
        }

        private a a(String string, String string2) {
            this.a.getAttributes().put(string, string2);
            return this;
        }

        private a a(String string) {
            return new a(this, string, this.b);
        }
    }

    private static enum c {
        a,
        b;


        private static List<c> b(c c2) {
            if (c2.h && c2.i) {
                return Lists.of(a, b);
            }
            if (c2.h) {
                return Lists.of(a);
            }
            return Lists.of(b);
        }
    }

    static final class d {
        private Logger a;
        private boolean b;

        d() {
        }

        void a(Logger logger) {
            if (this.a != null) {
                throw new IllegalStateException("Attempted to initialize " + d.class.getName() + " twice.");
            }
            this.a = Objects.requireNonNull(logger);
        }

        void a(boolean bl2) {
            this.b = bl2;
        }

        private void a(String string) {
            if (this.a == null) {
                PreConfigUtil.warn(this.b ? System.out : System.err, string);
            } else {
                this.a.warn(string);
            }
        }
    }

    @p
    public static enum b {
        a(LoggerType.CONTRAST_LOGGER, ConfigProperty.LOGGER_LOCATION, ConfigProperty.LOGGER_LEVEL, ConfigProperty.LOGGER_BACKUPS, ConfigProperty.LOGGER_SIZE, ConfigProperty.LOGGER_DAILY, ConfigProperty.LOGGER_BUFFER_SIZE, "%d [%t %c{1}] %p - %m%n", true),
        b(LoggerType.CONTRAST_SECURITY_LOGGER, ConfigProperty.SECURITY_LOGGER_FILE, ConfigProperty.SECURITY_LOGGER_LEVEL, ConfigProperty.SECURITY_LOGGER_BACKUPS, ConfigProperty.SECURITY_LOGGER_SIZE, ConfigProperty.SECURITY_LOGGER_DAILY, ConfigProperty.SECURITY_LOGGER_BUFFER_SIZE, "%m%n", false);

        private final LoggerType c;
        private final ConfigProperty d;
        private final ConfigProperty e;
        private final ConfigProperty f;
        private final ConfigProperty g;
        private final ConfigProperty h;
        private final ConfigProperty i;
        private final String j;
        private final boolean k;
        private static final int l = 100;

        private b(LoggerType loggerType, ConfigProperty configProperty, ConfigProperty configProperty2, ConfigProperty configProperty3, ConfigProperty configProperty4, ConfigProperty configProperty5, ConfigProperty configProperty6, String string2, boolean bl2) {
            this.c = Objects.requireNonNull(loggerType);
            this.d = Objects.requireNonNull(configProperty);
            this.e = Objects.requireNonNull(configProperty2);
            this.f = Objects.requireNonNull(configProperty3);
            this.g = Objects.requireNonNull(configProperty4);
            this.h = Objects.requireNonNull(configProperty5);
            this.i = Objects.requireNonNull(configProperty6);
            this.j = Preconditions.checkNotEmpty(string2);
            this.k = bl2;
        }

        private Level a(c c2) {
            return com.contrastsecurity.agent.logging.log4j2.c$b.a(c2.f, this.e, c);
        }

        static Level a(com.contrastsecurity.agent.config.e e2, ConfigProperty configProperty, Level level) {
            Objects.requireNonNull(e2);
            Objects.requireNonNull(configProperty);
            Objects.requireNonNull(level);
            String string = e2.get(configProperty).toUpperCase(Locale.ENGLISH);
            Level level2 = Level.toLevel(string, level);
            if (level2 == level && !level2.name().equals(string)) {
                b.a("Invalid log level of \"" + string + "\" provided for " + configProperty.canonicalName() + ". Defaulting to " + level);
            }
            return level2;
        }

        private a a(a a2, a a3, Level level, Level level2, c c2) {
            a a4 = a2.a(this.k ? "Root" : "Logger").a("level", level.toString()).a("additivity", "false").a("includeLocation", "false");
            if (!this.k) {
                a4.a("name", this.c.toString());
            }
            int n2 = com.contrastsecurity.agent.logging.log4j2.c.a(this.i, c2.f, level2 != null ? level2 : level);
            String string = c2.h || c2.i || this.a(c2.f) ? this.a(a3, com.contrastsecurity.agent.logging.log4j2.c$c.b(c2), n2) : this.a(c2.f, a3, n2);
            a a5 = a4.a("AppenderRef").a("ref", string);
            if (level2 != null) {
                a5.a("level", level2.toString());
            }
            return a4;
        }

        private boolean a(com.contrastsecurity.agent.config.e e2) {
            Path path;
            Path path2;
            String string = e2.get(this.d);
            if (string.isEmpty()) {
                b.a(this.d.canonicalName() + " was empty. No log will be saved, defaulting logging to STDERR.");
                return true;
            }
            File file = new File(string);
            File file2 = file.getParentFile();
            Path path3 = path2 = file2 == null ? new File(".").getAbsoluteFile().toPath() : file2.toPath();
            if (!Files.exists(path2, new LinkOption[0])) {
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                    b.a("Log file " + string + " path does not exist and could not be created. Check that the directory permissions for the file path are correct. Defaulting logging to STDERR.");
                    return true;
                }
            }
            if (!Files.isReadable(path2) || !Files.isWritable(path2)) {
                b.a("Log file " + string + " path is not readable or writeable. Check that the directory permissions for the file path  are correct. Defaulting logging to STDERR.");
                return true;
            }
            if (!(!file.exists() || Files.isReadable(path = file.toPath()) && Files.isWritable(path))) {
                b.a("Log file " + string + " is not readable or writeable. Check that the directory permissions for the file path  are correct. Defaulting logging to STDERR.");
                return true;
            }
            return false;
        }

        private String a(com.contrastsecurity.agent.config.e e2, a a3, int n2) {
            String string = e2.get(this.d);
            if (string.isEmpty()) {
                throw new IllegalStateException("agent.logger.path was empty and our preceding check failed somehow");
            }
            boolean bl2 = e2.getBoolean(this.h);
            String string2 = (Object)((Object)this.c) + ".file";
            BiFunction<a, String, a> biFunction = (a2, string3) -> {
                a a3 = ((a)a2).a("RollingRandomAccessFile").a("name", string2).a("fileName", string).a("filePattern", string + string3);
                a3.a("PatternLayout").a("pattern", this.j);
                return a3;
            };
            if (bl2) {
                biFunction.apply(a3, ".%d{yyyy-MM-dd}").a("Policies").a("TimeBasedTriggeringPolicy");
            } else {
                boolean bl3;
                a a4 = biFunction.apply(a3, ".%i");
                int n3 = com.contrastsecurity.agent.logging.log4j2.c$b.a(e2, this.f);
                boolean bl4 = bl3 = n3 > 0;
                if (bl3) {
                    a4.a("DefaultRolloverStrategy").a("max", Integer.toString(n3));
                } else {
                    a4.a("TruncatingRolloverStrategy");
                }
                int n4 = e2.getInt(this.g);
                if (n4 < 1) {
                    b.a(this.g.canonicalName() + " must be greater than 0. Defaulting to " + this.g.defaultValue());
                    n4 = (Integer)this.g.defaultValue();
                }
                a4.a("Policies").a("SizeBasedTriggeringPolicy").a("size", n4 + " MB");
            }
            return (String)com.contrastsecurity.agent.logging.log4j2.c.b(a3, this.c.toString(), string2, n2).left();
        }

        @p
        static int a(com.contrastsecurity.agent.config.e e2, ConfigProperty configProperty) {
            int n2 = e2.getInt(configProperty);
            if (n2 > 100) {
                b.a(configProperty.canonicalName() + " must not be greater than 100. Defaulting to 100.");
                return 100;
            }
            if (n2 < 0) {
                b.a(configProperty.canonicalName() + " must not be negative. Defaulting to 0.");
                return 0;
            }
            return n2;
        }

        private String a(a a2, List<c> list, int n2) {
            Lists.Builder<String> builder = Lists.builder();
            for (c c2 : list) {
                String string = (Object)((Object)this.c) + ".console." + c2.name();
                a2.a("Console").a("name", string).a("target", "SYSTEM_" + c2.name()).a("PatternLayout").a("pattern", this.j);
                builder.add(string);
            }
            return (String)com.contrastsecurity.agent.logging.log4j2.c.b(a2, this.c.toString(), builder.build(), n2).left();
        }
    }

    private static final class e {
        private static final Clock a = ClockFactory.getClock();
        private final boolean b;
        private final long c;
        private final String d;

        private static long a(com.contrastsecurity.agent.config.e e2) {
            long l2 = Objects.requireNonNull(e2).getLong(ConfigProperty.DIAGNOSTICS_LOGGER_EXPIRATION_TIME_MS);
            if (l2 < 1L) {
                return 3600000L;
            }
            if ((l2 -= a.currentTimeMillis()) > 86400000L) {
                b.a(ConfigProperty.DIAGNOSTICS_LOGGER_EXPIRATION_TIME_MS.canonicalName() + " was longer than 24 hours, setting expiration to 24 hours from now.");
                return 86400000L;
            }
            return l2;
        }

        private static e b(com.contrastsecurity.agent.config.e e2, boolean bl2, ScheduledExecutorService scheduledExecutorService) {
            Objects.requireNonNull(e2);
            if (scheduledExecutorService == null) {
                if (com.contrastsecurity.agent.logging.b.a(e2)) {
                    b.a("Disabling diagnostics logger because required dependencies were not provided. Ignoring diagnostics logger configuration.");
                }
                return new e();
            }
            if (bl2 && OtelAppender.shutdownDueToErrors()) {
                return new e();
            }
            if (!com.contrastsecurity.agent.logging.b.a(e2)) {
                return new e();
            }
            long l2 = com.contrastsecurity.agent.logging.log4j2.c$e.a(e2);
            if (l2 < 1L) {
                return new e();
            }
            String string = e2.getOrNull(ConfigProperty.TEAMSERVER_URL);
            if (StringUtils.isBlank(string)) {
                b.a(ConfigProperty.TEAMSERVER_URL.canonicalName() + " was not set, disabling diagnostics logger.");
                return new e();
            }
            return new e(true, l2, string.replaceFirst("/Contrast/?$", "/"));
        }

        private e() {
            this(false, -1L, null);
        }

        private e(boolean bl2, long l2, String string) {
            this.b = bl2;
            this.c = l2;
            this.d = string;
        }
    }
}

