/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.activity.protect;

import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.messages.TimestampDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.AttackResult;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.thirdparty.com.google.gson.JsonElement;
import com.contrastsecurity.thirdparty.com.google.gson.JsonObject;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializationContext;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class ProtectRuleSampleDTM<T> {
    private HttpRequestDTM request;
    private T details;
    protected List<StackTraceElement> stack;
    private boolean blocked;
    private UserInputDTM input;
    private TimestampDTM timestamp;
    private transient AttackResult result;

    public static <T> ProtectRuleSampleDTM<T> createBlockedAtPerimeter(HttpRequestDTM httpRequestDTM, T t2, List<StackTraceElement> list, UserInputDTM userInputDTM, TimestampDTM timestampDTM) {
        return ProtectRuleSampleDTM.create(httpRequestDTM, t2, list, userInputDTM, timestampDTM, AttackResult.BLOCKED_AT_PERIMETER);
    }

    public static <T> ProtectRuleSampleDTM<T> create(HttpRequestDTM httpRequestDTM, T t2, List<StackTraceElement> list, UserInputDTM userInputDTM, TimestampDTM timestampDTM, AttackResult attackResult) {
        return new ProtectRuleSampleDTM<T>(httpRequestDTM, t2, list, userInputDTM, timestampDTM, attackResult);
    }

    private ProtectRuleSampleDTM(HttpRequestDTM httpRequestDTM, T t2, List<StackTraceElement> list, UserInputDTM userInputDTM, TimestampDTM timestampDTM, AttackResult attackResult) {
        this.request = httpRequestDTM;
        this.details = t2;
        this.stack = list != null ? Lists.copy(list) : Collections.emptyList();
        this.input = userInputDTM;
        this.timestamp = timestampDTM;
        this.result = attackResult;
        this.blocked = attackResult == AttackResult.BLOCKED || attackResult == AttackResult.BLOCKED_AT_PERIMETER;
    }

    private ProtectRuleSampleDTM() {
    }

    public AttackResult getResult() {
        return this.result;
    }

    public TimestampDTM getTimestamp() {
        return this.timestamp;
    }

    public HttpRequestDTM getRequest() {
        return this.request;
    }

    public T getDetails() {
        return this.details;
    }

    public List<StackTraceElement> getStack() {
        return this.stack;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public UserInputDTM getInput() {
        return this.input;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProtectRuleSampleDTM protectRuleSampleDTM = (ProtectRuleSampleDTM)object;
        return this.blocked == protectRuleSampleDTM.blocked && Objects.equals(this.request, protectRuleSampleDTM.request) && Objects.equals(this.details, protectRuleSampleDTM.details) && Objects.equals(this.stack, protectRuleSampleDTM.stack) && Objects.equals(this.input, protectRuleSampleDTM.input) && Objects.equals(this.timestamp, protectRuleSampleDTM.timestamp) && this.result == protectRuleSampleDTM.result;
    }

    public int hashCode() {
        int n2 = this.request != null ? this.request.hashCode() : 0;
        n2 = 31 * n2 + (this.details != null ? this.details.hashCode() : 0);
        n2 = 31 * n2 + this.stack.hashCode();
        n2 = 31 * n2 + (this.blocked ? 1 : 0);
        n2 = 31 * n2 + (this.input != null ? this.input.hashCode() : 0);
        n2 = 31 * n2 + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        n2 = 31 * n2 + (this.result != null ? this.result.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "ProtectRuleSampleDTM{request=" + this.request + ", details=" + this.details + ", stack=" + this.stack + ", blocked=" + this.blocked + ", input=" + this.input + ", timestamp=" + this.timestamp + ", result=" + (Object)((Object)this.result) + '}';
    }

    public static class ProtectRuleSampleDTMSerializer
    implements JsonSerializer<ProtectRuleSampleDTM<?>> {
        private final Function<HttpRequestDTM, HttpRequestDTM> dataMasker;

        public ProtectRuleSampleDTMSerializer(Function<HttpRequestDTM, HttpRequestDTM> function) {
            this.dataMasker = Objects.requireNonNull(function);
        }

        @Override
        public JsonElement serialize(ProtectRuleSampleDTM<?> protectRuleSampleDTM, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            HttpRequestDTM httpRequestDTM = this.dataMasker.apply(protectRuleSampleDTM.getRequest());
            jsonObject.add("request", jsonSerializationContext.serialize(httpRequestDTM));
            jsonObject.add("details", jsonSerializationContext.serialize(protectRuleSampleDTM.getDetails()));
            jsonObject.add("stack", jsonSerializationContext.serialize(protectRuleSampleDTM.getStack()));
            jsonObject.addProperty("blocked", protectRuleSampleDTM.isBlocked());
            jsonObject.add("input", jsonSerializationContext.serialize(protectRuleSampleDTM.getInput()));
            jsonObject.add("timestamp", jsonSerializationContext.serialize(protectRuleSampleDTM.getTimestamp()));
            return jsonObject;
        }
    }
}

