/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.finding;

import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.messages.Maskable;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.thirdparty.com.google.gson.JsonArray;
import com.contrastsecurity.thirdparty.com.google.gson.JsonDeserializationContext;
import com.contrastsecurity.thirdparty.com.google.gson.JsonDeserializer;
import com.contrastsecurity.thirdparty.com.google.gson.JsonElement;
import com.contrastsecurity.thirdparty.com.google.gson.JsonObject;
import com.contrastsecurity.thirdparty.com.google.gson.JsonParseException;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializationContext;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializer;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class FindingDTM {
    private final long hash;
    private final int version;
    @SerializedName(value="session_id")
    private final String sessionId;
    private final String ruleId;
    private final String evidence;
    private final transient HttpRequestDTM request;
    private final Map<PropertyKey, String> properties;
    private final List<EventDTM> events;
    private final transient ObservedRoute observedRoute;
    private final String tags;
    private static final long serialVersionUID = 1L;

    protected FindingDTM(Builder builder) {
        this.hash = builder.hash;
        this.version = builder.version;
        this.sessionId = builder.sessionId;
        this.ruleId = builder.ruleId;
        this.evidence = builder.evidence;
        this.request = builder.request;
        this.properties = Maps.copy(builder.properties);
        this.events = Lists.copy(builder.events);
        this.observedRoute = builder.observedRoute;
        this.tags = builder.tags;
    }

    public long getHash() {
        return this.hash;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public HttpRequestDTM getRequest() {
        return this.request;
    }

    public String getTags() {
        return this.tags;
    }

    public Map<PropertyKey, String> getProperties() {
        return this.properties;
    }

    public List<EventDTM> getEvents() {
        return this.events;
    }

    public ObservedRoute getObservedRoute() {
        return this.observedRoute;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return FindingDTM.builder().setRuleId(this.ruleId).setEvents(this.events).setHash(this.hash).setEvidence(this.evidence).setObservedRoute(this.observedRoute).setProperties(this.properties).setRequest(this.request).setTags(this.tags).setSessionId(this.sessionId).setVersion(this.version);
    }

    public String toString() {
        return "FindingDTM{hash=" + this.hash + ", version=" + this.version + ", sessionId='" + this.sessionId + '\'' + ", ruleId='" + this.ruleId + '\'' + ", evidence='" + this.evidence + '\'' + ", request=" + this.request + ", properties=" + this.properties + ", events=" + this.events + ", observedRoute=" + this.observedRoute + ", tags='" + this.tags + '\'' + '}';
    }

    private static class FindingDTMJson
    extends FindingDTM {
        private FindingDTMJson(Builder builder) {
            super(builder);
        }
    }

    public static final class FindingDTMJsonSerializerDeserializer
    implements JsonDeserializer<FindingDTM>,
    JsonSerializer<FindingDTM> {
        final Supplier<Boolean> isProductionSupplier;
        final Function<HttpRequestDTM, HttpRequestDTM> dataMaskerFunction;

        public FindingDTMJsonSerializerDeserializer(Supplier<Boolean> supplier, Function<HttpRequestDTM, HttpRequestDTM> function) {
            this.isProductionSupplier = supplier;
            this.dataMaskerFunction = function;
        }

        @Override
        public JsonElement serialize(FindingDTM findingDTM, Type type, JsonSerializationContext jsonSerializationContext) {
            Maskable<ObservedRoute> maskable;
            JsonObject jsonObject = jsonSerializationContext.serialize(findingDTM, (Type)((Object)FindingDTMJson.class)).getAsJsonObject();
            boolean bl2 = this.isProductionSupplier.get();
            if (!ObservedRoute.isValid(findingDTM.getObservedRoute())) {
                jsonObject.add("routes", new JsonArray());
            } else {
                maskable = bl2 ? findingDTM.getObservedRoute().mask() : findingDTM.getObservedRoute();
                jsonObject.add("routes", maskable.toRouteCoverageJson());
            }
            if (findingDTM.getRequest() != null) {
                maskable = bl2 ? findingDTM.getRequest().mask() : this.dataMaskerFunction.apply(findingDTM.getRequest());
                jsonObject.add("request", jsonSerializationContext.serialize(maskable));
            }
            return jsonObject;
        }

        @Override
        public FindingDTM deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            Object object;
            FindingDTM findingDTM = (FindingDTM)jsonDeserializationContext.deserialize(jsonElement, (Type)((Object)FindingDTMJson.class));
            if (jsonElement.getAsJsonObject().get("request") != null) {
                object = (HttpRequestDTM)jsonDeserializationContext.deserialize(jsonElement.getAsJsonObject().get("request").getAsJsonObject(), (Type)((Object)HttpRequestDTM.class));
                findingDTM = findingDTM.toBuilder().setRequest((HttpRequestDTM)object).build();
            }
            if (jsonElement.getAsJsonObject().get("routes") != null) {
                object = findingDTM;
                Optional<FindingDTM> optional = ObservedRoute.fromRouteCoverageJson(jsonElement.getAsJsonObject().get("routes").getAsJsonArray(), findingDTM.getSessionId()).map(arg_0 -> FindingDTMJsonSerializerDeserializer.lambda$deserialize$0((FindingDTM)object, arg_0));
                if (optional.isPresent()) {
                    return optional.get();
                }
            }
            return findingDTM;
        }

        private static /* synthetic */ FindingDTM lambda$deserialize$0(FindingDTM findingDTM, ObservedRoute observedRoute) {
            return findingDTM.toBuilder().setObservedRoute(observedRoute).build();
        }
    }

    public static final class Builder {
        private String tags;
        private long hash;
        private int version;
        private String sessionId;
        private String ruleId;
        private String evidence;
        private HttpRequestDTM request;
        private Map<PropertyKey, String> properties = Collections.emptyMap();
        private List<EventDTM> events = Collections.emptyList();
        private ObservedRoute observedRoute;

        private Builder() {
        }

        public Builder setTags(String string) {
            this.tags = string;
            return this;
        }

        public Builder setHash(long l2) {
            this.hash = l2;
            return this;
        }

        public Builder setVersion(int n2) {
            this.version = n2;
            return this;
        }

        public Builder setSessionId(String string) {
            this.sessionId = string;
            return this;
        }

        public Builder setRuleId(String string) {
            this.ruleId = string;
            return this;
        }

        public Builder setEvidence(String string) {
            this.evidence = string;
            return this;
        }

        public Builder setRequest(HttpRequestDTM httpRequestDTM) {
            this.request = httpRequestDTM;
            return this;
        }

        public Builder setProperties(Map<PropertyKey, String> map) {
            this.properties = Objects.requireNonNull(map);
            return this;
        }

        public Builder setEvents(List<EventDTM> list) {
            this.events = Objects.requireNonNull(list);
            return this;
        }

        public Builder setObservedRoute(ObservedRoute observedRoute) {
            this.observedRoute = observedRoute;
            return this;
        }

        public FindingDTM build() {
            return new FindingDTM(this);
        }
    }
}

