/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.opentelemetry;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.opentelemetry.ContrastHttpSenderProvider;
import com.contrastsecurity.agent.opentelemetry.FakeMetricReader;
import com.contrastsecurity.agent.opentelemetry.FakeSpanProcessor;
import com.contrastsecurity.agent.opentelemetry.b;
import com.contrastsecurity.agent.opentelemetry.e;
import com.contrastsecurity.agent.opentelemetry.i;
import com.contrastsecurity.agent.test.integration.IntegrationTestServices;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.MetricReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

@DontObfuscate
public class OtelGlobalConfig {
    private final boolean otelEnabled;
    private final boolean tracingEnabled;
    private final Sampler sampler;
    private final SpanProcessor spanProcessor;
    private final boolean metricsEnabled;
    private final MetricReader metricReader;
    private final ExemplarFilter exemplarFilter;
    public static final OtelGlobalConfig NO_OP = new OtelGlobalConfig(false, false, null, null, false, null, null);

    private OtelGlobalConfig(boolean bl2, boolean bl3, SpanProcessor spanProcessor, Sampler sampler, boolean bl4, MetricReader metricReader, ExemplarFilter exemplarFilter) {
        this.sampler = sampler;
        this.tracingEnabled = bl3;
        this.spanProcessor = spanProcessor;
        this.metricReader = metricReader;
        this.metricsEnabled = bl4;
        this.otelEnabled = bl2;
        this.exemplarFilter = exemplarFilter;
    }

    static OtelGlobalConfig createFakeConfig(e e2, ScheduledExecutorService scheduledExecutorService) {
        if (!e2.getBoolean(ConfigProperty.ENABLE_INTEGRATION_TEST_SERVICES)) {
            throw new UnsupportedOperationException("OtelGlobalConfig.createFakeConfig must be used in conjunction with " + IntegrationTestServices.class.getSimpleName() + ", which is not available in production.");
        }
        Sampler sampler = Sampler.parentBasedBuilder(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, e2, i.b.a)).setRemoteParentSampled(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, e2, i.b.a)).build();
        FakeSpanProcessor fakeSpanProcessor = new FakeSpanProcessor();
        FakeMetricReader fakeMetricReader = new FakeMetricReader(scheduledExecutorService);
        return new OtelGlobalConfig(true, true, fakeSpanProcessor, sampler, true, fakeMetricReader, ExemplarFilter.alwaysOn());
    }

    static OtelGlobalConfig from(e e2, com.contrastsecurity.agent.h.b b2, ScheduledExecutorService scheduledExecutorService, String string, String string2) {
        Objects.requireNonNull(e2);
        Objects.requireNonNull(b2);
        Objects.requireNonNull(scheduledExecutorService);
        boolean bl2 = string2 != null;
        boolean bl3 = string != null;
        Preconditions.check(bl2 || bl3, "Both tracing and metrics endpoints cannot be null");
        ContrastHttpSenderProvider.initialize(e2, b2);
        b b3 = null;
        Sampler sampler = null;
        if (bl3) {
            b3 = new b(OtlpHttpSpanExporter.builder().setEndpoint(string).build());
            sampler = Sampler.parentBasedBuilder(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, e2, i.b.b)).setRemoteParentSampled(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, e2, i.b.a)).build();
        }
        e.c c2 = null;
        ExemplarFilter exemplarFilter = null;
        if (bl2) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor(com.contrastsecurity.agent.scope.b.a("Contrast OTel Metrics Reporting"));
            long l2 = e2.getLong(ConfigProperty.OBSERVE_METRICS_EXPORT_INTERVAL);
            Preconditions.check(l2 > 0L, "Metrics export interval must be greater than 0");
            c2 = new e.c(PeriodicMetricReader.builder(OtlpHttpMetricExporter.builder().setAggregationTemporalitySelector(AggregationTemporalitySelector.deltaPreferred()).setEndpoint(string2).build()).setInterval(Duration.ofMillis(l2)).setExecutor(scheduledExecutorService2).build());
            exemplarFilter = ExemplarFilter.alwaysOn();
        }
        return new OtelGlobalConfig(true, bl3, b3, sampler, bl2, c2, exemplarFilter);
    }

    private static Sampler createRouteSampler(ScheduledExecutorService scheduledExecutorService, e e2, i.b b2) {
        return new i(scheduledExecutorService, e2.getLong(ConfigProperty.OBSERVE_TRACING_SAMPLING_INTERVAL), b2);
    }

    static String telemetryEndpointOrOverride(e e2, ConfigProperty configProperty) {
        String string;
        String string2 = e2.getOrNull(configProperty);
        if (string2 != null) {
            return string2;
        }
        if (configProperty == ConfigProperty.OBSERVE_METRICS_ENDPOINT) {
            string = "metrics";
        } else if (configProperty == ConfigProperty.OBSERVE_TRACING_ENDPOINT) {
            string = "traces";
        } else {
            throw new IllegalArgumentException("Signal must be metrics or traces");
        }
        String string3 = e2.getOrNull(ConfigProperty.TEAMSERVER_URL);
        if (string3 != null) {
            string3 = (string3 = string3.replaceFirst("/Contrast/?$", "/")).endsWith("/") ? string3 : string3 + "/";
            string3 = string3 + "agents/v2.0/observability/" + string;
        }
        return string3;
    }

    public boolean isOtelEnabled() {
        return this.otelEnabled;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public Sampler sampler() {
        return this.sampler;
    }

    public SpanProcessor spanProcessor() {
        return this.spanProcessor;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public MetricReader metricReader() {
        return this.metricReader;
    }

    public ExemplarFilter exemplarFilter() {
        return this.exemplarFilter;
    }
}

