/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.xenon;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MemoryBuffer;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.messages.mq.HttpResponseDTM;
import com.contrastsecurity.agent.pool.ObjectPool;
import com.contrastsecurity.agent.reflection.ReflectionUtil;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@DontObfuscate
final class XenonResponse
extends HttpResponse {
    private final WeakReference<Object> wrappedOperation;
    private static final String PROBLEM_REFLECTING_STATUS_CODE = "xenonProbRefStatusCode";
    private static final String PROBLEM_REFLECTING_CONTENT_TYPE = "xenonProbRefContentType";
    private static final Logger logger = LoggerFactory.getLogger(XenonResponse.class);

    XenonResponse(Object object, ObjectPool<MemoryBuffer> objectPool) {
        super(objectPool);
        this.wrappedOperation = new WeakReference<Object>(object);
    }

    @Override
    public int getStatus() {
        int n2 = 0;
        Object t2 = this.wrappedOperation.get();
        if (t2 != null) {
            n2 = XenonResponse.reflectStatusCode(t2);
        }
        return n2;
    }

    @Override
    public String frameworkContentType() {
        String string = null;
        Object t2 = this.wrappedOperation.get();
        if (t2 != null) {
            string = XenonResponse.reflectContentType(t2);
        }
        return string;
    }

    @Override
    public String frameworkCharacterEncoding() {
        return null;
    }

    @Override
    public HttpResponseDTM toHttpResponseDTM() {
        return null;
    }

    private static String reflectContentType(Object object) {
        String string = null;
        try {
            Class<?> clazz = object.getClass();
            Method method = ReflectionUtil.getMethod(clazz, "getContentType");
            string = (String)method.invoke(object, Empty.OBJ_ARRAY);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            a.a(PROBLEM_REFLECTING_CONTENT_TYPE, logger, "Problem reflecting content type", throwable2);
        }
        return string;
    }

    private static int reflectStatusCode(Object object) {
        int n2 = 0;
        try {
            Field field = ReflectionUtil.getDeclaredField(object, "statusCode");
            n2 = (Integer)field.get(object);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            a.a(PROBLEM_REFLECTING_STATUS_CODE, logger, "Problem reflecting status", throwable2);
        }
        return n2;
    }
}

