/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.opentelemetry.g;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.deadzone.e;
import com.contrastsecurity.agent.services.Purgeable;

@n
@DontObfuscate
public class ObserveRootSpanManager
implements Purgeable {
    private final Clock clock;
    private final com.contrastsecurity.agent.config.e config;
    private final e deadzoneManager;
    private static final long OBSERVE_CONTEXT_TTL_MS = 15000L;

    public ObserveRootSpanManager(Clock clock, com.contrastsecurity.agent.config.e e2, e e3) {
        this.clock = clock;
        this.config = e2;
        this.deadzoneManager = e3;
    }

    public RootSpan createNewRootSpan(ContrastContext contrastContext) {
        Application application = contrastContext.application().current();
        if (application == null) {
            return null;
        }
        g g2 = application.otel();
        return contrastContext.observe(new RootSpan(g2.b(), this.clock, contrastContext.http().getRequest(), this.config, this.deadzoneManager, g2.a()));
    }

    @Override
    public void purgeStale(ContrastContext contrastContext) {
        if (this.isStale(contrastContext.observe())) {
            contrastContext.observe(null);
        }
    }

    @Override
    public int purgeableCount(ContrastContext contrastContext) {
        return this.isStale(contrastContext.observe()) ? 1 : 0;
    }

    private boolean isStale(RootSpan rootSpan) {
        return rootSpan != null && this.clock.now() - rootSpan.getStartTimeMs() > 15000L;
    }
}

