/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.serverside;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.d;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.semconv.SemanticAttributes;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;

@DontObfuscate
@n
public final class ServerSideRequestDispatcherImpl
implements ContrastObserveServerSideRequestDispatcher {
    private final e config;
    private static final Set<String> EXCLUDED_PROTOCOLS = Sets.of("file", "jar", "jrt", "war", "ear");
    private static final String SINK_TYPE = "outbound-service-call";

    ServerSideRequestDispatcherImpl(e e2) {
        this.config = e2;
    }

    public Object onTraceStart(Object object, String string, Object object2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        if (!(object2 instanceof URLConnection)) {
            return null;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Application application = contrastContext.application().current();
        if (application == null) {
            return null;
        }
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null) {
            return null;
        }
        URL uRL = ((URLConnection)object2).getURL();
        String string2 = uRL.getHost();
        int n2 = uRL.getPort();
        String string3 = uRL.getProtocol();
        if (string3 != null && EXCLUDED_PROTOCOLS.contains(string3.toLowerCase())) {
            return null;
        }
        Span span = rootSpan.startChildSpan(contrastContext, SINK_TYPE, string);
        if (span == null || string2 == null) {
            return span;
        }
        span.setAttribute(SemanticAttributes.SERVER_ADDRESS, string2);
        if (n2 >= 0) {
            span.setAttribute(SemanticAttributes.SERVER_PORT, n2);
        }
        return span;
    }

    public void onActionEnd(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        d.a(this.config, object2, contrastContext.observe(), contrastContext.application().current(), SINK_TYPE);
    }
}

