/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.e;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.i;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.G;
import com.contrastsecurity.agent.plugins.protect.M;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectInputScanner;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.c;
import com.contrastsecurity.agent.plugins.protect.e;
import com.contrastsecurity.agent.plugins.protect.g.b;
import com.contrastsecurity.agent.plugins.protect.k.d;
import com.contrastsecurity.agent.plugins.protect.q;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.plugins.protect.u;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.function.Supplier;

@n
@DontObfuscate
final class MultipartScanner
extends ProtectInputScanner
implements i {
    private static final Logger logger = LoggerFactory.getLogger(MultipartScanner.class);

    MultipartScanner(b b2, com.contrastsecurity.agent.config.e e2, ProtectManager protectManager, ProtectInputScanner.a a2, c c2, e e3) {
        super(b2, e2, protectManager, a2, c2, e3);
    }

    @Override
    public void onHeaderRead(ContrastContext contrastContext, MultipartItem multipartItem) {
        ProtectContext protectContext = contrastContext.protect();
        if (protectContext.isAllowlisted()) {
            return;
        }
        try {
            this._onMultipartHeaderRead(contrastContext, multipartItem);
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Unexpected error processing multipart header", throwable2);
        }
    }

    private void _onMultipartHeaderRead(ContrastContext contrastContext, MultipartItem multipartItem) {
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        String string = httpRequest.getUri();
        Supplier<String> supplier = d.b(multipartItem.getContentType(), UserInputDTM.InputType.MULTIPART_CONTENT_TYPE);
        Supplier<String> supplier2 = d.b(multipartItem.getFileName(), UserInputDTM.InputType.MULTIPART_FILE_NAME);
        Supplier<String> supplier3 = d.b(multipartItem.getFieldName(), UserInputDTM.InputType.MULTIPART_FIELD_NAME);
        Supplier<String> supplier4 = d.b(multipartItem.getValue(), UserInputDTM.InputType.MULTIPART_VALUE);
        com.contrastsecurity.agent.apps.exclusions.c c2 = com.contrastsecurity.agent.apps.exclusions.d.a(application, httpRequest);
        for (p p2 : this.manager.getEnabledRules(contrastContext)) {
            String string2 = p2.getRuleId().id();
            if (c2.a(e.a.b, string2)) {
                logger.trace("Skipping multipart item read event for {} for {} due to exception", (Object)string2, (Object)string);
                continue;
            }
            if (!(p2 instanceof k)) continue;
            k k2 = (k)p2;
            if (k2.appliesToInputType(UserInputDTM.InputType.MULTIPART_CONTENT_TYPE) && !G.a("Content-Type", multipartItem.getContentType())) {
                this.scanMultipartContentType(contrastContext, k2, supplier.get(), supplier3.get());
            }
            if (k2.appliesToInputType(UserInputDTM.InputType.MULTIPART_FILE_NAME)) {
                this.scanMultipartFileName(contrastContext, k2, supplier2.get(), supplier4.get());
            }
            if (!k2.appliesToInputType(UserInputDTM.InputType.MULTIPART_FIELD_NAME)) continue;
            this.scanMultipartName(contrastContext, k2, supplier3.get(), supplier4.get());
        }
    }

    private void scanMultipartContentType(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string == null || string.isEmpty()) {
            logger.trace("Ignoring empty multipart content type");
            return;
        }
        u u2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_CONTENT_TYPE, null, string, k2);
        q q2 = u2.a();
        this.logResult(contrastContext, q2, k2, "Content-Type of Multipart field", string2, string);
        if (q2 == q.a) {
            return;
        }
        M m2 = new M(this.buildMultipartParameterContentType(string2, string).filters(u2.b()).build(), q2 == q.c);
        this.saveInput(contrastContext, k2, m2);
    }

    private void scanMultipartFileName(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string == null || string.isEmpty()) {
            logger.trace("Ignoring empty multipart file name");
            return;
        }
        String string3 = "filename";
        u u2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_FILE_NAME, "filename", string, k2);
        q q2 = u2.a();
        this.logResult(contrastContext, q2, k2, "Multipart name", string, string2);
        if (q2 == q.a) {
            return;
        }
        M m2 = new M(this.buildMultipartParameterName("filename", string).filters(u2.b()).build(), q2 == q.c);
        this.saveInput(contrastContext, k2, m2);
    }

    private void scanMultipartName(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string == null || string.isEmpty()) {
            logger.trace("Ignoring empty multipart name");
            return;
        }
        u u2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_FIELD_NAME, string, string, k2);
        q q2 = u2.a();
        this.logResult(contrastContext, q2, k2, "Multipart field", string, string2);
        if (q2 == q.a) {
            return;
        }
        M m2 = new M(this.buildMultipartParameterFieldName(string, string2).filters(u2.b()).build(), q2 == q.c);
        this.saveInput(contrastContext, k2, m2);
    }

    private void scanMultipartValue(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            logger.trace("Ignoring empty multipart value");
            return;
        }
        u u2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_VALUE, string2, string2, k2);
        q q2 = u2.a();
        this.logResult(contrastContext, q2, k2, "Multipart value", string2, string2);
        if (q2 == q.a) {
            return;
        }
        M m2 = new M(this.buildMultipartParameterValue(string, string2).filters(u2.b()).build(), true);
        this.saveInput(contrastContext, k2, m2);
    }

    private UserInputDTM.Builder buildMultipartParameterContentType(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_CONTENT_TYPE);
    }

    private UserInputDTM.Builder buildMultipartParameterFieldName(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_FIELD_NAME);
    }

    private UserInputDTM.Builder buildMultipartParameterName(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_FILE_NAME);
    }

    private UserInputDTM.Builder buildMultipartParameterValue(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_VALUE);
    }
}

