/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Memoizer;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.k.g;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.protect.D;
import com.contrastsecurity.agent.plugins.protect.M;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

@DontObfuscate
public class ProtectContext
implements com.contrastsecurity.agent.commons.b<ProtectContext> {
    private final com.contrastsecurity.agent.plugins.protect.b.c canonicalizer;
    private final Memoizer<ConcurrentHashMap<String, Object>> map;
    private final Memoizer<ConcurrentHashMap<ProtectRuleId, List<M>>> inputs;
    private final Memoizer<ConcurrentHashMap<String, com.contrastsecurity.agent.plugins.protect.b.b>> canonicalizationResultsMap;
    private final Clock clock;
    private final boolean telemetryEnabled;
    private final d.b<D, i> requestTimeMetrics;
    private final List<AtomicLong> analysisTimers;
    private final com.contrastsecurity.agent.telemetry.metrics.b.b timingAnomalyEventFactory;
    private final Memoizer<Set<ProtectRuleId>> disabledRules;
    private final AtomicBoolean allowlisted;
    private final AtomicBoolean throwExceptionOnParameterAccess;
    private final AtomicBoolean allRulesDisabled;
    private final List<b> autoTimers;
    private static final Logger logger = LoggerFactory.getLogger(ProtectContext.class);
    private static final com.contrastsecurity.agent.plugins.protect.b.c DEFAULT_CANONICALIZER = new com.contrastsecurity.agent.plugins.protect.b.c(TelemetryMetrics.NO_OP, (Clock)new SystemClock());
    @p
    static final b NO_OP_AUTO_TIMER = new b(){

        @Override
        public b a() {
            return this;
        }

        @Override
        public void close() {
        }
    };
    private static final long ONE_MINUTE_IN_NS = TimeUnit.MINUTES.toNanos(1L);

    private static List<b> newAutoTimersListOrNull(boolean bl2) {
        return bl2 ? Arrays.asList(new b[a.d.length]) : null;
    }

    public ProtectContext() {
        this(DEFAULT_CANONICALIZER, new SystemClock(), TelemetryMetrics.NO_OP, ProtectManager.buildRequestTimeMetrics(TelemetryMetrics.NO_OP), com.contrastsecurity.agent.telemetry.metrics.b.b.a);
    }

    public ProtectContext(ProtectContext protectContext) {
        this.canonicalizer = protectContext.canonicalizer;
        this.clock = protectContext.clock;
        this.telemetryEnabled = protectContext.telemetryEnabled;
        this.requestTimeMetrics = protectContext.requestTimeMetrics;
        this.analysisTimers = protectContext.analysisTimers;
        this.timingAnomalyEventFactory = protectContext.timingAnomalyEventFactory;
        this.inputs = protectContext.inputs;
        this.canonicalizationResultsMap = protectContext.canonicalizationResultsMap;
        this.map = protectContext.map;
        this.disabledRules = protectContext.disabledRules;
        this.allowlisted = protectContext.allowlisted;
        this.throwExceptionOnParameterAccess = protectContext.throwExceptionOnParameterAccess;
        this.allRulesDisabled = protectContext.allRulesDisabled;
        this.autoTimers = ProtectContext.newAutoTimersListOrNull(this.telemetryEnabled);
        List<b> list = this.autoTimers;
    }

    public ProtectContext(com.contrastsecurity.agent.plugins.protect.b.c c2, Clock clock, TelemetryMetrics telemetryMetrics, d.b<D, i> b2, com.contrastsecurity.agent.telemetry.metrics.b.b b3) {
        this.canonicalizer = c2;
        this.clock = clock;
        this.requestTimeMetrics = b2;
        this.telemetryEnabled = telemetryMetrics.isEnabled();
        if (this.telemetryEnabled) {
            this.analysisTimers = Arrays.asList(new AtomicLong[a.d.length]);
            for (int i2 = 0; i2 < a.d.length; ++i2) {
                this.analysisTimers.set(i2, new AtomicLong(0L));
            }
        } else {
            this.analysisTimers = null;
        }
        this.autoTimers = ProtectContext.newAutoTimersListOrNull(this.telemetryEnabled);
        this.timingAnomalyEventFactory = b3;
        this.inputs = Suppliers.memoize(ConcurrentHashMap::new);
        this.canonicalizationResultsMap = Suppliers.memoize(ConcurrentHashMap::new);
        this.map = Suppliers.memoize(ConcurrentHashMap::new);
        this.disabledRules = Suppliers.memoize(() -> Collections.newSetFromMap(new ConcurrentHashMap()));
        this.allowlisted = new AtomicBoolean();
        this.throwExceptionOnParameterAccess = new AtomicBoolean();
        this.allRulesDisabled = new AtomicBoolean();
    }

    public b startTiming(a a2) {
        if (!this.telemetryEnabled) {
            return NO_OP_AUTO_TIMER;
        }
        b b2 = this.autoTimers.get(a2.ordinal());
        if (b2 == null) {
            c c2 = new c(this.clock, this.analysisTimers.get(a2.ordinal()));
            b2 = c2;
            this.autoTimers.set(a2.ordinal(), b2);
        }
        return b2.a();
    }

    public void recordRequestTimes(ContrastContext contrastContext) {
        if (!this.telemetryEnabled) {
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        this.requestTimeMetrics.get(D.d).a(this.clock.nanoTime() - httpRequest.startTimeNs(), TimeUnit.NANOSECONDS);
        g g2 = httpRequest.getJfrEvent();
        long l2 = 0L;
        for (int i2 = 0; i2 < a.d.length; ++i2) {
            long l3 = this.analysisTimers.get(i2).getAndSet(0L);
            D d2 = a.d[i2].c;
            g2.a(d2, l2);
            if (l3 < 0L) {
                l2 = -1L;
                continue;
            }
            this.requestTimeMetrics.get(d2).a(l3, TimeUnit.NANOSECONDS);
            if (l2 < 0L) continue;
            l2 += l3;
        }
        if (l2 >= 0L) {
            this.requestTimeMetrics.get(D.c).a(l2, TimeUnit.NANOSECONDS);
            if (l2 > ONE_MINUTE_IN_NS) {
                this.timingAnomalyEventFactory.a(contrastContext).a();
            }
        }
        g2.a(D.c, l2);
    }

    public void markRuleDisabled(ProtectRuleId protectRuleId) {
        this.disabledRules.get().add(protectRuleId);
    }

    public void markAllRulesDisabled() {
        this.allRulesDisabled.getAndSet(true);
    }

    @p
    boolean areAllRulesDisabled() {
        return this.allRulesDisabled.get();
    }

    public boolean isRuleDisabled(ProtectRuleId protectRuleId) {
        return this.allowlisted.get() || this.allRulesDisabled.get() || this.disabledRules != null && this.disabledRules.get().contains((Object)protectRuleId);
    }

    public boolean isRuleEnabled(ProtectRuleId protectRuleId) {
        return !this.isRuleDisabled(protectRuleId);
    }

    public List<M> getInputs(ProtectRuleId protectRuleId) {
        List<M> list = this.inputs.get().get((Object)protectRuleId);
        return list != null ? list : Collections.emptyList();
    }

    public void clear() {
        this.canonicalizationResultsMap.ifPresent(Map::clear);
        this.inputs.ifPresent(Map::clear);
        this.map.ifPresent(Map::clear);
        this.disabledRules.ifPresent(Set::clear);
        this.allowlisted.getAndSet(false);
        this.allRulesDisabled.getAndSet(false);
        this.throwExceptionOnParameterAccess.getAndSet(false);
    }

    public void put(String string, Object object) {
        this.map.get().put(string, object);
    }

    public Object get(String string) {
        return this.map.get().get(string);
    }

    public Object remove(String string) {
        return this.map.get().remove(string);
    }

    public void markAllowlisted() {
        this.allowlisted.getAndSet(true);
    }

    public boolean isAllowlisted() {
        return this.allowlisted.get();
    }

    public M getFirstInput(ProtectRuleId protectRuleId) {
        List<M> list = this.getInputs(protectRuleId);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    public void saveInput(ContrastContext contrastContext, e e2, k k2, M m2) {
        if (logger.isDebugEnabled()) {
            logger.debug("Saving tracked input {} to context {} with input {} for {}", m2.a().getValue(), JVMUtils.getSafeToString(this, true), JVMUtils.getSafeToString(m2.a(), true), k2.getRuleId().id());
        }
        Application application = contrastContext.application().current();
        boolean bl2 = !this.appliesToApplicationCheckEnabled(e2) || k2.appliesToApplication(application);
        m2.a(bl2);
        this.inputs.get().computeIfAbsent(k2.getRuleId(), protectRuleId -> new LinkedList()).add(m2);
    }

    public com.contrastsecurity.agent.plugins.protect.b.b canonicalize(String string) {
        com.contrastsecurity.agent.plugins.protect.b.b b2 = this.canonicalizationResultsMap.get().get(string);
        if (b2 == null) {
            b2 = this.canonicalizer.a(string);
            this.canonicalizationResultsMap.get().put(string, b2);
        }
        return b2;
    }

    @p
    com.contrastsecurity.agent.plugins.protect.b.b getCachedCanonicalizationResults(String string) {
        return this.canonicalizationResultsMap.get().get(string);
    }

    public void throwExceptionOnParameterAccess(boolean bl2) {
        this.throwExceptionOnParameterAccess.getAndSet(bl2);
    }

    boolean shouldThrowExceptionOnParameterAccess() {
        return this.throwExceptionOnParameterAccess.get();
    }

    private boolean appliesToApplicationCheckEnabled(e e2) {
        return e2.getBoolean(ConfigProperty.PROTECT_APPCHECK_ENABLED);
    }

    @Override
    public ProtectContext copy() {
        return new ProtectContext(this);
    }

    @p
    List<b> timers() {
        return this.autoTimers;
    }

    public static enum a {
        a(D.a),
        b(D.b);

        @p
        final D c;
        @p
        static final a[] d;

        private a(D d2) {
            this.c = d2;
        }

        static {
            d = com.contrastsecurity.agent.plugins.protect.ProtectContext$a.values();
        }
    }

    public static final class c
    implements b {
        private final Clock a;
        private final AtomicLong b;
        private long c;
        private static final long d = Long.MAX_VALUE;

        @p
        c(Clock clock, AtomicLong atomicLong) {
            this.a = clock;
            this.b = atomicLong;
            this.b();
        }

        private void b() {
            this.c = Long.MAX_VALUE;
        }

        @Override
        public b a() {
            this.c = this.a.nanoTime();
            return this;
        }

        @Override
        public void close() {
            if (this.c != Long.MAX_VALUE) {
                this.b.addAndGet(this.a.nanoTime() - this.c);
            } else {
                this.b.set(Long.MIN_VALUE);
                Assert.fail("Timer was stopped before start() was called.");
            }
            this.b();
        }
    }

    public static interface b
    extends AutoCloseable {
        public b a();

        @Override
        public void close();
    }
}

