/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.L;
import com.contrastsecurity.agent.plugins.protect.M;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.b.b;
import com.contrastsecurity.agent.plugins.protect.b.c;
import com.contrastsecurity.agent.plugins.protect.b.d;
import com.contrastsecurity.agent.plugins.protect.c;
import com.contrastsecurity.agent.plugins.protect.e;
import com.contrastsecurity.agent.plugins.protect.q;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.plugins.protect.u;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.URLDecoder;
import java.util.Objects;

@DontObfuscate
abstract class ProtectInputScanner {
    private final c analysisCache;
    private final com.contrastsecurity.agent.config.e config;
    private final Counter ignoredInputCounter;
    private final Counter usedAnalysisCacheCounter;
    private final Counter skippedAnalysisCacheCounter;
    private final d.b<c.a, Counter> codecsCounter;
    protected final ProtectManager manager;
    protected final com.contrastsecurity.agent.plugins.protect.g.b logEnhancer;
    protected final e publisher;
    @com.contrastsecurity.agent.p
    static final u IGNORED = new u(q.a);
    @com.contrastsecurity.agent.p
    static final String COUNTER_IGNORED_INPUT = "ignoredInputCount";
    @com.contrastsecurity.agent.p
    static final String COUNTER_ANALYSIS_CACHE_USED = "analysisCacheUsedCount";
    @com.contrastsecurity.agent.p
    static final String COUNTER_ANALYSIS_CACHE_UNUSED = "analysisCacheUnusedCount";
    private static final Logger logger = LoggerFactory.getLogger(ProtectInputScanner.class);

    ProtectInputScanner(com.contrastsecurity.agent.plugins.protect.g.b b2, com.contrastsecurity.agent.config.e e2, ProtectManager protectManager, a a2, c c2, e e3) {
        this.logEnhancer = Objects.requireNonNull(b2);
        this.config = Objects.requireNonNull(e2);
        this.manager = Objects.requireNonNull(protectManager);
        this.analysisCache = Objects.requireNonNull(c2);
        this.publisher = Objects.requireNonNull(e3);
        this.ignoredInputCounter = Objects.requireNonNull(a2).a;
        this.skippedAnalysisCacheCounter = a2.c;
        this.usedAnalysisCacheCounter = a2.b;
        this.codecsCounter = a2.d;
    }

    public u evaluate(ContrastContext contrastContext, UserInputDTM.InputType inputType, String string, String string2, k k2) throws AttackBlockedException {
        return this.evaluate(contrastContext, inputType, string, string2, k2, -1);
    }

    public u evaluate(ContrastContext contrastContext, UserInputDTM.InputType inputType, String string, String string2, k k2, int n2) throws AttackBlockedException {
        u u2;
        com.contrastsecurity.agent.plugins.protect.d d2 = contrastContext.threadLocals().c().a();
        if (string2 == null || string2.length() < k2.c()) {
            u2 = IGNORED;
            this.ignoredInputCounter.increment();
        } else {
            String string3 = k2.getRuleId().id();
            d2.a(string3, inputType, string2, string);
            u2 = this.analysisCache.a(d2);
            if (u2 == null) {
                this.skippedAnalysisCacheCounter.increment();
                b b2 = contrastContext.protect().canonicalize(string2);
                String string4 = b2.c();
                int n3 = n2 != -1 ? n2 : L.a(string2);
                u2 = k2.evaluateInput(contrastContext, inputType, string, string2, string4, n3);
                if (u2 == null) {
                    u2 = IGNORED;
                }
                this.analysisCache.a(d2, u2);
                if (q.a != u2.a()) {
                    for (d d3 : b2.a()) {
                        this.codecsCounter.get(d3.b()).increment();
                    }
                }
            } else {
                this.usedAnalysisCacheCounter.increment();
            }
        }
        if (q.c == u2.a() && this.manager.shouldBlockAtPerimeter(contrastContext, k2, inputType)) {
            this.recordPerimeterBlockSample(contrastContext, k2, inputType, string, string2, u2);
            throw new AttackBlockedException("Attack detected");
        }
        return u2;
    }

    void saveInput(ContrastContext contrastContext, k k2, M m2) {
        Object object;
        Object object2;
        UserInputDTM userInputDTM = m2.a();
        UserInputDTM.InputType inputType = userInputDTM.getType();
        if (inputType == UserInputDTM.InputType.COOKIE_VALUE) {
            object2 = userInputDTM.getValue();
            try {
                object = URLDecoder.decode((String)object2, "UTF-8");
                if (!((String)object2).equals(object)) {
                    m2.a(UserInputDTM.builder(userInputDTM).value((String)object).build());
                }
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
            }
        }
        if (k2.a((HttpRequest)(object2 = contrastContext.http().getRequest()))) {
            object = contrastContext.protect();
            ((ProtectContext)object).saveInput(contrastContext, this.config, k2, m2);
        } else {
            logger.debug("Not saving context input {} for rule {} because of HTTP request type", (Object)m2.a().getType(), (Object)k2.getRuleId().id());
            if (m2.d()) {
                this.publisher.a(contrastContext, k2.getRuleId(), m2.a(), k2.a_());
            }
        }
    }

    protected void logResult(ContrastContext contrastContext, q q2, k k2, String string, String string2, String string3) {
        switch (q2) {
            case a: {
                this.logEnhancer.c(contrastContext, k2.getRuleId(), string, string2, string3);
                break;
            }
            case b: {
                this.logEnhancer.b(contrastContext, k2.getRuleId(), string, string2, string3);
                break;
            }
            case c: {
                this.logEnhancer.a(contrastContext, k2.getRuleId(), string, string2, string3);
                break;
            }
            default: {
                Assert.fail("Unexpected EvaluationResult value encountered: " + (Object)((Object)q2));
                logger.debug("Unexpected EvaluationResult value encountered: {}", (Object)q2);
            }
        }
    }

    private void recordPerimeterBlockSample(ContrastContext contrastContext, p p2, UserInputDTM.InputType inputType, String string, String string2, u u2) {
        this.publisher.a(contrastContext, p2.getRuleId(), UserInputDTM.builder().type(inputType).name(string).value(string2).filters(u2.b()).build());
    }

    public static final class a {
        final Counter a;
        final Counter b;
        final Counter c;
        final d.b<c.a, Counter> d;

        a(TelemetryMetrics telemetryMetrics) {
            this.a = telemetryMetrics.newCounter(ProtectInputScanner.COUNTER_IGNORED_INPUT, TelemetryMetrics.TelemetryCategory.PROTECT).withDescription("The number of times the evaluate() method was called and the EvaluationResult was IGNORED").register();
            this.b = telemetryMetrics.newCounter(ProtectInputScanner.COUNTER_ANALYSIS_CACHE_USED, TelemetryMetrics.TelemetryCategory.PROTECT).withDescription("The number of times the AnalysisCache was used").register();
            this.c = telemetryMetrics.newCounter(ProtectInputScanner.COUNTER_ANALYSIS_CACHE_UNUSED, TelemetryMetrics.TelemetryCategory.PROTECT).withDescription("The number of times the AnalysisCache was empty and was not used").register();
            this.d = telemetryMetrics.newGrouped(telemetryMetrics.newCounter("codecsUsedInWorthWatchingCount", TelemetryMetrics.TelemetryCategory.CANONICALIZER).withDescription("The times each Codec was involved in the decoding of an input that was marked Worth Watching or higher").withExpiration(com.contrastsecurity.agent.telemetry.d.a)).a("codecName").a(c.a.class);
        }
    }
}

