/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.apps.exclusions.e;
import com.contrastsecurity.agent.apps.exclusions.i;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.security.controller.e;
import com.contrastsecurity.agent.plugins.security.controller.trigger.o;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class AssessSourceExclusionHandler
implements o {
    private static final Logger logger = LoggerFactory.getLogger(AssessSourceExclusionHandler.class);

    @Override
    public boolean onTraceTriggered(ContrastContext contrastContext, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, e e2) {
        List<CodeEvent> list = trace.getEvents();
        boolean bl2 = true;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Skipping exclusion processing: app is null");
            return false;
        }
        if (application.getExclusionProcessor() == null) {
            logger.debug("Skipping exclusion processing: exclusion processor is null");
            return false;
        }
        for (int i2 = 0; i2 < list.size() && bl2; ++i2) {
            CodeEvent codeEvent = list.get(i2);
            if (!(codeEvent instanceof SourceEvent)) continue;
            bl2 = !this.isSourceExclusion(trace, rule, (SourceEvent)codeEvent, httpRequest, application);
        }
        return bl2;
    }

    @p
    boolean isSourceExclusion(Trace trace, Rule rule, SourceEvent sourceEvent, HttpRequest httpRequest, Application application) {
        i i2 = application.getExclusionProcessor();
        String string = rule.getId();
        SourceNode sourceNode = sourceEvent.getSource();
        if (!sourceNode.hasSourceTypes()) {
            logger.debug("Skipping exclusion processing: untrusted data source [{}] does not have a processable type", (Object)sourceNode.getId());
            return false;
        }
        if (sourceEvent.getQueue() != null && (sourceNode.isSourceType(u.u) || sourceNode.isSourceType(u.v) || sourceNode.isSourceType(u.w) || sourceNode.isSourceType(u.x))) {
            return i2.isQueueExclusion(e.a.a, string, sourceEvent.getQueue());
        }
        if (httpRequest == null) {
            logger.debug("Skipping exclusion processing: request model is null");
            return false;
        }
        c c2 = d.a(application, httpRequest);
        if (sourceNode.isSourceType(u.g)) {
            String string2 = this.extractInputName(trace, sourceEvent, sourceNode);
            return i2.isInputExclusion(e.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.PARAMETER, string2);
        }
        if (sourceNode.isSourceType(u.d)) {
            String string3 = this.extractInputName(trace, sourceEvent, sourceNode);
            return i2.isInputExclusion(e.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, string3);
        }
        if (sourceNode.isSourceType(u.h)) {
            return c2.a(e.a.a, string, ExceptionInputTypeDTM.QUERYSTRING);
        }
        if (sourceNode.isSourceType(u.c)) {
            String string4 = sourceEvent.getFieldName();
            return i2.isInputExclusion(e.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.COOKIE, string4);
        }
        if (sourceNode.isSourceType(u.a) || sourceNode.isSourceType(u.f)) {
            return c2.a(e.a.a, string, ExceptionInputTypeDTM.BODY);
        }
        if (sourceNode.isSourceType(u.t)) {
            return i2.isInputExclusion(e.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, "authorization");
        }
        return false;
    }

    private String extractInputName(Trace trace, SourceEvent sourceEvent, SourceNode sourceNode) {
        String string = sourceEvent.getFieldName();
        if (string != null) {
            return string;
        }
        if (sourceNode.isSourceType(u.q)) {
            if (sourceEvent.getParameters() != null && sourceEvent.getParameters().length > 0) {
                string = sourceEvent.getParameters()[0].string();
            }
        } else if (sourceNode.isSourceType(u.p)) {
            String string2;
            if (trace == null || trace.getEvents() == null || trace.getEvents().isEmpty()) {
                return null;
            }
            int n2 = trace.getEvents().indexOf(sourceEvent);
            if (n2 >= 0 && trace.getEvents().size() > n2 && (string2 = trace.getEvents().get(n2 + 1).getRet()) != null && !string2.isEmpty()) {
                string = string2;
            }
        }
        return string;
    }
}

