/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.util.JVMUtils;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;

@DontObfuscate
@n
public final class EventHelper {
    private EventHelper() {
    }

    public static int getLength(AssessmentContext assessmentContext, Object object) {
        if (object == null) {
            return 0;
        }
        if (assessmentContext == null || !EventHelper.shouldSaveLength(object)) {
            return EventHelper._getLength(object);
        }
        Integer n2 = assessmentContext.getLength(object);
        if (n2 != null) {
            return n2;
        }
        int n3 = EventHelper._getLength(object);
        assessmentContext.saveLength(object, n3);
        return n3;
    }

    private static boolean shouldSaveLength(Object object) {
        return object instanceof Map || object instanceof Collection || object instanceof Object[];
    }

    private static int _getLength(Object object) {
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length();
        }
        if (object instanceof StringWriter) {
            return ((StringWriter)object).getBuffer().length();
        }
        if (object instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)object).size();
        }
        if (object instanceof Character) {
            return 1;
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).length;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof char[]) {
            return ((char[])object).length;
        }
        if (object instanceof short[]) {
            return ((short[])object).length;
        }
        if (object instanceof int[]) {
            return ((int[])object).length;
        }
        if (object instanceof float[]) {
            return ((float[])object).length;
        }
        if (object instanceof long[]) {
            return ((long[])object).length;
        }
        if (object instanceof double[]) {
            return ((double[])object).length;
        }
        return JVMUtils.getSafeToString(object).length();
    }
}

