/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.track;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.c.a;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.EventHelper;
import com.contrastsecurity.agent.plugins.security.controller.track.a.b;
import com.contrastsecurity.agent.plugins.security.controller.track.c;
import com.contrastsecurity.agent.plugins.security.controller.track.d;
import com.contrastsecurity.agent.plugins.security.controller.track.e;
import com.contrastsecurity.agent.plugins.security.o;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.AdaptiveOptimizationManager;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.scope.ScopeAssess;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.scope.Scoping;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.util.I;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collection;

@DontObfuscate
@n
public final class SourceControllerImpl
implements c {
    private final EventContext eventContext;
    private final com.contrastsecurity.agent.config.e config;
    private final i stackCaptureFactory;
    private final d sourceEventGenerator;
    private final ContrastPolicyManager policyManager;
    private final com.contrastsecurity.agent.trace.a methodDescriptionCache;
    private final Collection<o> traceListeners;
    private final int dynatraceMaxStackSearch;
    private static final com.contrastsecurity.agent.plugins.security.e.a COLLECTOR = new com.contrastsecurity.agent.plugins.security.e.a(false, true);
    private static final Logger logger = LoggerFactory.getLogger(SourceControllerImpl.class);

    public SourceControllerImpl(EventContext eventContext, com.contrastsecurity.agent.config.e e2, i i2, ContrastPolicyManager contrastPolicyManager, com.contrastsecurity.agent.trace.a a2, Collection<o> collection, AdaptiveOptimizationManager adaptiveOptimizationManager, com.contrastsecurity.agent.plugins.security.model.c c2, com.contrastsecurity.agent.trace.d d2, a a3, PluginManager pluginManager) {
        this.eventContext = eventContext;
        this.config = e2;
        this.stackCaptureFactory = i2;
        this.sourceEventGenerator = new e(eventContext, adaptiveOptimizationManager, c2, d2, a3, contrastPolicyManager, pluginManager, collection);
        this.policyManager = contrastPolicyManager;
        this.methodDescriptionCache = a2;
        this.traceListeners = collection;
        this.dynatraceMaxStackSearch = e2.getInt(ConfigProperty.DYNATRACE_MAX_DEPTH);
    }

    @Override
    public void enterSourceScope(ContrastContext contrastContext) {
        Scoping scoping = contrastContext.scope();
        scoping.enterScope(ScopeType.ASSESS_SOURCE);
        if (scoping.inOutermostScope(ScopeType.ASSESS_SOURCE)) {
            contrastContext.threadLocals().a().b().d();
        }
    }

    @Override
    public void enterSourceScopeAndResetSampling(ContrastContext contrastContext) {
        this.enterSourceScope(contrastContext);
        contrastContext.scope().set(ScopeType.ASSESS_SAMPLING, 0);
    }

    @Override
    public void trackObject(ContrastContext contrastContext, String string, String string2, int n2, Object object, Class<?> clazz, Object[] objectArray, Class<?>[] classArray, Object object2, String string3, String string4) {
        Object object3;
        if (!this.sourceCreationAllowed(contrastContext, string3)) {
            return;
        }
        ContrastPolicy contrastPolicy = this.policyManager.currentPolicy();
        if (contrastPolicy == null) {
            logger.debug("Ignoring source event {}: no policy is currently set", (Object)string3);
            return;
        }
        SourceNode sourceNode = contrastPolicy.getSourceById(string3);
        if (sourceNode == null) {
            logger.debug("Ignoring source event {}: no policy found with matching ID.", (Object)string3);
            return;
        }
        if (StringUtils.isEmpty(string4) || "R".equals(string4)) {
            object3 = object2;
        } else if ("O".equals(string4)) {
            object3 = object;
        } else {
            int n3 = I.c(string4, 1);
            object3 = objectArray[n3 - 1];
        }
        if (object3 == null) {
            logger.debug("Ignoring source event {}: target object is null.", (Object)string3);
            return;
        }
        if (objectArray == null || classArray == null) {
            logger.debug("Ignoring source event {}: arguments or argumentTypes is null.", (Object)string3);
            return;
        }
        if (objectArray.length != classArray.length) {
            logger.debug("Ignoring source event {}: arguments and argumentTypes have different lengths.", (Object)string3);
            return;
        }
        if (clazz == null) {
            logger.debug("Ignoring source event {}: Object type is null.", (Object)string3);
            return;
        }
        com.contrastsecurity.agent.plugins.security.controller.a a2 = new com.contrastsecurity.agent.plugins.security.controller.a(sourceNode, MethodDescription.getMethod(this.methodDescriptionCache, clazz.getName(), string, string2, n2), object3, objectArray, classArray);
        a2.a(object, clazz);
        a2.b(object2);
        this.createSource(contrastContext, a2);
    }

    @Override
    public boolean sourceCreationAllowed(ContrastContext contrastContext, String string) {
        if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
            return false;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return false;
        }
        if (!this.eventContext.isEnabled()) {
            logger.debug("Ignoring source event {}: disabled event context", (Object)string);
            return false;
        }
        Scoping scoping = contrastContext.scope();
        if (ScopeAssess.isSourceCreationDisallowed(scoping)) {
            logger.debug("Ignoring source event {}: creation not allowed -- samplingScope(0):{}  masterScope(0):{} sourceScope(1):{}", string, scoping.value(ScopeType.ASSESS_SAMPLING), scoping.value(ScopeType.ASSESS), scoping.value(ScopeType.ASSESS_SOURCE));
            return false;
        }
        if (this.eventContext.getTraceMap(contrastContext.assessment()) == null) {
            logger.debug("Ignoring source event: no trace map available");
            return false;
        }
        return true;
    }

    @Override
    public boolean createSource(ContrastContext contrastContext, com.contrastsecurity.agent.plugins.security.controller.a a2) {
        return this._createSource(contrastContext, a2, false);
    }

    @Override
    public boolean createSyntheticSource(ContrastContext contrastContext, com.contrastsecurity.agent.plugins.security.controller.a a2) {
        return this._createSource(contrastContext, a2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _createSource(ContrastContext contrastContext, com.contrastsecurity.agent.plugins.security.controller.a a2, boolean bl2) {
        Application application = contrastContext.application().current();
        if (application == null || a2 == null || a2.k() == null) {
            return false;
        }
        if (!bl2 && !this.sourceCreationAllowed(contrastContext, a2.b())) {
            return false;
        }
        if (a2.c() != null) {
            for (o object : this.traceListeners) {
                if (object.b(contrastContext, a2)) continue;
                return false;
            }
        }
        Scoping scoping = contrastContext.scope();
        try {
            com.contrastsecurity.agent.scope.a a3;
            block19: {
                a3 = scoping.enterAutoScope(ScopeType.ASSESS);
                try {
                    if (a2.q() != null) break block19;
                    a2.a(this.stackCaptureFactory.a(i.a.a));
                    if (!com.contrastsecurity.agent.plugins.frameworks.g.d.a() || !com.contrastsecurity.agent.plugins.frameworks.g.d.a(a2, this.dynatraceMaxStackSearch)) break block19;
                    logger.debug("Suppressing Dynatrace source event");
                    boolean bl4 = false;
                    if (a3 != null) {
                        a3.close();
                    }
                    return bl4;
                }
                catch (Throwable throwable) {
                    try {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        if (a3 != null) {
                            try {
                                a3.close();
                            }
                            catch (Throwable throwable3) {
                                Throwables.throwIfCritical(throwable3);
                                Throwable throwable4 = throwable3;
                                throwable2.addSuppressed(throwable4);
                            }
                        }
                        throw throwable2;
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        Exception exception2 = exception;
                        logger.error("WARNING: Problem tracking call from {}", (Object)a2.k(), (Object)exception2);
                        boolean bl3 = false;
                        return bl3;
                    }
                }
            }
            this._trackObject(contrastContext, application, a2);
            boolean bl4 = true;
            if (a3 != null) {
                a3.close();
            }
            return bl4;
        }
        finally {
            contrastContext.threadLocals().a().b().e();
        }
    }

    @Override
    public Object cloneReturn(ContrastContext contrastContext, Object object) {
        Scoping scoping = contrastContext.scope();
        if (!this.eventContext.isEnabled() || !ScopeAssess.isCloneAllowed(scoping) || object == null) {
            return object;
        }
        Object object2 = object;
        try {
            com.contrastsecurity.agent.scope.a a2 = scoping.enterAutoScope(ScopeType.ASSESS);
            try {
                if (object2 instanceof Collection) {
                    AssessmentContext assessmentContext = contrastContext.assessment();
                    if (assessmentContext != null && !assessmentContext.hasAlreadyTracked(object)) {
                        object2 = com.contrastsecurity.agent.util.clone.a.a(object);
                    }
                } else {
                    object2 = com.contrastsecurity.agent.util.clone.a.a(object);
                }
                if (a2 != null) {
                    a2.close();
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (a2 != null) {
                    try {
                        a2.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.debug("Couldn't clone input for {}", object, (Object)exception2);
        }
        return object2;
    }

    @p
    public void _trackObject(ContrastContext contrastContext, Application application, com.contrastsecurity.agent.plugins.security.controller.a a2) throws Exception {
        if (this.policyManager.currentPolicy() == null) {
            return;
        }
        AssessmentContext assessmentContext = contrastContext.assessment();
        Object object = a2.c();
        SourceNode sourceNode = a2.a();
        if (sourceNode.isTaintObject()) {
            int n2 = EventHelper.getLength(assessmentContext, object);
            if (n2 == 0) {
                return;
            }
            a2.a(n2);
            this.sourceEventGenerator.a(contrastContext, a2);
        } else {
            COLLECTOR.a(contrastContext, object, sourceNode.isSourceType(u.e) ? new com.contrastsecurity.agent.plugins.security.controller.track.a.a(application, assessmentContext, a2, this.sourceEventGenerator, sourceNode) : new b(application, assessmentContext, a2, this.sourceEventGenerator, sourceNode));
        }
    }
}

