/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.e;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.services.ngreporting.p;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.d;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;

@DontObfuscate
@n
public class ProviderUtil {
    private final f legacyReportingService;
    private final Finding.d findingFactory;
    private final d traceFactory;
    private final e disabledRulesFilter;
    private final ContrastPolicyManager policyManager;
    private static final Logger logger = LoggerFactory.getLogger(ProviderUtil.class);

    public ProviderUtil(Finding.d d2, f f2, d d3, ContrastPolicyManager contrastPolicyManager, e e2) {
        this.policyManager = contrastPolicyManager;
        this.findingFactory = d2;
        this.legacyReportingService = f2;
        this.traceFactory = d3;
        this.disabledRulesFilter = e2;
    }

    public void reportFinding(ContrastContext contrastContext, String string, Map<PropertyKey, String> map, long l2) {
        this.reportFinding(contrastContext, string, map, l2, null, true);
    }

    public void reportFinding(ContrastContext contrastContext, String string, Map<PropertyKey, String> map, long l2, String string2) {
        this.reportFinding(contrastContext, string, map, l2, string2, true);
    }

    public void reportFinding(ContrastContext contrastContext, String string, Map<PropertyKey, String> map, long l2, String string2, boolean bl2) {
        this.reportFinding(contrastContext.application().current(), bl2 ? contrastContext.http().getRequest() : null, contrastContext.assessment(), string, map, l2, string2, null);
    }

    public void reportFinding(Application application, HttpRequest httpRequest, AssessmentContext assessmentContext, String string, Map<PropertyKey, String> map, long l2, String string2, p p2) {
        if (application == null) {
            logger.debug("Unable to send report, app == NULL");
            return;
        }
        if (this.disabledRulesFilter.a(application).test(string)) {
            logger.debug("Suppressed finding in {} for the disabled rule {}", (Object)application, (Object)string);
            return;
        }
        ContrastPolicy contrastPolicy = this.policyManager.currentPolicy();
        if (contrastPolicy == null) {
            return;
        }
        Rule rule = contrastPolicy.getRuleById(string);
        if (rule == null) {
            return;
        }
        Trace trace = this.traceFactory.a();
        trace.setEvidence(string2);
        trace.setRuleId(string);
        Finding finding = this.findingFactory.a(application, string, trace, l2);
        finding.setProperties(map);
        if (httpRequest != null) {
            finding.setRequest(httpRequest);
        }
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string, (Object)l2);
        if (assessmentContext != null) {
            assessmentContext.onFindingOccurred(string, finding);
        }
        finding.setListener(p2);
        this.legacyReportingService.a(finding);
    }
}

