/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.SimpleSleeper;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.commons.e;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.Purgeable;
import com.contrastsecurity.agent.services.c;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public final class PurgeThread
extends Thread {
    private final c service;
    private final List<Purgeable> purgeables;
    private final boolean profilePurgeables;
    private final e sleeper;
    private final o errorEmitter;
    private static final long WAIT_MS = TimeUnit.SECONDS.toMillis(30L);
    private static final Logger logger = LoggerFactory.getLogger(PurgeThread.class);

    PurgeThread(c c2, com.contrastsecurity.agent.config.e e2, List<Purgeable> list, o o2) {
        this.service = c2;
        this.purgeables = list;
        this.profilePurgeables = e2.getBoolean(ConfigProperty.PROFILE_PURGEABLES);
        this.sleeper = new SimpleSleeper();
        this.errorEmitter = Objects.requireNonNull(o2);
    }

    @Override
    @ScopedSensor
    public void run() {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            while (this.service.a) {
                int n2 = 0;
                int n3 = 0;
                ContrastContext contrastContext = ContrastContext.current();
                for (Purgeable purgeable : this.purgeables) {
                    int n4 = purgeable.purgeableCount(contrastContext);
                    try {
                        purgeable.purgeStale(contrastContext);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        throwable2 = Throwables.addClassLoaderInfoIfNecessary(throwable2);
                        this.errorEmitter.a(throwable2);
                        logger.error("Problem clearing purgeable {}", (Object)JVMUtils.getSafeToString(purgeable, true), (Object)throwable2);
                    }
                    int n5 = purgeable.purgeableCount(contrastContext);
                    n2 += n5 - n4;
                    n3 += n5;
                    if (this.profilePurgeables) {
                        PreConfigUtil.out("Purgeable: [" + JVMUtils.getSafeToString(purgeable, true) + "], before=" + n4 + ", after=" + n5);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Purgeable={}, before={}, after={}", JVMUtils.getSafeToString(purgeable, true), n4, n5);
                }
                logger.debug("Total purged={}, total still alive={}", (Object)n2, (Object)n3);
                this.sleeper.sleep(WAIT_MS);
            }
            logger.info("Stopped purging thread.");
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }
}

