/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.Descriptors;
import com.contrastsecurity.thirdparty.com.google.protobuf.DynamicMessage;
import com.contrastsecurity.thirdparty.com.google.protobuf.ExtensionRegistry;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import com.contrastsecurity.thirdparty.com.google.protobuf.MapEntry;
import com.contrastsecurity.thirdparty.com.google.protobuf.Message;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageOrBuilder;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageReflection;
import com.contrastsecurity.thirdparty.com.google.protobuf.TextFormatEscaper;
import com.contrastsecurity.thirdparty.com.google.protobuf.TextFormatParseInfoTree;
import com.contrastsecurity.thirdparty.com.google.protobuf.TextFormatParseLocation;
import com.contrastsecurity.thirdparty.com.google.protobuf.TypeRegistry;
import com.contrastsecurity.thirdparty.com.google.protobuf.UnknownFieldSet;
import com.contrastsecurity.thirdparty.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextFormat {
    private static final e logger = e.a(TextFormat.class.getName());
    private static final Parser PARSER = Parser.newBuilder().build();

    private TextFormat() {
    }

    @Deprecated
    public static void print(MessageOrBuilder messageOrBuilder, Appendable appendable) throws IOException {
        TextFormat.printer().print(messageOrBuilder, appendable);
    }

    @Deprecated
    public static void print(UnknownFieldSet unknownFieldSet, Appendable appendable) throws IOException {
        TextFormat.printer().print(unknownFieldSet, appendable);
    }

    @Deprecated
    public static void printUnicode(MessageOrBuilder messageOrBuilder, Appendable appendable) throws IOException {
        TextFormat.printer().escapingNonAscii(false).print(messageOrBuilder, appendable);
    }

    @Deprecated
    public static void printUnicode(UnknownFieldSet unknownFieldSet, Appendable appendable) throws IOException {
        TextFormat.printer().escapingNonAscii(false).print(unknownFieldSet, appendable);
    }

    public static String shortDebugString(MessageOrBuilder messageOrBuilder) {
        return TextFormat.printer().shortDebugString(messageOrBuilder);
    }

    @Deprecated
    public static String shortDebugString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        return TextFormat.printer().shortDebugString(fieldDescriptor, object);
    }

    @Deprecated
    public static String shortDebugString(UnknownFieldSet unknownFieldSet) {
        return TextFormat.printer().shortDebugString(unknownFieldSet);
    }

    @Deprecated
    public static String printToString(MessageOrBuilder messageOrBuilder) {
        return TextFormat.printer().printToString(messageOrBuilder);
    }

    @Deprecated
    public static String printToString(UnknownFieldSet unknownFieldSet) {
        return TextFormat.printer().printToString(unknownFieldSet);
    }

    @Deprecated
    public static String printToUnicodeString(MessageOrBuilder messageOrBuilder) {
        return TextFormat.printer().escapingNonAscii(false).printToString(messageOrBuilder);
    }

    @Deprecated
    public static String printToUnicodeString(UnknownFieldSet unknownFieldSet) {
        return TextFormat.printer().escapingNonAscii(false).printToString(unknownFieldSet);
    }

    @Deprecated
    public static void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        TextFormat.printer().printField(fieldDescriptor, object, appendable);
    }

    @Deprecated
    public static String printFieldToString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        return TextFormat.printer().printFieldToString(fieldDescriptor, object);
    }

    @Deprecated
    public static void printUnicodeFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        TextFormat.printer().escapingNonAscii(false).printFieldValue(fieldDescriptor, object, appendable);
    }

    @Deprecated
    public static void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        TextFormat.printer().printFieldValue(fieldDescriptor, object, appendable);
    }

    public static void printUnknownFieldValue(int n2, Object object, Appendable appendable) throws IOException {
        TextFormat.printUnknownFieldValue(n2, object, TextFormat.multiLineOutput(appendable));
    }

    private static void printUnknownFieldValue(int n2, Object object, TextGenerator textGenerator) throws IOException {
        switch (WireFormat.getTagWireType(n2)) {
            case 0: {
                textGenerator.print(TextFormat.unsignedToString((Long)object));
                break;
            }
            case 5: {
                textGenerator.print(String.format((Locale)null, "0x%08x", (Integer)object));
                break;
            }
            case 1: {
                textGenerator.print(String.format((Locale)null, "0x%016x", (Long)object));
                break;
            }
            case 2: {
                try {
                    UnknownFieldSet unknownFieldSet = UnknownFieldSet.parseFrom((ByteString)object);
                    textGenerator.print("{");
                    textGenerator.eol();
                    textGenerator.indent();
                    Printer.printUnknownFields(unknownFieldSet, textGenerator);
                    textGenerator.outdent();
                    textGenerator.print("}");
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    textGenerator.print("\"");
                    textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                    textGenerator.print("\"");
                }
                break;
            }
            case 3: {
                Printer.printUnknownFields((UnknownFieldSet)object, textGenerator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad tag: " + n2);
            }
        }
    }

    public static Printer printer() {
        return Printer.DEFAULT;
    }

    public static String unsignedToString(int n2) {
        if (n2 >= 0) {
            return Integer.toString(n2);
        }
        return Long.toString((long)n2 & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long l2) {
        if (l2 >= 0L) {
            return Long.toString(l2);
        }
        return BigInteger.valueOf(l2 & Long.MAX_VALUE).setBit(63).toString();
    }

    private static TextGenerator multiLineOutput(Appendable appendable) {
        return new TextGenerator(appendable, false);
    }

    private static TextGenerator singleLineOutput(Appendable appendable) {
        return new TextGenerator(appendable, true);
    }

    public static Parser getParser() {
        return PARSER;
    }

    public static void merge(Readable readable, Message.Builder builder) throws IOException {
        PARSER.merge(readable, builder);
    }

    public static void merge(CharSequence charSequence, Message.Builder builder) throws ParseException {
        PARSER.merge(charSequence, builder);
    }

    public static <T extends Message> T parse(CharSequence charSequence, Class<T> clazz) throws ParseException {
        Message.Builder builder = ((Message)Internal.getDefaultInstance(clazz)).newBuilderForType();
        TextFormat.merge(charSequence, builder);
        Message message = builder.build();
        return (T)message;
    }

    public static void merge(Readable readable, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        PARSER.merge(readable, extensionRegistry, builder);
    }

    public static void merge(CharSequence charSequence, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        PARSER.merge(charSequence, extensionRegistry, builder);
    }

    public static <T extends Message> T parse(CharSequence charSequence, ExtensionRegistry extensionRegistry, Class<T> clazz) throws ParseException {
        Message.Builder builder = ((Message)Internal.getDefaultInstance(clazz)).newBuilderForType();
        TextFormat.merge(charSequence, extensionRegistry, builder);
        Message message = builder.build();
        return (T)message;
    }

    public static String escapeBytes(ByteString byteString) {
        return TextFormatEscaper.escapeBytes(byteString);
    }

    public static String escapeBytes(byte[] byArray) {
        return TextFormatEscaper.escapeBytes(byArray);
    }

    public static ByteString unescapeBytes(CharSequence charSequence) throws InvalidEscapeSequenceException {
        ByteString byteString = ByteString.copyFromUtf8(charSequence.toString());
        byte[] byArray = new byte[byteString.size()];
        int n2 = 0;
        block16: for (int i2 = 0; i2 < byteString.size(); ++i2) {
            byte by = byteString.byteAt(i2);
            if (by == 92) {
                if (i2 + 1 < byteString.size()) {
                    int n3;
                    if (TextFormat.isOctal(by = byteString.byteAt(++i2))) {
                        n3 = TextFormat.digitValue(by);
                        if (i2 + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i2 + 1))) {
                            n3 = n3 * 8 + TextFormat.digitValue(byteString.byteAt(++i2));
                        }
                        if (i2 + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i2 + 1))) {
                            n3 = n3 * 8 + TextFormat.digitValue(byteString.byteAt(++i2));
                        }
                        byArray[n2++] = (byte)n3;
                        continue;
                    }
                    switch (by) {
                        case 97: {
                            byArray[n2++] = 7;
                            continue block16;
                        }
                        case 98: {
                            byArray[n2++] = 8;
                            continue block16;
                        }
                        case 102: {
                            byArray[n2++] = 12;
                            continue block16;
                        }
                        case 110: {
                            byArray[n2++] = 10;
                            continue block16;
                        }
                        case 114: {
                            byArray[n2++] = 13;
                            continue block16;
                        }
                        case 116: {
                            byArray[n2++] = 9;
                            continue block16;
                        }
                        case 118: {
                            byArray[n2++] = 11;
                            continue block16;
                        }
                        case 92: {
                            byArray[n2++] = 92;
                            continue block16;
                        }
                        case 39: {
                            byArray[n2++] = 39;
                            continue block16;
                        }
                        case 34: {
                            byArray[n2++] = 34;
                            continue block16;
                        }
                        case 63: {
                            byArray[n2++] = 63;
                            continue block16;
                        }
                        case 120: {
                            n3 = 0;
                            if (i2 + 1 >= byteString.size() || !TextFormat.isHex(byteString.byteAt(i2 + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            n3 = TextFormat.digitValue(byteString.byteAt(++i2));
                            if (i2 + 1 < byteString.size() && TextFormat.isHex(byteString.byteAt(i2 + 1))) {
                                n3 = n3 * 16 + TextFormat.digitValue(byteString.byteAt(++i2));
                            }
                            byArray[n2++] = (byte)n3;
                            continue block16;
                        }
                        case 117: {
                            Object object;
                            char c2;
                            if (++i2 + 3 < byteString.size() && TextFormat.isHex(byteString.byteAt(i2)) && TextFormat.isHex(byteString.byteAt(i2 + 1)) && TextFormat.isHex(byteString.byteAt(i2 + 2)) && TextFormat.isHex(byteString.byteAt(i2 + 3))) {
                                c2 = (char)(TextFormat.digitValue(byteString.byteAt(i2)) << 12 | TextFormat.digitValue(byteString.byteAt(i2 + 1)) << 8 | TextFormat.digitValue(byteString.byteAt(i2 + 2)) << 4 | TextFormat.digitValue(byteString.byteAt(i2 + 3)));
                                if (Character.isSurrogate(c2)) {
                                    throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\u' refers to a surrogate");
                                }
                                object = Character.toString(c2).getBytes(StandardCharsets.UTF_8);
                                System.arraycopy(object, 0, byArray, n2, ((Object)object).length);
                                n2 += ((Object)object).length;
                                i2 += 3;
                                continue block16;
                            }
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\u' with too few hex chars");
                        }
                        case 85: {
                            if (++i2 + 7 >= byteString.size()) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U' with too few hex chars");
                            }
                            char c2 = '\u0000';
                            for (int i3 = i2; i3 < i2 + 8; ++i3) {
                                byte by2 = byteString.byteAt(i3);
                                if (!TextFormat.isHex(by2)) {
                                    throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U' with too few hex chars");
                                }
                                c2 = c2 << 4 | TextFormat.digitValue(by2);
                            }
                            if (!Character.isValidCodePoint(c2)) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U" + byteString.substring(i2, i2 + 8).toStringUtf8() + "' is not a valid code point value");
                            }
                            Object object = Character.UnicodeBlock.of((int)c2);
                            if (((Character.Subset)object).equals(Character.UnicodeBlock.LOW_SURROGATES) || ((Character.Subset)object).equals(Character.UnicodeBlock.HIGH_SURROGATES) || ((Character.Subset)object).equals(Character.UnicodeBlock.HIGH_PRIVATE_USE_SURROGATES)) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U" + byteString.substring(i2, i2 + 8).toStringUtf8() + "' refers to a surrogate code unit");
                            }
                            int[] nArray = new int[]{c2};
                            byte[] byArray2 = new String(nArray, 0, 1).getBytes(StandardCharsets.UTF_8);
                            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                            n2 += byArray2.length;
                            i2 += 7;
                            continue block16;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)by + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            byArray[n2++] = by;
        }
        return byArray.length == n2 ? ByteString.wrap(byArray) : ByteString.copyFrom(byArray, 0, n2);
    }

    static String escapeText(String string) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(string));
    }

    public static String escapeDoubleQuotesAndBackslashes(String string) {
        return TextFormatEscaper.escapeDoubleQuotesAndBackslashes(string);
    }

    static String unescapeText(String string) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(string).toStringUtf8();
    }

    private static boolean isOctal(byte by) {
        return 48 <= by && by <= 55;
    }

    private static boolean isHex(byte by) {
        return 48 <= by && by <= 57 || 97 <= by && by <= 102 || 65 <= by && by <= 70;
    }

    private static int digitValue(byte by) {
        if (48 <= by && by <= 57) {
            return by - 48;
        }
        if (97 <= by && by <= 122) {
            return by - 97 + 10;
        }
        return by - 65 + 10;
    }

    static int parseInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, true, false);
    }

    static int parseUInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, false, false);
    }

    static long parseInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, true, true);
    }

    static long parseUInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, false, true);
    }

    private static long parseInteger(String string, boolean bl2, boolean bl3) throws NumberFormatException {
        int n2 = 0;
        boolean bl4 = false;
        if (string.startsWith("-", n2)) {
            if (!bl2) {
                throw new NumberFormatException("Number must be positive: " + string);
            }
            ++n2;
            bl4 = true;
        }
        int n3 = 10;
        if (string.startsWith("0x", n2)) {
            n2 += 2;
            n3 = 16;
        } else if (string.startsWith("0", n2)) {
            n3 = 8;
        }
        String string2 = string.substring(n2);
        long l2 = 0L;
        if (string2.length() < 16) {
            l2 = Long.parseLong(string2, n3);
            if (bl4) {
                l2 = -l2;
            }
            if (!bl3) {
                if (bl2) {
                    if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (l2 >= 0x100000000L || l2 < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            }
        } else {
            BigInteger bigInteger = new BigInteger(string2, n3);
            if (bl4) {
                bigInteger = bigInteger.negate();
            }
            if (!bl3) {
                if (bl2) {
                    if (bigInteger.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (bigInteger.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            } else if (bl2) {
                if (bigInteger.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + string);
                }
            } else if (bigInteger.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + string);
            }
            l2 = bigInteger.longValue();
        }
        return l2;
    }

    public static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String string) {
            super(string);
        }
    }

    public static class Parser {
        private final TypeRegistry typeRegistry;
        private final boolean allowUnknownFields;
        private final boolean allowUnknownEnumValues;
        private final boolean allowUnknownExtensions;
        private final SingularOverwritePolicy singularOverwritePolicy;
        private TextFormatParseInfoTree.Builder parseInfoTreeBuilder;
        private static final int BUFFER_SIZE = 4096;

        private Parser(TypeRegistry typeRegistry, boolean bl2, boolean bl3, boolean bl4, SingularOverwritePolicy singularOverwritePolicy, TextFormatParseInfoTree.Builder builder) {
            this.typeRegistry = typeRegistry;
            this.allowUnknownFields = bl2;
            this.allowUnknownEnumValues = bl3;
            this.allowUnknownExtensions = bl4;
            this.singularOverwritePolicy = singularOverwritePolicy;
            this.parseInfoTreeBuilder = builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public void merge(Readable readable, Message.Builder builder) throws IOException {
            this.merge(readable, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(CharSequence charSequence, Message.Builder builder) throws ParseException {
            this.merge(charSequence, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(Readable readable, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
            this.merge(Parser.toStringBuilder(readable), extensionRegistry, builder);
        }

        private static StringBuilder toStringBuilder(Readable readable) throws IOException {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            CharBuffer charBuffer = CharBuffer.allocate(4096);
            while ((n2 = readable.read(charBuffer)) != -1) {
                charBuffer.flip();
                stringBuilder.append(charBuffer, 0, n2);
            }
            return stringBuilder;
        }

        private void checkUnknownFields(List<UnknownField> list) throws ParseException {
            if (list.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("Input contains unknown fields and/or extensions:");
            for (UnknownField unknownField : list) {
                stringBuilder.append('\n').append(unknownField.message);
            }
            if (this.allowUnknownFields) {
                logger.c(stringBuilder.toString());
                return;
            }
            int n2 = 0;
            if (this.allowUnknownExtensions) {
                boolean bl2 = true;
                for (UnknownField unknownField : list) {
                    if (unknownField.type == UnknownField.Type.FIELD) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
                if (bl2) {
                    logger.c(stringBuilder.toString());
                    return;
                }
            }
            String[] stringArray = list.get((int)n2).message.split(":");
            throw new ParseException(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), stringBuilder.toString());
        }

        public void merge(CharSequence charSequence, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
            Tokenizer tokenizer = new Tokenizer(charSequence);
            MessageReflection.BuilderAdapter builderAdapter = new MessageReflection.BuilderAdapter(builder);
            ArrayList<UnknownField> arrayList = new ArrayList<UnknownField>();
            while (!tokenizer.atEnd()) {
                this.mergeField(tokenizer, extensionRegistry, builderAdapter, arrayList);
            }
            this.checkUnknownFields(arrayList);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, List<UnknownField> list) throws ParseException {
            this.mergeField(tokenizer, extensionRegistry, mergeTarget, this.parseInfoTreeBuilder, list);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, TextFormatParseInfoTree.Builder builder, List<UnknownField> list) throws ParseException {
            Object object;
            Descriptors.FieldDescriptor fieldDescriptor = null;
            int n2 = tokenizer.getLine();
            int n3 = tokenizer.getColumn();
            Descriptors.Descriptor descriptor = mergeTarget.getDescriptorForType();
            ExtensionRegistry.ExtensionInfo extensionInfo = null;
            if ("com.contrastsecurity.thirdparty.google.protobuf.Any".equals(descriptor.getFullName()) && tokenizer.tryConsume("[")) {
                this.mergeAnyFieldValue(tokenizer, extensionRegistry, mergeTarget, builder, list, descriptor);
                return;
            }
            if (tokenizer.tryConsume("[")) {
                object = new StringBuilder(tokenizer.consumeIdentifier());
                while (tokenizer.tryConsume(".")) {
                    ((StringBuilder)object).append('.');
                    ((StringBuilder)object).append(tokenizer.consumeIdentifier());
                }
                extensionInfo = mergeTarget.findExtensionByName(extensionRegistry, ((StringBuilder)object).toString());
                if (extensionInfo == null) {
                    String string = tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + descriptor.getFullName() + ".[" + object + "]";
                    list.add(new UnknownField(string, UnknownField.Type.EXTENSION));
                } else {
                    if (extensionInfo.descriptor.getContainingType() != descriptor) {
                        throw tokenizer.parseExceptionPreviousToken("Extension \"" + object + "\" does not extend message type \"" + descriptor.getFullName() + "\".");
                    }
                    fieldDescriptor = extensionInfo.descriptor;
                }
                tokenizer.consume("]");
            } else {
                String string;
                object = tokenizer.consumeIdentifier();
                fieldDescriptor = descriptor.findFieldByName((String)object);
                if (fieldDescriptor == null && (fieldDescriptor = descriptor.findFieldByName(string = ((String)object).toLowerCase(Locale.US))) != null && fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                    fieldDescriptor = null;
                }
                if (fieldDescriptor != null && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP && !fieldDescriptor.getMessageType().getName().equals(object)) {
                    fieldDescriptor = null;
                }
                if (fieldDescriptor == null) {
                    string = tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + descriptor.getFullName() + "." + (String)object;
                    list.add(new UnknownField(string, UnknownField.Type.FIELD));
                }
            }
            if (fieldDescriptor == null) {
                if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("{") && !tokenizer.lookingAt("<")) {
                    Parser.skipFieldValue(tokenizer);
                } else {
                    Parser.skipFieldMessage(tokenizer);
                }
                return;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                tokenizer.tryConsume(":");
                if (builder != null) {
                    object = builder.getBuilderForSubMessageField(fieldDescriptor);
                    this.consumeFieldValues(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, (TextFormatParseInfoTree.Builder)object, list);
                } else {
                    this.consumeFieldValues(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
                }
            } else {
                tokenizer.consume(":");
                this.consumeFieldValues(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
            }
            if (builder != null) {
                builder.setLocation(fieldDescriptor, TextFormatParseLocation.create(n2, n3));
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void consumeFieldValues(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, Descriptors.FieldDescriptor fieldDescriptor, ExtensionRegistry.ExtensionInfo extensionInfo, TextFormatParseInfoTree.Builder builder, List<UnknownField> list) throws ParseException {
            if (fieldDescriptor.isRepeated() && tokenizer.tryConsume("[")) {
                if (!tokenizer.tryConsume("]")) {
                    while (true) {
                        this.consumeFieldValue(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
                        if (!tokenizer.tryConsume("]")) {
                            tokenizer.consume(",");
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.consumeFieldValue(tokenizer, extensionRegistry, mergeTarget, fieldDescriptor, extensionInfo, builder, list);
            }
        }

        private void consumeFieldValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, Descriptors.FieldDescriptor fieldDescriptor, ExtensionRegistry.ExtensionInfo extensionInfo, TextFormatParseInfoTree.Builder builder, List<UnknownField> list) throws ParseException {
            if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && !fieldDescriptor.isRepeated()) {
                if (mergeTarget.hasField(fieldDescriptor)) {
                    throw tokenizer.parseExceptionPreviousToken("Non-repeated field \"" + fieldDescriptor.getFullName() + "\" cannot be overwritten.");
                }
                if (fieldDescriptor.getContainingOneof() != null && mergeTarget.hasOneof(fieldDescriptor.getContainingOneof())) {
                    Descriptors.OneofDescriptor oneofDescriptor = fieldDescriptor.getContainingOneof();
                    throw tokenizer.parseExceptionPreviousToken("Field \"" + fieldDescriptor.getFullName() + "\" is specified along with field \"" + mergeTarget.getOneofFieldDescriptor(oneofDescriptor).getFullName() + "\", another member of oneof \"" + oneofDescriptor.getName() + "\".");
                }
            }
            Object object = null;
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                String string;
                if (tokenizer.tryConsume("<")) {
                    string = ">";
                } else {
                    tokenizer.consume("{");
                    string = "}";
                }
                if (fieldDescriptor.getMessageType().getFullName().equals("com.contrastsecurity.thirdparty.google.protobuf.Any") && tokenizer.tryConsume("[")) {
                    DynamicMessage dynamicMessage = DynamicMessage.getDefaultInstance(fieldDescriptor.getMessageType());
                    MessageReflection.MergeTarget mergeTarget2 = mergeTarget.newMergeTargetForField(fieldDescriptor, dynamicMessage);
                    this.mergeAnyFieldValue(tokenizer, extensionRegistry, mergeTarget2, builder, list, fieldDescriptor.getMessageType());
                    object = mergeTarget2.finish();
                    tokenizer.consume(string);
                } else {
                    Message message = extensionInfo == null ? null : extensionInfo.defaultInstance;
                    MessageReflection.MergeTarget mergeTarget3 = mergeTarget.newMergeTargetForField(fieldDescriptor, message);
                    while (!tokenizer.tryConsume(string)) {
                        if (tokenizer.atEnd()) {
                            throw tokenizer.parseException("Expected \"" + string + "\".");
                        }
                        this.mergeField(tokenizer, extensionRegistry, mergeTarget3, builder, list);
                    }
                    object = mergeTarget3.finish();
                }
            } else {
                switch (fieldDescriptor.getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        object = tokenizer.consumeInt32();
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        object = tokenizer.consumeInt64();
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        object = tokenizer.consumeUInt32();
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        object = tokenizer.consumeUInt64();
                        break;
                    }
                    case FLOAT: {
                        object = Float.valueOf(tokenizer.consumeFloat());
                        break;
                    }
                    case DOUBLE: {
                        object = tokenizer.consumeDouble();
                        break;
                    }
                    case BOOL: {
                        object = tokenizer.consumeBoolean();
                        break;
                    }
                    case STRING: {
                        object = tokenizer.consumeString();
                        break;
                    }
                    case BYTES: {
                        object = tokenizer.consumeByteString();
                        break;
                    }
                    case ENUM: {
                        Descriptors.EnumDescriptor enumDescriptor = fieldDescriptor.getEnumType();
                        if (tokenizer.lookingAtInteger()) {
                            int n2 = tokenizer.consumeInt32();
                            object = enumDescriptor.findValueByNumber(n2);
                            if (object != null) break;
                            String string = "Enum type \"" + enumDescriptor.getFullName() + "\" has no value with number " + n2 + '.';
                            if (this.allowUnknownEnumValues) {
                                logger.c(string);
                                return;
                            }
                            throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumDescriptor.getFullName() + "\" has no value with number " + n2 + '.');
                        }
                        String string = tokenizer.consumeIdentifier();
                        object = enumDescriptor.findValueByName(string);
                        if (object != null) break;
                        String string2 = "Enum type \"" + enumDescriptor.getFullName() + "\" has no value named \"" + string + "\".";
                        if (this.allowUnknownEnumValues) {
                            logger.c(string2);
                            return;
                        }
                        throw tokenizer.parseExceptionPreviousToken(string2);
                    }
                    case MESSAGE: 
                    case GROUP: {
                        throw new RuntimeException("Can't get here.");
                    }
                }
            }
            if (fieldDescriptor.isRepeated()) {
                mergeTarget.addRepeatedField(fieldDescriptor, object);
            } else {
                mergeTarget.setField(fieldDescriptor, object);
            }
        }

        private void mergeAnyFieldValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget mergeTarget, TextFormatParseInfoTree.Builder builder, List<UnknownField> list, Descriptors.Descriptor descriptor) throws ParseException {
            String string;
            StringBuilder stringBuilder;
            block8: {
                stringBuilder = new StringBuilder();
                while (true) {
                    stringBuilder.append(tokenizer.consumeIdentifier());
                    if (tokenizer.tryConsume("]")) break block8;
                    if (tokenizer.tryConsume("/")) {
                        stringBuilder.append("/");
                        continue;
                    }
                    if (!tokenizer.tryConsume(".")) break;
                    stringBuilder.append(".");
                }
                throw tokenizer.parseExceptionPreviousToken("Expected a valid type URL.");
            }
            tokenizer.tryConsume(":");
            if (tokenizer.tryConsume("<")) {
                string = ">";
            } else {
                tokenizer.consume("{");
                string = "}";
            }
            String string2 = stringBuilder.toString();
            Descriptors.Descriptor descriptor2 = null;
            try {
                descriptor2 = this.typeRegistry.getDescriptorForTypeUrl(string2);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw tokenizer.parseException("Invalid valid type URL. Found: " + string2);
            }
            if (descriptor2 == null) {
                throw tokenizer.parseException("Unable to parse Any of type: " + string2 + ". Please make sure that the TypeRegistry contains the descriptors for the given types.");
            }
            DynamicMessage.Builder builder2 = DynamicMessage.getDefaultInstance(descriptor2).newBuilderForType();
            MessageReflection.BuilderAdapter builderAdapter = new MessageReflection.BuilderAdapter(builder2);
            while (!tokenizer.tryConsume(string)) {
                this.mergeField(tokenizer, extensionRegistry, builderAdapter, builder, list);
            }
            mergeTarget.setField(descriptor.findFieldByName("type_url"), stringBuilder.toString());
            mergeTarget.setField(descriptor.findFieldByName("value"), builder2.build().toByteString());
        }

        private static void skipField(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsume("[")) {
                do {
                    tokenizer.consumeIdentifier();
                } while (tokenizer.tryConsume("."));
                tokenizer.consume("]");
            } else {
                tokenizer.consumeIdentifier();
            }
            if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("<") && !tokenizer.lookingAt("{")) {
                Parser.skipFieldValue(tokenizer);
            } else {
                Parser.skipFieldMessage(tokenizer);
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private static void skipFieldMessage(Tokenizer tokenizer) throws ParseException {
            String string;
            if (tokenizer.tryConsume("<")) {
                string = ">";
            } else {
                tokenizer.consume("{");
                string = "}";
            }
            while (!tokenizer.lookingAt(">") && !tokenizer.lookingAt("}")) {
                Parser.skipField(tokenizer);
            }
            tokenizer.consume(string);
        }

        private static void skipFieldValue(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsumeString()) {
                while (tokenizer.tryConsumeString()) {
                }
                return;
            }
            if (!(tokenizer.tryConsumeIdentifier() || tokenizer.tryConsumeInt64() || tokenizer.tryConsumeUInt64() || tokenizer.tryConsumeDouble() || tokenizer.tryConsumeFloat())) {
                throw tokenizer.parseException("Invalid field value: " + tokenizer.currentToken);
            }
        }

        static final class UnknownField {
            final String message;
            final Type type;

            UnknownField(String string, Type type) {
                this.message = string;
                this.type = type;
            }

            static enum Type {
                FIELD,
                EXTENSION;

            }
        }

        public static class Builder {
            private boolean allowUnknownFields = false;
            private boolean allowUnknownEnumValues = false;
            private boolean allowUnknownExtensions = false;
            private SingularOverwritePolicy singularOverwritePolicy = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES;
            private TextFormatParseInfoTree.Builder parseInfoTreeBuilder = null;
            private TypeRegistry typeRegistry = TypeRegistry.getEmptyTypeRegistry();

            public Builder setTypeRegistry(TypeRegistry typeRegistry) {
                this.typeRegistry = typeRegistry;
                return this;
            }

            public Builder setAllowUnknownFields(boolean bl2) {
                this.allowUnknownFields = bl2;
                return this;
            }

            public Builder setAllowUnknownExtensions(boolean bl2) {
                this.allowUnknownExtensions = bl2;
                return this;
            }

            public Builder setSingularOverwritePolicy(SingularOverwritePolicy singularOverwritePolicy) {
                this.singularOverwritePolicy = singularOverwritePolicy;
                return this;
            }

            public Builder setParseInfoTreeBuilder(TextFormatParseInfoTree.Builder builder) {
                this.parseInfoTreeBuilder = builder;
                return this;
            }

            public Parser build() {
                return new Parser(this.typeRegistry, this.allowUnknownFields, this.allowUnknownEnumValues, this.allowUnknownExtensions, this.singularOverwritePolicy, this.parseInfoTreeBuilder);
            }
        }

        public static enum SingularOverwritePolicy {
            ALLOW_SINGULAR_OVERWRITES,
            FORBID_SINGULAR_OVERWRITES;

        }
    }

    public static class UnknownFieldParseException
    extends ParseException {
        private final String unknownField;

        public UnknownFieldParseException(String string) {
            this(-1, -1, "", string);
        }

        public UnknownFieldParseException(int n2, int n3, String string, String string2) {
            super(n2, n3, string2);
            this.unknownField = string;
        }

        public String getUnknownField() {
            return this.unknownField;
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String string) {
            this(-1, -1, string);
        }

        public ParseException(int n2, int n3, String string) {
            super(Integer.toString(n2) + ":" + n3 + ": " + string);
            this.line = n2;
            this.column = n3;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence charSequence) {
            this.text = charSequence;
            this.matcher = WHITESPACE.matcher(charSequence);
            this.skipWhitespace();
            this.nextToken();
        }

        int getPreviousLine() {
            return this.previousLine;
        }

        int getPreviousColumn() {
            return this.previousColumn;
        }

        int getLine() {
            return this.line;
        }

        int getColumn() {
            return this.column;
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String string) {
            if (this.currentToken.equals(string)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String string) throws ParseException {
            if (!this.tryConsume(string)) {
                throw this.parseException("Expected \"" + string + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c2 = this.currentToken.charAt(0);
            return '0' <= c2 && c2 <= '9' || c2 == '-' || c2 == '+';
        }

        public boolean lookingAt(String string) {
            return this.currentToken.equals(string);
        }

        public String consumeIdentifier() throws ParseException {
            for (int i2 = 0; i2 < this.currentToken.length(); ++i2) {
                char c2 = this.currentToken.charAt(i2);
                if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == '_' || c2 == '.') continue;
                throw this.parseException("Expected identifier. Found '" + this.currentToken + "'");
            }
            String string = this.currentToken;
            this.nextToken();
            return string;
        }

        public boolean tryConsumeIdentifier() {
            try {
                this.consumeIdentifier();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public int consumeInt32() throws ParseException {
            try {
                int n2 = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int n2 = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long l2 = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public boolean tryConsumeInt64() {
            try {
                this.consumeInt64();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long l2 = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public boolean tryConsumeUInt64() {
            try {
                this.consumeUInt64();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl2 = this.currentToken.startsWith("-");
                this.nextToken();
                return bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double d2 = Double.parseDouble(this.currentToken);
                this.nextToken();
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public boolean tryConsumeDouble() {
            try {
                this.consumeDouble();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl2 = this.currentToken.startsWith("-");
                this.nextToken();
                return bl2 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float f2 = Float.parseFloat(this.currentToken);
                this.nextToken();
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public boolean tryConsumeFloat() {
            try {
                this.consumeFloat();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("True") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("False") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\". Found \"" + this.currentToken + "\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public boolean tryConsumeString() {
            try {
                this.consumeString();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
            this.consumeByteString(arrayList);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(arrayList);
            }
            return ByteString.copyFrom(arrayList);
        }

        private void consumeByteString(List<ByteString> list) throws ParseException {
            char c2;
            char c3 = c2 = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (c2 != '\"' && c2 != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != c2) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String string = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString byteString = TextFormat.unescapeBytes(string);
                this.nextToken();
                list.add(byteString);
            }
            catch (InvalidEscapeSequenceException invalidEscapeSequenceException) {
                throw this.parseException(invalidEscapeSequenceException.getMessage());
            }
        }

        public ParseException parseException(String string) {
            return new ParseException(this.line + 1, this.column + 1, string);
        }

        public ParseException parseExceptionPreviousToken(String string) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, string);
        }

        private ParseException integerParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse integer: " + numberFormatException.getMessage());
        }

        private ParseException floatParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse number: " + numberFormatException.getMessage());
        }

        public UnknownFieldParseException unknownFieldParseExceptionPreviousToken(String string, String string2) {
            return new UnknownFieldParseException(this.previousLine + 1, this.previousColumn + 1, string, string2);
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private final boolean singleLineMode;
        private boolean atStartOfLine = false;

        private TextGenerator(Appendable appendable, boolean bl2) {
            this.output = appendable;
            this.singleLineMode = bl2;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int n2 = this.indent.length();
            if (n2 == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.setLength(n2 - 2);
        }

        public void print(CharSequence charSequence) throws IOException {
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.singleLineMode ? " " : this.indent);
            }
            this.output.append(charSequence);
        }

        public void eol() throws IOException {
            if (!this.singleLineMode) {
                this.output.append("\n");
            }
            this.atStartOfLine = true;
        }
    }

    public static final class Printer {
        private static final Printer DEFAULT = new Printer(true, TypeRegistry.getEmptyTypeRegistry());
        private final boolean escapeNonAscii;
        private final TypeRegistry typeRegistry;

        private Printer(boolean bl2, TypeRegistry typeRegistry) {
            this.escapeNonAscii = bl2;
            this.typeRegistry = typeRegistry;
        }

        public Printer escapingNonAscii(boolean bl2) {
            return new Printer(bl2, this.typeRegistry);
        }

        public Printer usingTypeRegistry(TypeRegistry typeRegistry) {
            if (this.typeRegistry != TypeRegistry.getEmptyTypeRegistry()) {
                throw new IllegalArgumentException("Only one typeRegistry is allowed.");
            }
            return new Printer(this.escapeNonAscii, typeRegistry);
        }

        public void print(MessageOrBuilder messageOrBuilder, Appendable appendable) throws IOException {
            this.print(messageOrBuilder, TextFormat.multiLineOutput(appendable));
        }

        public void print(UnknownFieldSet unknownFieldSet, Appendable appendable) throws IOException {
            Printer.printUnknownFields(unknownFieldSet, TextFormat.multiLineOutput(appendable));
        }

        private void print(MessageOrBuilder messageOrBuilder, TextGenerator textGenerator) throws IOException {
            if (messageOrBuilder.getDescriptorForType().getFullName().equals("com.contrastsecurity.thirdparty.google.protobuf.Any") && this.printAny(messageOrBuilder, textGenerator)) {
                return;
            }
            this.printMessage(messageOrBuilder, textGenerator);
        }

        private boolean printAny(MessageOrBuilder messageOrBuilder, TextGenerator textGenerator) throws IOException {
            Descriptors.Descriptor descriptor = messageOrBuilder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor fieldDescriptor2 = descriptor.findFieldByNumber(2);
            if (fieldDescriptor == null || fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.STRING || fieldDescriptor2 == null || fieldDescriptor2.getType() != Descriptors.FieldDescriptor.Type.BYTES) {
                return false;
            }
            String string = (String)messageOrBuilder.getField(fieldDescriptor);
            if (string.isEmpty()) {
                return false;
            }
            Object object = messageOrBuilder.getField(fieldDescriptor2);
            DynamicMessage.Builder builder = null;
            try {
                Descriptors.Descriptor descriptor2 = this.typeRegistry.getDescriptorForTypeUrl(string);
                if (descriptor2 == null) {
                    return false;
                }
                builder = DynamicMessage.getDefaultInstance(descriptor2).newBuilderForType();
                builder.mergeFrom((ByteString)object);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                return false;
            }
            textGenerator.print("[");
            textGenerator.print(string);
            textGenerator.print("] {");
            textGenerator.eol();
            textGenerator.indent();
            this.print((MessageOrBuilder)builder, textGenerator);
            textGenerator.outdent();
            textGenerator.print("}");
            textGenerator.eol();
            return true;
        }

        public String printFieldToString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.printField(fieldDescriptor, object, stringBuilder);
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
            this.printField(fieldDescriptor, object, TextFormat.multiLineOutput(appendable));
        }

        private void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            if (fieldDescriptor.isMapField()) {
                ArrayList<MapEntryAdapter> arrayList = new ArrayList<MapEntryAdapter>();
                for (Object object2 : (List)object) {
                    arrayList.add(new MapEntryAdapter(object2, fieldDescriptor));
                }
                Collections.sort(arrayList);
                for (MapEntryAdapter mapEntryAdapter : arrayList) {
                    this.printSingleField(fieldDescriptor, mapEntryAdapter.getEntry(), textGenerator);
                }
            } else if (fieldDescriptor.isRepeated()) {
                for (Object e2 : (List)object) {
                    this.printSingleField(fieldDescriptor, e2, textGenerator);
                }
            } else {
                this.printSingleField(fieldDescriptor, object, textGenerator);
            }
        }

        public void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
            this.printFieldValue(fieldDescriptor, object, TextFormat.multiLineOutput(appendable));
        }

        private void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            switch (fieldDescriptor.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    textGenerator.print(((Integer)object).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    textGenerator.print(((Long)object).toString());
                    break;
                }
                case BOOL: {
                    textGenerator.print(((Boolean)object).toString());
                    break;
                }
                case FLOAT: {
                    textGenerator.print(((Float)object).toString());
                    break;
                }
                case DOUBLE: {
                    textGenerator.print(((Double)object).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    textGenerator.print(TextFormat.unsignedToString((Integer)object));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    textGenerator.print(TextFormat.unsignedToString((Long)object));
                    break;
                }
                case STRING: {
                    textGenerator.print("\"");
                    textGenerator.print(this.escapeNonAscii ? TextFormatEscaper.escapeText((String)object) : TextFormat.escapeDoubleQuotesAndBackslashes((String)object).replace("\n", "\\n"));
                    textGenerator.print("\"");
                    break;
                }
                case BYTES: {
                    textGenerator.print("\"");
                    if (object instanceof ByteString) {
                        textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                    } else {
                        textGenerator.print(TextFormat.escapeBytes((byte[])object));
                    }
                    textGenerator.print("\"");
                    break;
                }
                case ENUM: {
                    textGenerator.print(((Descriptors.EnumValueDescriptor)object).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((MessageOrBuilder)((Message)object), textGenerator);
                }
            }
        }

        public String printToString(MessageOrBuilder messageOrBuilder) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.print(messageOrBuilder, (Appendable)stringBuilder);
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public String printToString(UnknownFieldSet unknownFieldSet) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.print(unknownFieldSet, (Appendable)stringBuilder);
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public String shortDebugString(MessageOrBuilder messageOrBuilder) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.print(messageOrBuilder, TextFormat.singleLineOutput(stringBuilder));
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public String shortDebugString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.printField(fieldDescriptor, object, TextFormat.singleLineOutput(stringBuilder));
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public String shortDebugString(UnknownFieldSet unknownFieldSet) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                Printer.printUnknownFields(unknownFieldSet, TextFormat.singleLineOutput(stringBuilder));
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        private static void printUnknownFieldValue(int n2, Object object, TextGenerator textGenerator) throws IOException {
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    textGenerator.print(TextFormat.unsignedToString((Long)object));
                    break;
                }
                case 5: {
                    textGenerator.print(String.format((Locale)null, "0x%08x", (Integer)object));
                    break;
                }
                case 1: {
                    textGenerator.print(String.format((Locale)null, "0x%016x", (Long)object));
                    break;
                }
                case 2: {
                    try {
                        UnknownFieldSet unknownFieldSet = UnknownFieldSet.parseFrom((ByteString)object);
                        textGenerator.print("{");
                        textGenerator.eol();
                        textGenerator.indent();
                        Printer.printUnknownFields(unknownFieldSet, textGenerator);
                        textGenerator.outdent();
                        textGenerator.print("}");
                    }
                    catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                        textGenerator.print("\"");
                        textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                        textGenerator.print("\"");
                    }
                    break;
                }
                case 3: {
                    Printer.printUnknownFields((UnknownFieldSet)object, textGenerator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag: " + n2);
                }
            }
        }

        private void printMessage(MessageOrBuilder messageOrBuilder, TextGenerator textGenerator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : messageOrBuilder.getAllFields().entrySet()) {
                this.printField(entry.getKey(), entry.getValue(), textGenerator);
            }
            Printer.printUnknownFields(messageOrBuilder.getUnknownFields(), textGenerator);
        }

        private void printSingleField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            if (fieldDescriptor.isExtension()) {
                textGenerator.print("[");
                if (fieldDescriptor.getContainingType().getOptions().getMessageSetWireFormat() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && fieldDescriptor.isOptional() && fieldDescriptor.getExtensionScope() == fieldDescriptor.getMessageType()) {
                    textGenerator.print(fieldDescriptor.getMessageType().getFullName());
                } else {
                    textGenerator.print(fieldDescriptor.getFullName());
                }
                textGenerator.print("]");
            } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                textGenerator.print(fieldDescriptor.getMessageType().getName());
            } else {
                textGenerator.print(fieldDescriptor.getName());
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                textGenerator.print(" {");
                textGenerator.eol();
                textGenerator.indent();
            } else {
                textGenerator.print(": ");
            }
            this.printFieldValue(fieldDescriptor, object, textGenerator);
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                textGenerator.outdent();
                textGenerator.print("}");
            }
            textGenerator.eol();
        }

        private static void printUnknownFields(UnknownFieldSet unknownFieldSet, TextGenerator textGenerator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFieldSet.asMap().entrySet()) {
                int n2 = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                Printer.printUnknownField(n2, 0, field.getVarintList(), textGenerator);
                Printer.printUnknownField(n2, 5, field.getFixed32List(), textGenerator);
                Printer.printUnknownField(n2, 1, field.getFixed64List(), textGenerator);
                Printer.printUnknownField(n2, 2, field.getLengthDelimitedList(), textGenerator);
                for (UnknownFieldSet unknownFieldSet2 : field.getGroupList()) {
                    textGenerator.print(entry.getKey().toString());
                    textGenerator.print(" {");
                    textGenerator.eol();
                    textGenerator.indent();
                    Printer.printUnknownFields(unknownFieldSet2, textGenerator);
                    textGenerator.outdent();
                    textGenerator.print("}");
                    textGenerator.eol();
                }
            }
        }

        private static void printUnknownField(int n2, int n3, List<?> list, TextGenerator textGenerator) throws IOException {
            for (Object obj : list) {
                textGenerator.print(String.valueOf(n2));
                textGenerator.print(": ");
                Printer.printUnknownFieldValue(n3, obj, textGenerator);
                textGenerator.eol();
            }
        }

        private static class MapEntryAdapter
        implements Comparable<MapEntryAdapter> {
            private Object entry;
            private MapEntry mapEntry;
            private final Descriptors.FieldDescriptor.JavaType fieldType;

            public MapEntryAdapter(Object object, Descriptors.FieldDescriptor fieldDescriptor) {
                if (object instanceof MapEntry) {
                    this.mapEntry = (MapEntry)object;
                } else {
                    this.entry = object;
                }
                this.fieldType = MapEntryAdapter.extractFieldType(fieldDescriptor);
            }

            private static Descriptors.FieldDescriptor.JavaType extractFieldType(Descriptors.FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getMessageType().getFields().get(0).getJavaType();
            }

            public Object getKey() {
                if (this.mapEntry != null) {
                    return this.mapEntry.getKey();
                }
                return null;
            }

            public Object getEntry() {
                if (this.mapEntry != null) {
                    return this.mapEntry;
                }
                return this.entry;
            }

            @Override
            public int compareTo(MapEntryAdapter mapEntryAdapter) {
                if (this.getKey() == null || mapEntryAdapter.getKey() == null) {
                    logger.d("Invalid key for map field.");
                    return -1;
                }
                switch (this.fieldType) {
                    case BOOLEAN: {
                        return Boolean.compare((Boolean)this.getKey(), (Boolean)mapEntryAdapter.getKey());
                    }
                    case LONG: {
                        return Long.compare((Long)this.getKey(), (Long)mapEntryAdapter.getKey());
                    }
                    case INT: {
                        return Integer.compare((Integer)this.getKey(), (Integer)mapEntryAdapter.getKey());
                    }
                    case STRING: {
                        String string = (String)this.getKey();
                        String string2 = (String)mapEntryAdapter.getKey();
                        if (string == null && string2 == null) {
                            return 0;
                        }
                        if (string == null && string2 != null) {
                            return -1;
                        }
                        if (string != null && string2 == null) {
                            return 1;
                        }
                        return string.compareTo(string2);
                    }
                }
                return 0;
            }
        }
    }
}

