/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.BuiltinExchangeType;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Command;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConfirmListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Consumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Envelope;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.FlowListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.GetResponse;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MessageProperties;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.NoOpMetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ReturnListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.UnexpectedMethodError;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQChannel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQCommand;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQImpl;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConsumerDispatcher;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConsumerWorkService;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Method;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.WorkPoolFullException;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.Utility;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;

public class ChannelN
extends AMQChannel
implements Channel {
    private static final String UNSPECIFIED_OUT_OF_BAND = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelN.class);
    private final Map<String, Consumer> _consumers = Collections.synchronizedMap(new HashMap());
    private final Collection<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private final Collection<FlowListener> flowListeners = new CopyOnWriteArrayList<FlowListener>();
    private final Collection<ConfirmListener> confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
    private long nextPublishSeqNo = 0L;
    private volatile Consumer defaultConsumer = null;
    private final ConsumerDispatcher dispatcher;
    private volatile CountDownLatch finishedShutdownFlag = null;
    private final SortedSet<Long> unconfirmedSet = Collections.synchronizedSortedSet(new TreeSet());
    private volatile boolean onlyAcksReceived = true;
    protected final MetricsCollector metricsCollector;

    public ChannelN(AMQConnection aMQConnection, int n2, ConsumerWorkService consumerWorkService) {
        this(aMQConnection, n2, consumerWorkService, new NoOpMetricsCollector());
    }

    public ChannelN(AMQConnection aMQConnection, int n2, ConsumerWorkService consumerWorkService, MetricsCollector metricsCollector) {
        super(aMQConnection, n2);
        this.dispatcher = new ConsumerDispatcher(aMQConnection, this, consumerWorkService);
        this.metricsCollector = metricsCollector;
    }

    public void open() throws IOException {
        this.exnWrappingRpc(new AMQImpl.Channel.Open(UNSPECIFIED_OUT_OF_BAND));
    }

    @Override
    public void addReturnListener(ReturnListener returnListener) {
        this.returnListeners.add(returnListener);
    }

    @Override
    public boolean removeReturnListener(ReturnListener returnListener) {
        return this.returnListeners.remove(returnListener);
    }

    @Override
    public void clearReturnListeners() {
        this.returnListeners.clear();
    }

    @Override
    @Deprecated
    public void addFlowListener(FlowListener flowListener) {
        this.flowListeners.add(flowListener);
    }

    @Override
    @Deprecated
    public boolean removeFlowListener(FlowListener flowListener) {
        return this.flowListeners.remove(flowListener);
    }

    @Override
    @Deprecated
    public void clearFlowListeners() {
        this.flowListeners.clear();
    }

    @Override
    public void addConfirmListener(ConfirmListener confirmListener) {
        this.confirmListeners.add(confirmListener);
    }

    @Override
    public boolean removeConfirmListener(ConfirmListener confirmListener) {
        return this.confirmListeners.remove(confirmListener);
    }

    @Override
    public void clearConfirmListeners() {
        this.confirmListeners.clear();
    }

    @Override
    public boolean waitForConfirms() throws InterruptedException {
        boolean bl2 = false;
        try {
            bl2 = this.waitForConfirms(0L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return bl2;
    }

    @Override
    public boolean waitForConfirms(long l2) throws InterruptedException, TimeoutException {
        if (this.nextPublishSeqNo == 0L) {
            throw new IllegalStateException("Confirms not selected");
        }
        long l3 = System.currentTimeMillis();
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            while (true) {
                if (this.getCloseReason() != null) {
                    throw Utility.fixStackTrace(this.getCloseReason());
                }
                if (this.unconfirmedSet.isEmpty()) {
                    boolean bl2 = this.onlyAcksReceived;
                    this.onlyAcksReceived = true;
                    return bl2;
                }
                if (l2 == 0L) {
                    this.unconfirmedSet.wait();
                    continue;
                }
                long l4 = System.currentTimeMillis() - l3;
                if (l2 <= l4) break;
                this.unconfirmedSet.wait(l2 - l4);
            }
            throw new TimeoutException();
        }
    }

    @Override
    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        try {
            this.waitForConfirmsOrDie(0L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Override
    public void waitForConfirmsOrDie(long l2) throws IOException, InterruptedException, TimeoutException {
        try {
            if (!this.waitForConfirms(l2)) {
                this.close(200, "NACKS RECEIVED", true, null, false);
                throw new IOException("nacks received");
            }
        }
        catch (TimeoutException timeoutException) {
            this.close(406, "TIMEOUT WAITING FOR ACK");
            throw timeoutException;
        }
    }

    @Override
    public Consumer getDefaultConsumer() {
        return this.defaultConsumer;
    }

    @Override
    public void setDefaultConsumer(Consumer consumer) {
        this.defaultConsumer = consumer;
    }

    private void broadcastShutdownSignal(ShutdownSignalException shutdownSignalException) {
        this.finishedShutdownFlag = this.dispatcher.handleShutdownSignal(Utility.copy(this._consumers), shutdownSignalException);
    }

    private void startProcessShutdownSignal(ShutdownSignalException shutdownSignalException, boolean bl2, boolean bl3) {
        super.processShutdownSignal(shutdownSignalException, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcessShutdownSignal() {
        this.dispatcher.quiesce();
        this.broadcastShutdownSignal(this.getCloseReason());
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            this.unconfirmedSet.notifyAll();
        }
    }

    @Override
    public void processShutdownSignal(ShutdownSignalException shutdownSignalException, boolean bl2, boolean bl3) {
        this.startProcessShutdownSignal(shutdownSignalException, bl2, bl3);
        this.finishProcessShutdownSignal();
    }

    CountDownLatch getShutdownLatch() {
        return this.finishedShutdownFlag;
    }

    private void releaseChannel() {
        ((AMQConnection)this.getConnection()).disconnectChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAsync(Command command) throws IOException {
        com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method = command.getMethod();
        if (method instanceof AMQImpl.Channel.Close) {
            this.asyncShutdown(command);
            return true;
        }
        if (this.isOpen()) {
            if (method instanceof AMQImpl.Basic.Deliver) {
                this.processDelivery(command, (AMQImpl.Basic.Deliver)method);
                return true;
            }
            if (method instanceof AMQImpl.Basic.Return) {
                this.callReturnListeners(command, (AMQImpl.Basic.Return)method);
                return true;
            }
            if (method instanceof AMQImpl.Channel.Flow) {
                AMQImpl.Channel.Flow flow = (AMQImpl.Channel.Flow)method;
                Object object = this._channelMutex;
                synchronized (object) {
                    this._blockContent = !flow.getActive();
                    this.transmit(new AMQImpl.Channel.FlowOk(!this._blockContent));
                    this._channelMutex.notifyAll();
                }
                this.callFlowListeners(command, flow);
                return true;
            }
            if (method instanceof AMQImpl.Basic.Ack) {
                AMQImpl.Basic.Ack ack = (AMQImpl.Basic.Ack)method;
                this.callConfirmListeners(command, ack);
                this.handleAckNack(ack.getDeliveryTag(), ack.getMultiple(), false);
                return true;
            }
            if (method instanceof AMQImpl.Basic.Nack) {
                AMQImpl.Basic.Nack nack = (AMQImpl.Basic.Nack)method;
                this.callConfirmListeners(command, nack);
                this.handleAckNack(nack.getDeliveryTag(), nack.getMultiple(), true);
                return true;
            }
            if (method instanceof AMQImpl.Basic.RecoverOk) {
                for (Map.Entry<String, Consumer> entry : Utility.copy(this._consumers).entrySet()) {
                    this.dispatcher.handleRecoverOk(entry.getValue(), entry.getKey());
                }
                return false;
            }
            if (method instanceof AMQImpl.Basic.Cancel) {
                AMQImpl.Basic.Cancel cancel = (AMQImpl.Basic.Cancel)method;
                String string = cancel.getConsumerTag();
                Consumer consumer = this._consumers.remove(string);
                if (consumer == null) {
                    consumer = this.defaultConsumer;
                }
                if (consumer != null) {
                    try {
                        this.dispatcher.handleCancel(consumer, string);
                    }
                    catch (WorkPoolFullException workPoolFullException) {
                        throw workPoolFullException;
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        ((AMQConnection)this.getConnection()).getExceptionHandler().handleConsumerException(this, throwable2, consumer, string, "handleCancel");
                    }
                }
                return true;
            }
            return false;
        }
        return !(method instanceof AMQImpl.Channel.CloseOk);
    }

    protected void processDelivery(Command command, AMQImpl.Basic.Deliver deliver) {
        AMQImpl.Basic.Deliver deliver2 = deliver;
        Consumer consumer = this._consumers.get(deliver2.getConsumerTag());
        if (consumer == null) {
            if (this.defaultConsumer == null) {
                throw new IllegalStateException("Unsolicited delivery - see Channel.setDefaultConsumer to handle this case.");
            }
            consumer = this.defaultConsumer;
        }
        Envelope envelope = new Envelope(deliver2.getDeliveryTag(), deliver2.getRedelivered(), deliver2.getExchange(), deliver2.getRoutingKey());
        try {
            this.metricsCollector.consumedMessage((Channel)this, deliver2.getDeliveryTag(), deliver2.getConsumerTag());
            this.dispatcher.handleDelivery(consumer, deliver2.getConsumerTag(), envelope, (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
        }
        catch (WorkPoolFullException workPoolFullException) {
            throw workPoolFullException;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleConsumerException(this, throwable2, consumer, deliver2.getConsumerTag(), "handleDelivery");
        }
    }

    private void callReturnListeners(Command command, AMQImpl.Basic.Return return_) {
        try {
            for (ReturnListener returnListener : this.returnListeners) {
                returnListener.handleReturn(return_.getReplyCode(), return_.getReplyText(), return_.getExchange(), return_.getRoutingKey(), (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleReturnListenerException(this, throwable2);
        }
    }

    private void callFlowListeners(Command command, AMQImpl.Channel.Flow flow) {
        try {
            for (FlowListener flowListener : this.flowListeners) {
                flowListener.handleFlow(flow.getActive());
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleFlowListenerException(this, throwable2);
        }
    }

    private void callConfirmListeners(Command command, AMQImpl.Basic.Ack ack) {
        try {
            for (ConfirmListener confirmListener : this.confirmListeners) {
                confirmListener.handleAck(ack.getDeliveryTag(), ack.getMultiple());
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleConfirmListenerException(this, throwable2);
        }
    }

    private void callConfirmListeners(Command command, AMQImpl.Basic.Nack nack) {
        try {
            for (ConfirmListener confirmListener : this.confirmListeners) {
                confirmListener.handleNack(nack.getDeliveryTag(), nack.getMultiple());
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleConfirmListenerException(this, throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncShutdown(Command command) throws IOException {
        ShutdownSignalException shutdownSignalException = new ShutdownSignalException(false, false, command.getMethod(), this);
        Object object = this._channelMutex;
        synchronized (object) {
            try {
                this.processShutdownSignal(shutdownSignalException, true, false);
                this.quiescingTransmit(new AMQImpl.Channel.CloseOk());
            }
            finally {
                this.releaseChannel();
                this.notifyOutstandingRpc(shutdownSignalException);
            }
        }
        this.notifyListeners();
    }

    @Override
    public void close() throws IOException, TimeoutException {
        this.close(200, "OK");
    }

    @Override
    public void close(int n2, String string) throws IOException, TimeoutException {
        this.close(n2, string, true, null, false);
    }

    @Override
    public void abort() throws IOException {
        this.abort(200, "OK");
    }

    @Override
    public void abort(int n2, String string) throws IOException {
        try {
            this.close(n2, string, true, null, true);
        }
        catch (IOException iOException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(int n2, String string, boolean bl2, Throwable throwable, boolean bl3) throws IOException, TimeoutException {
        AMQImpl.Channel.Close close = new AMQImpl.Channel.Close(n2, string, 0, 0);
        ShutdownSignalException shutdownSignalException = new ShutdownSignalException(false, bl2, close, this);
        if (throwable != null) {
            shutdownSignalException.initCause(throwable);
        }
        AMQChannel.BlockingRpcContinuation<AMQCommand> blockingRpcContinuation = new AMQChannel.BlockingRpcContinuation<AMQCommand>(){

            @Override
            public AMQCommand transformReply(AMQCommand aMQCommand) {
                ChannelN.this.finishProcessShutdownSignal();
                return aMQCommand;
            }
        };
        boolean bl4 = false;
        try {
            Object object = this._channelMutex;
            synchronized (object) {
                this.startProcessShutdownSignal(shutdownSignalException, !bl2, true);
                this.quiescingRpc(close, blockingRpcContinuation);
            }
            bl4 = true;
            blockingRpcContinuation.getReply(10000);
        }
        catch (TimeoutException timeoutException) {
            if (!bl3) {
                throw timeoutException;
            }
        }
        catch (ShutdownSignalException shutdownSignalException2) {
            if (!bl3) {
                throw shutdownSignalException2;
            }
        }
        catch (IOException iOException) {
            if (!bl3) {
                throw iOException;
            }
        }
        finally {
            if (bl3 || bl4) {
                this.releaseChannel();
                this.notifyListeners();
            }
        }
    }

    @Override
    public void basicQos(int n2, int n3, boolean bl2) throws IOException {
        this.exnWrappingRpc(new AMQImpl.Basic.Qos(n2, n3, bl2));
    }

    @Override
    public void basicQos(int n2, boolean bl2) throws IOException {
        this.basicQos(0, n2, bl2);
    }

    @Override
    public void basicQos(int n2) throws IOException {
        this.basicQos(0, n2, false);
    }

    @Override
    public void basicPublish(String string, String string2, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.basicPublish(string, string2, false, basicProperties, byArray);
    }

    @Override
    public void basicPublish(String string, String string2, boolean bl2, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.basicPublish(string, string2, bl2, false, basicProperties, byArray);
    }

    @Override
    public void basicPublish(String string, String string2, boolean bl2, boolean bl3, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        if (this.nextPublishSeqNo > 0L) {
            this.unconfirmedSet.add(this.getNextPublishSeqNo());
            ++this.nextPublishSeqNo;
        }
        AMQP.BasicProperties basicProperties2 = basicProperties;
        if (basicProperties == null) {
            basicProperties2 = MessageProperties.MINIMAL_BASIC;
        }
        this.transmit(new AMQCommand(new AMQP.Basic.Publish.Builder().exchange(string).routingKey(string2).mandatory(bl2).immediate(bl3).build(), basicProperties2, byArray));
        this.metricsCollector.basicPublish(this);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, String string2, boolean bl2, boolean bl3, Map<String, Object> map) throws IOException {
        return this.exchangeDeclare(string, string2, bl2, bl3, false, (Map)map);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType, boolean bl2, boolean bl3, Map<String, Object> map) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType(), bl2, bl3, (Map)map);
    }

    @Override
    public void exchangeDeclareNoWait(String string, String string2, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        this.transmit(new AMQCommand(new AMQP.Exchange.Declare.Builder().exchange(string).type(string2).durable(bl2).autoDelete(bl3).internal(bl4).arguments(map).passive(false).nowait(true).build()));
    }

    @Override
    public void exchangeDeclareNoWait(String string, BuiltinExchangeType builtinExchangeType, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        this.exchangeDeclareNoWait(string, builtinExchangeType.getType(), bl2, bl3, bl4, map);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, String string2, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQP.Exchange.Declare.Builder().exchange(string).type(string2).durable(bl2).autoDelete(bl3).internal(bl4).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType(), bl2, bl3, bl4, (Map)map);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, String string2, boolean bl2) throws IOException {
        return this.exchangeDeclare(string, string2, bl2, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType, boolean bl2) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType(), bl2);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, String string2) throws IOException {
        return this.exchangeDeclare(string, string2, false, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType());
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclarePassive(String string) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQP.Exchange.Declare.Builder().exchange(string).type(UNSPECIFIED_OUT_OF_BAND).passive().build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String string, boolean bl2) throws IOException {
        return (AMQImpl.Exchange.DeleteOk)this.exnWrappingRpc(new AMQP.Exchange.Delete.Builder().exchange(string).ifUnused(bl2).build()).getMethod();
    }

    @Override
    public void exchangeDeleteNoWait(String string, boolean bl2) throws IOException {
        this.transmit(new AMQCommand(new AMQP.Exchange.Delete.Builder().exchange(string).ifUnused(bl2).nowait(true).build()));
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String string) throws IOException {
        return this.exchangeDelete(string, false);
    }

    @Override
    public AMQImpl.Exchange.BindOk exchangeBind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        return (AMQImpl.Exchange.BindOk)this.exnWrappingRpc(new AMQP.Exchange.Bind.Builder().destination(string).source(string2).routingKey(string3).arguments(map).build()).getMethod();
    }

    @Override
    public void exchangeBindNoWait(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        this.transmit(new AMQCommand(new AMQP.Exchange.Bind.Builder().destination(string).source(string2).routingKey(string3).arguments(map).nowait(true).build()));
    }

    @Override
    public AMQImpl.Exchange.BindOk exchangeBind(String string, String string2, String string3) throws IOException {
        return this.exchangeBind(string, string2, string3, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.UnbindOk exchangeUnbind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        return (AMQImpl.Exchange.UnbindOk)this.exnWrappingRpc(new AMQP.Exchange.Unbind.Builder().destination(string).source(string2).routingKey(string3).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.UnbindOk exchangeUnbind(String string, String string2, String string3) throws IOException {
        return this.exchangeUnbind(string, string2, string3, (Map)null);
    }

    @Override
    public void exchangeUnbindNoWait(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        this.transmit(new AMQCommand(new AMQP.Exchange.Unbind.Builder().destination(string).source(string2).routingKey(string3).arguments(map).nowait(true).build()));
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclare(String string, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        ChannelN.validateQueueNameLength(string);
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQP.Queue.Declare.Builder().queue(string).durable(bl2).exclusive(bl3).autoDelete(bl4).arguments(map).build()).getMethod();
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.queueDeclare(UNSPECIFIED_OUT_OF_BAND, false, true, true, (Map)null);
    }

    @Override
    public void queueDeclareNoWait(String string, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        ChannelN.validateQueueNameLength(string);
        this.transmit(new AMQCommand(new AMQP.Queue.Declare.Builder().queue(string).durable(bl2).exclusive(bl3).autoDelete(bl4).arguments(map).passive(false).nowait(true).build()));
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclarePassive(String string) throws IOException {
        ChannelN.validateQueueNameLength(string);
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQP.Queue.Declare.Builder().queue(string).passive().exclusive().autoDelete().build()).getMethod();
    }

    @Override
    public long messageCount(String string) throws IOException {
        AMQImpl.Queue.DeclareOk declareOk = this.queueDeclarePassive(string);
        return declareOk.getMessageCount();
    }

    @Override
    public long consumerCount(String string) throws IOException {
        AMQImpl.Queue.DeclareOk declareOk = this.queueDeclarePassive(string);
        return declareOk.getConsumerCount();
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String string, boolean bl2, boolean bl3) throws IOException {
        ChannelN.validateQueueNameLength(string);
        return (AMQImpl.Queue.DeleteOk)this.exnWrappingRpc(new AMQP.Queue.Delete.Builder().queue(string).ifUnused(bl2).ifEmpty(bl3).build()).getMethod();
    }

    @Override
    public void queueDeleteNoWait(String string, boolean bl2, boolean bl3) throws IOException {
        ChannelN.validateQueueNameLength(string);
        this.transmit(new AMQCommand(new AMQP.Queue.Delete.Builder().queue(string).ifUnused(bl2).ifEmpty(bl3).nowait(true).build()));
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String string) throws IOException {
        return this.queueDelete(string, false, false);
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        ChannelN.validateQueueNameLength(string);
        return (AMQImpl.Queue.BindOk)this.exnWrappingRpc(new AMQP.Queue.Bind.Builder().queue(string).exchange(string2).routingKey(string3).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String string, String string2, String string3) throws IOException {
        return this.queueBind(string, string2, string3, (Map)null);
    }

    @Override
    public void queueBindNoWait(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        ChannelN.validateQueueNameLength(string);
        this.transmit(new AMQCommand(new AMQP.Queue.Bind.Builder().queue(string).exchange(string2).routingKey(string3).arguments(map).nowait(true).build()));
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        ChannelN.validateQueueNameLength(string);
        return (AMQImpl.Queue.UnbindOk)this.exnWrappingRpc(new AMQP.Queue.Unbind.Builder().queue(string).exchange(string2).routingKey(string3).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.PurgeOk queuePurge(String string) throws IOException {
        ChannelN.validateQueueNameLength(string);
        return (AMQImpl.Queue.PurgeOk)this.exnWrappingRpc(new AMQP.Queue.Purge.Builder().queue(string).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String string, String string2, String string3) throws IOException {
        return this.queueUnbind(string, string2, string3, (Map)null);
    }

    @Override
    public GetResponse basicGet(String string, boolean bl2) throws IOException {
        ChannelN.validateQueueNameLength(string);
        AMQCommand aMQCommand = this.exnWrappingRpc(new AMQP.Basic.Get.Builder().queue(string).noAck(bl2).build());
        Method method = aMQCommand.getMethod();
        if (method instanceof AMQImpl.Basic.GetOk) {
            AMQImpl.Basic.GetOk getOk = (AMQImpl.Basic.GetOk)method;
            Envelope envelope = new Envelope(getOk.getDeliveryTag(), getOk.getRedelivered(), getOk.getExchange(), getOk.getRoutingKey());
            AMQP.BasicProperties basicProperties = (AMQP.BasicProperties)aMQCommand.getContentHeader();
            byte[] byArray = aMQCommand.getContentBody();
            int n2 = getOk.getMessageCount();
            this.metricsCollector.consumedMessage((Channel)this, getOk.getDeliveryTag(), bl2);
            return new GetResponse(envelope, basicProperties, byArray, n2);
        }
        if (method instanceof AMQImpl.Basic.GetEmpty) {
            return null;
        }
        throw new UnexpectedMethodError(method);
    }

    @Override
    public void basicAck(long l2, boolean bl2) throws IOException {
        this.transmit(new AMQImpl.Basic.Ack(l2, bl2));
        this.metricsCollector.basicAck(this, l2, bl2);
    }

    @Override
    public void basicNack(long l2, boolean bl2, boolean bl3) throws IOException {
        this.transmit(new AMQImpl.Basic.Nack(l2, bl2, bl3));
        this.metricsCollector.basicNack(this, l2);
    }

    @Override
    public void basicReject(long l2, boolean bl2) throws IOException {
        this.transmit(new AMQImpl.Basic.Reject(l2, bl2));
        this.metricsCollector.basicReject(this, l2);
    }

    @Override
    public String basicConsume(String string, Consumer consumer) throws IOException {
        return this.basicConsume(string, false, consumer);
    }

    @Override
    public String basicConsume(String string, boolean bl2, Consumer consumer) throws IOException {
        return this.basicConsume(string, bl2, UNSPECIFIED_OUT_OF_BAND, consumer);
    }

    @Override
    public String basicConsume(String string, boolean bl2, Map<String, Object> map, Consumer consumer) throws IOException {
        return this.basicConsume(string, bl2, UNSPECIFIED_OUT_OF_BAND, false, false, map, consumer);
    }

    @Override
    public String basicConsume(String string, boolean bl2, String string2, Consumer consumer) throws IOException {
        return this.basicConsume(string, bl2, string2, false, false, null, consumer);
    }

    @Override
    public String basicConsume(String string, final boolean bl2, String string2, boolean bl3, boolean bl4, Map<String, Object> map, final Consumer consumer) throws IOException {
        AMQP.Basic.Consume consume = new AMQP.Basic.Consume.Builder().queue(string).consumerTag(string2).noLocal(bl3).noAck(bl2).exclusive(bl4).arguments(map).build();
        AMQChannel.BlockingRpcContinuation<String> blockingRpcContinuation = new AMQChannel.BlockingRpcContinuation<String>((com.contrastsecurity.thirdparty.com.rabbitmq.client.Method)consume){

            @Override
            public String transformReply(AMQCommand aMQCommand) {
                String string = ((AMQImpl.Basic.ConsumeOk)aMQCommand.getMethod()).getConsumerTag();
                ChannelN.this._consumers.put(string, consumer);
                ChannelN.this.metricsCollector.basicConsume(ChannelN.this, string, bl2);
                ChannelN.this.dispatcher.handleConsumeOk(consumer, string);
                return string;
            }
        };
        this.rpc((com.contrastsecurity.thirdparty.com.rabbitmq.client.Method)consume, blockingRpcContinuation);
        try {
            if (this._rpcTimeout == 0) {
                return (String)blockingRpcContinuation.getReply();
            }
            try {
                return (String)blockingRpcContinuation.getReply(this._rpcTimeout);
            }
            catch (TimeoutException timeoutException) {
                throw this.wrapTimeoutException(consume, timeoutException);
            }
        }
        catch (ShutdownSignalException shutdownSignalException) {
            throw ChannelN.wrap(shutdownSignalException);
        }
    }

    @Override
    public void basicCancel(final String string) throws IOException {
        block6: {
            final Consumer consumer = this._consumers.get(string);
            if (consumer == null) {
                throw new IOException("Unknown consumerTag");
            }
            AMQImpl.Basic.Cancel cancel = new AMQImpl.Basic.Cancel(string, false);
            AMQChannel.BlockingRpcContinuation<Consumer> blockingRpcContinuation = new AMQChannel.BlockingRpcContinuation<Consumer>((com.contrastsecurity.thirdparty.com.rabbitmq.client.Method)cancel){

                @Override
                public Consumer transformReply(AMQCommand aMQCommand) {
                    if (!(aMQCommand.getMethod() instanceof AMQImpl.Basic.CancelOk)) {
                        LOGGER.warn("Received reply {} was not of expected method Basic.CancelOk", (Object)aMQCommand.getMethod());
                    }
                    ChannelN.this._consumers.remove(string);
                    ChannelN.this.dispatcher.handleCancelOk(consumer, string);
                    return consumer;
                }
            };
            this.rpc((com.contrastsecurity.thirdparty.com.rabbitmq.client.Method)cancel, blockingRpcContinuation);
            try {
                if (this._rpcTimeout == 0) {
                    blockingRpcContinuation.getReply();
                    break block6;
                }
                try {
                    blockingRpcContinuation.getReply(this._rpcTimeout);
                }
                catch (TimeoutException timeoutException) {
                    throw this.wrapTimeoutException(cancel, timeoutException);
                }
            }
            catch (ShutdownSignalException shutdownSignalException) {
                throw ChannelN.wrap(shutdownSignalException);
            }
        }
        this.metricsCollector.basicCancel(this, string);
    }

    @Override
    public AMQImpl.Basic.RecoverOk basicRecover() throws IOException {
        return this.basicRecover(true);
    }

    @Override
    public AMQImpl.Basic.RecoverOk basicRecover(boolean bl2) throws IOException {
        return (AMQImpl.Basic.RecoverOk)this.exnWrappingRpc(new AMQImpl.Basic.Recover(bl2)).getMethod();
    }

    @Override
    public AMQImpl.Tx.SelectOk txSelect() throws IOException {
        return (AMQImpl.Tx.SelectOk)this.exnWrappingRpc(new AMQImpl.Tx.Select()).getMethod();
    }

    @Override
    public AMQImpl.Tx.CommitOk txCommit() throws IOException {
        return (AMQImpl.Tx.CommitOk)this.exnWrappingRpc(new AMQImpl.Tx.Commit()).getMethod();
    }

    @Override
    public AMQImpl.Tx.RollbackOk txRollback() throws IOException {
        return (AMQImpl.Tx.RollbackOk)this.exnWrappingRpc(new AMQImpl.Tx.Rollback()).getMethod();
    }

    @Override
    public AMQImpl.Confirm.SelectOk confirmSelect() throws IOException {
        if (this.nextPublishSeqNo == 0L) {
            this.nextPublishSeqNo = 1L;
        }
        return (AMQImpl.Confirm.SelectOk)this.exnWrappingRpc(new AMQImpl.Confirm.Select(false)).getMethod();
    }

    @Override
    @Deprecated
    public boolean flowBlocked() {
        return this._blockContent;
    }

    @Override
    public long getNextPublishSeqNo() {
        return this.nextPublishSeqNo;
    }

    @Override
    public void asyncRpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) throws IOException {
        this.transmit(method);
    }

    @Override
    public AMQCommand rpc(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) throws IOException {
        return this.exnWrappingRpc(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueRpc(AMQChannel.RpcContinuation rpcContinuation) {
        Object object = this._channelMutex;
        synchronized (object) {
            super.enqueueRpc(rpcContinuation);
            this.dispatcher.setUnlimited(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void markRpcFinished() {
        Object object = this._channelMutex;
        synchronized (object) {
            this.dispatcher.setUnlimited(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAckNack(long l2, boolean bl2, boolean bl3) {
        if (bl2) {
            this.unconfirmedSet.headSet(l2 + 1L).clear();
        } else {
            this.unconfirmedSet.remove(l2);
        }
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            boolean bl4 = this.onlyAcksReceived = this.onlyAcksReceived && !bl3;
            if (this.unconfirmedSet.isEmpty()) {
                this.unconfirmedSet.notifyAll();
            }
        }
    }

    private static void validateQueueNameLength(String string) {
        if (string.length() > 255) {
            throw new IllegalArgumentException("queue name must be no more than 255 characters long");
        }
    }
}

