/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.agent.commons.Throwables;
import java.util.concurrent.ThreadFactory;

public class Environment {
    public static boolean isAllowedToModifyThreads() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("modifyThread"));
                securityManager.checkPermission(new RuntimePermission("modifyThreadGroup"));
            }
            return true;
        }
        catch (SecurityException securityException) {
            Throwables.throwIfCritical(securityException);
            SecurityException securityException2 = securityException;
            return false;
        }
    }

    public static Thread newThread(ThreadFactory threadFactory, Runnable runnable, String string) {
        Thread thread = threadFactory.newThread(runnable);
        if (Environment.isAllowedToModifyThreads()) {
            thread.setName(string);
        }
        return thread;
    }

    public static Thread newThread(ThreadFactory threadFactory, Runnable runnable, String string, boolean bl2) {
        Thread thread = Environment.newThread(threadFactory, runnable, string);
        if (Environment.isAllowedToModifyThreads()) {
            thread.setDaemon(bl2);
        }
        return thread;
    }
}

