/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandler;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class HeartbeatSender {
    private final Object monitor = new Object();
    private final FrameHandler frameHandler;
    private final ThreadFactory threadFactory;
    private ScheduledExecutorService executor;
    private final boolean privateExecutor;
    private ScheduledFuture<?> future;
    private boolean shutdown = false;
    private volatile long lastActivityTime;

    HeartbeatSender(FrameHandler frameHandler, ScheduledExecutorService scheduledExecutorService, ThreadFactory threadFactory) {
        this.frameHandler = frameHandler;
        this.privateExecutor = scheduledExecutorService == null;
        this.executor = scheduledExecutorService;
        this.threadFactory = threadFactory;
    }

    public void signalActivity() {
        this.lastActivityTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeartbeat(int n2) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            if (n2 > 0) {
                long l2 = TimeUnit.SECONDS.toNanos(n2) / 2L;
                ScheduledExecutorService scheduledExecutorService = this.createExecutorIfNecessary();
                HeartbeatRunnable heartbeatRunnable = new HeartbeatRunnable(l2);
                this.future = scheduledExecutorService.scheduleAtFixedRate(heartbeatRunnable, l2, l2, TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService createExecutorIfNecessary() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            }
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ScheduledExecutorService scheduledExecutorService = null;
        Object object = this.monitor;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            if (this.privateExecutor) {
                scheduledExecutorService = this.executor;
            }
            this.executor = null;
            this.shutdown = true;
        }
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdown();
        }
    }

    private final class HeartbeatRunnable
    implements Runnable {
        private final long heartbeatNanos;

        private HeartbeatRunnable(long l2) {
            this.heartbeatNanos = l2;
        }

        @Override
        public void run() {
            try {
                long l2 = System.nanoTime();
                if (l2 > HeartbeatSender.this.lastActivityTime + this.heartbeatNanos) {
                    HeartbeatSender.this.frameHandler.writeFrame(new Frame(8, 0));
                    HeartbeatSender.this.frameHandler.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

