/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreaker;
import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreakerConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.DelayablePolicyBuilder;
import com.contrastsecurity.thirdparty.dev.failsafe.PolicyListeners;
import com.contrastsecurity.thirdparty.dev.failsafe.event.CircuitBreakerStateChangedEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.event.EventListener;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitBreakerImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Assert;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Durations;
import java.time.Duration;

public class CircuitBreakerBuilder<R>
extends DelayablePolicyBuilder<CircuitBreakerBuilder<R>, CircuitBreakerConfig<R>, R>
implements PolicyListeners<CircuitBreakerBuilder<R>, R> {
    CircuitBreakerBuilder() {
        super(new CircuitBreakerConfig());
        ((CircuitBreakerConfig)this.config).delay = Duration.ofMinutes(1L);
        ((CircuitBreakerConfig)this.config).failureThreshold = 1;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = 1;
    }

    CircuitBreakerBuilder(CircuitBreakerConfig<R> circuitBreakerConfig) {
        super(new CircuitBreakerConfig<R>(circuitBreakerConfig));
    }

    public CircuitBreaker<R> build() {
        return new CircuitBreakerImpl(new CircuitBreakerConfig((CircuitBreakerConfig)this.config));
    }

    public CircuitBreakerBuilder<R> onClose(EventListener<CircuitBreakerStateChangedEvent> eventListener) {
        ((CircuitBreakerConfig)this.config).closeListener = Assert.notNull(eventListener, "runnable");
        return this;
    }

    public CircuitBreakerBuilder<R> onHalfOpen(EventListener<CircuitBreakerStateChangedEvent> eventListener) {
        ((CircuitBreakerConfig)this.config).halfOpenListener = Assert.notNull(eventListener, "runnable");
        return this;
    }

    public CircuitBreakerBuilder<R> onOpen(EventListener<CircuitBreakerStateChangedEvent> eventListener) {
        ((CircuitBreakerConfig)this.config).openListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    @Override
    public CircuitBreakerBuilder<R> withDelay(Duration duration) {
        Assert.notNull(duration, "delay");
        duration = Durations.ofSafeNanos(duration);
        Assert.isTrue(duration.toNanos() >= 0L, "delay must be >= 0", new Object[0]);
        ((CircuitBreakerConfig)this.config).delay = duration;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int n2) {
        return this.withFailureThreshold(n2, n2);
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int n2, int n3) {
        Assert.isTrue(n2 >= 1, "failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(n3 >= 1, "failureThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(n3 >= n2, "failureThresholdingCapacity must be >= failureThreshold", new Object[0]);
        ((CircuitBreakerConfig)this.config).failureThreshold = n2;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = n3;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int n2, Duration duration) {
        return this.withFailureThreshold(n2, n2, duration);
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int n2, int n3, Duration duration) {
        Assert.isTrue(n2 >= 1, "failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(n3 >= n2, "failureExecutionThreshold must be >= failureThreshold", new Object[0]);
        this.assertFailureExecutionThreshold(n3);
        this.assertFailureThresholdingPeriod(duration);
        ((CircuitBreakerConfig)this.config).failureThreshold = n2;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = n2;
        ((CircuitBreakerConfig)this.config).failureExecutionThreshold = n3;
        ((CircuitBreakerConfig)this.config).failureThresholdingPeriod = duration;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureRateThreshold(int n2, int n3, Duration duration) {
        Assert.isTrue(n2 >= 1 && n2 <= 100, "failureRateThreshold must be between 1 and 100", new Object[0]);
        this.assertFailureExecutionThreshold(n3);
        this.assertFailureThresholdingPeriod(duration);
        ((CircuitBreakerConfig)this.config).failureRateThreshold = n2;
        ((CircuitBreakerConfig)this.config).failureExecutionThreshold = n3;
        ((CircuitBreakerConfig)this.config).failureThresholdingPeriod = duration;
        return this;
    }

    private void assertFailureExecutionThreshold(int n2) {
        Assert.isTrue(n2 >= 1, "failureExecutionThreshold must be >= 1", new Object[0]);
    }

    private void assertFailureThresholdingPeriod(Duration duration) {
        Assert.notNull(duration, "failureThresholdingPeriod");
        Assert.isTrue(duration.toMillis() >= 10L, "failureThresholdingPeriod must be >= 10 ms", new Object[0]);
    }

    public CircuitBreakerBuilder<R> withSuccessThreshold(int n2) {
        return this.withSuccessThreshold(n2, n2);
    }

    public CircuitBreakerBuilder<R> withSuccessThreshold(int n2, int n3) {
        Assert.isTrue(n2 >= 1, "successThreshold must be >= 1", new Object[0]);
        Assert.isTrue(n3 >= 1, "successThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(n3 >= n2, "successThresholdingCapacity must be >= successThreshold", new Object[0]);
        ((CircuitBreakerConfig)this.config).successThreshold = n2;
        ((CircuitBreakerConfig)this.config).successThresholdingCapacity = n3;
        return this;
    }
}

