/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.Automaton;
import com.contrastsecurity.thirdparty.dk.brics.automaton.BasicAutomata;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Datatypes;
import com.contrastsecurity.thirdparty.dk.brics.automaton.State;
import com.contrastsecurity.thirdparty.dk.brics.automaton.StatePair;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Transition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class SpecialOperations {
    private SpecialOperations() {
    }

    public static Set<State> reverse(Automaton automaton) {
        HashMap hashMap = new HashMap();
        Set<State> set = automaton.getStates();
        Set<State> set2 = automaton.getAcceptStates();
        for (State state : set) {
            hashMap.put(state, new HashSet());
            state.accept = false;
        }
        for (State state : set) {
            for (Transition transition : state.getTransitions()) {
                ((HashSet)hashMap.get(transition.to)).add(new Transition(transition.min, transition.max, state));
            }
        }
        for (State state : set) {
            state.transitions = (Set)hashMap.get(state);
        }
        automaton.initial.accept = true;
        automaton.initial = new State();
        for (State state : set2) {
            automaton.initial.addEpsilon(state);
        }
        automaton.deterministic = false;
        return set2;
    }

    public static Automaton overlap(Automaton automaton, Automaton automaton2) {
        Automaton automaton3 = automaton.cloneExpanded();
        automaton3.determinize();
        SpecialOperations.acceptToAccept(automaton3);
        Automaton automaton4 = automaton2.cloneExpanded();
        SpecialOperations.reverse(automaton4);
        automaton4.determinize();
        SpecialOperations.acceptToAccept(automaton4);
        SpecialOperations.reverse(automaton4);
        automaton4.determinize();
        return automaton3.intersection(automaton4).minus(BasicAutomata.makeEmptyString());
    }

    private static void acceptToAccept(Automaton automaton) {
        State state = new State();
        for (State state2 : automaton.getAcceptStates()) {
            state.addEpsilon(state2);
        }
        automaton.initial = state;
        automaton.deterministic = false;
    }

    public static Automaton singleChars(Automaton automaton) {
        State state;
        Automaton automaton2 = new Automaton();
        automaton2.initial = state = new State();
        State state2 = new State();
        state2.accept = true;
        if (automaton.isSingleton()) {
            for (int i2 = 0; i2 < automaton.singleton.length(); ++i2) {
                state.transitions.add(new Transition(automaton.singleton.charAt(i2), state2));
            }
        } else {
            for (State state3 : automaton.getStates()) {
                for (Transition transition : state3.transitions) {
                    state.transitions.add(new Transition(transition.min, transition.max, state2));
                }
            }
        }
        automaton2.deterministic = true;
        automaton2.removeDeadTransitions();
        return automaton2;
    }

    public static Automaton trim(Automaton automaton, String string, char c2) {
        automaton = automaton.cloneExpandedIfRequired();
        State state = new State();
        SpecialOperations.addSetTransitions(state, string, state);
        state.accept = true;
        for (State state2 : automaton.getStates()) {
            State state3 = state2.step(c2);
            if (state3 != null) {
                State state4 = new State();
                SpecialOperations.addSetTransitions(state4, string, state4);
                SpecialOperations.addSetTransitions(state2, string, state4);
                state4.addEpsilon(state3);
            }
            if (!state2.accept) continue;
            state2.addEpsilon(state);
        }
        State state5 = new State();
        SpecialOperations.addSetTransitions(state5, string, state5);
        state5.addEpsilon(automaton.initial);
        automaton.initial = state5;
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    private static void addSetTransitions(State state, String string, State state2) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            state.transitions.add(new Transition(string.charAt(i2), state2));
        }
    }

    public static Automaton compress(Automaton automaton, String string, char c2) {
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            State state2 = state.step(c2);
            if (state2 == null) continue;
            State state3 = new State();
            SpecialOperations.addSetTransitions(state3, string, state3);
            SpecialOperations.addSetTransitions(state, string, state3);
            state3.addEpsilon(state2);
        }
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton subst(Automaton automaton, Map<Character, Set<Character>> map) {
        if (map.isEmpty()) {
            return automaton.cloneIfRequired();
        }
        TreeSet<Character> treeSet = new TreeSet<Character>(map.keySet());
        char[] cArray = new char[treeSet.size()];
        int n2 = 0;
        for (Character comparable : treeSet) {
            cArray[n2++] = comparable.charValue();
        }
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            Set<Transition> set = state.transitions;
            state.resetTransitions();
            block2: for (Transition transition : set) {
                int n3 = SpecialOperations.findIndex(transition.min, cArray);
                while (transition.min <= transition.max) {
                    if (cArray[n3] > transition.min) {
                        char c2 = (char)(cArray[n3] - '\u0001');
                        if (transition.max < c2) {
                            c2 = transition.max;
                        }
                        state.transitions.add(new Transition(transition.min, c2, transition.to));
                        if (c2 + '\u0001' > 65535) continue block2;
                        transition.min = (char)(c2 + '\u0001');
                        continue;
                    }
                    if (cArray[n3] < transition.min) {
                        char c3 = n3 + 1 < cArray.length ? (char)(cArray[++n3] - '\u0001') : (char)'\uffff';
                        if (transition.max < c3) {
                            c3 = transition.max;
                        }
                        state.transitions.add(new Transition(transition.min, c3, transition.to));
                        if (c3 + '\u0001' > 65535) continue block2;
                        transition.min = (char)(c3 + '\u0001');
                        continue;
                    }
                    for (Character c4 : map.get(Character.valueOf(transition.min))) {
                        state.transitions.add(new Transition(c4.charValue(), transition.to));
                    }
                    if (transition.min + '\u0001' > 65535) continue block2;
                    transition.min = (char)(transition.min + '\u0001');
                    if (n3 + 1 >= cArray.length || cArray[n3 + 1] != transition.min) continue;
                    ++n3;
                }
            }
        }
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    static int findIndex(char c2, char[] cArray) {
        int n2 = 0;
        int n3 = cArray.length;
        while (n3 - n2 > 1) {
            int n4 = n2 + n3 >>> 1;
            if (cArray[n4] > c2) {
                n3 = n4;
                continue;
            }
            if (cArray[n4] < c2) {
                n2 = n4;
                continue;
            }
            return n4;
        }
        return n2;
    }

    public static Automaton subst(Automaton automaton, char c2, String string) {
        automaton = automaton.cloneExpandedIfRequired();
        HashSet<StatePair> hashSet = new HashSet<StatePair>();
        for (State state : automaton.getStates()) {
            Set<Transition> set = state.transitions;
            state.resetTransitions();
            for (Transition transition : set) {
                if (transition.max < c2 || transition.min > c2) {
                    state.transitions.add(transition);
                    continue;
                }
                if (transition.min < c2) {
                    state.transitions.add(new Transition(transition.min, (char)(c2 - '\u0001'), transition.to));
                }
                if (transition.max > c2) {
                    state.transitions.add(new Transition((char)(c2 + '\u0001'), transition.max, transition.to));
                }
                if (string.length() == 0) {
                    hashSet.add(new StatePair(state, transition.to));
                    continue;
                }
                State state2 = state;
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    State state3 = i2 + 1 == string.length() ? transition.to : new State();
                    state2.transitions.add(new Transition(string.charAt(i2), state3));
                    state2 = state3;
                }
            }
        }
        automaton.addEpsilons(hashSet);
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton homomorph(Automaton automaton, char[] cArray, char[] cArray2) {
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            Set<Transition> set = state.transitions;
            state.resetTransitions();
            for (Transition transition : set) {
                int n2;
                for (int i2 = transition.min; i2 <= transition.max; i2 += n2) {
                    int n3 = SpecialOperations.findIndex((char)i2, cArray);
                    char c2 = (char)(cArray2[n3] + i2 - cArray[n3]);
                    int n4 = n3 + 1 == cArray.length ? 65535 : cArray[n3 + 1] - '\u0001';
                    n2 = n4 < transition.max ? n4 + 1 - i2 : transition.max + '\u0001' - i2;
                    state.transitions.add(new Transition(c2, (char)(c2 + n2 - 1), transition.to));
                }
            }
        }
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton projectChars(Automaton automaton, Set<Character> set) {
        int n2;
        Character[] characterArray = set.toArray(new Character[set.size()]);
        char[] cArray = new char[characterArray.length];
        boolean bl2 = false;
        for (n2 = 0; n2 < characterArray.length; ++n2) {
            if (characterArray[n2] == null) {
                bl2 = true;
                continue;
            }
            cArray[n2] = characterArray[n2].charValue();
        }
        Arrays.sort(cArray);
        if (automaton.isSingleton()) {
            for (n2 = 0; n2 < automaton.singleton.length(); ++n2) {
                char c2 = automaton.singleton.charAt(n2);
                if (bl2 && (c2 <= '\udfff' || c2 >= '\uf900') || Arrays.binarySearch(cArray, c2) >= 0) continue;
                return BasicAutomata.makeEmpty();
            }
            return automaton.cloneIfRequired();
        }
        HashSet<StatePair> hashSet = new HashSet<StatePair>();
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            HashSet<Transition> hashSet2 = new HashSet<Transition>();
            for (Transition transition : state.transitions) {
                boolean bl3 = false;
                if (transition.min < '\uf900' && transition.max > '\udfff') {
                    int n3;
                    int n4 = Arrays.binarySearch(cArray, transition.min > '\ue000' ? (char)transition.min : (char)'\ue000');
                    if (n4 < 0) {
                        n4 = -n4 - 1;
                        bl3 = true;
                    }
                    if ((n3 = Arrays.binarySearch(cArray, transition.max < '\uf8ff' ? (char)transition.max : (char)'\uf8ff')) < 0) {
                        n3 = -n3 - 2;
                        bl3 = true;
                    }
                    for (int i2 = n4; i2 <= n3; ++i2) {
                        hashSet2.add(new Transition(cArray[i2], transition.to));
                        if (i2 <= n4 || cArray[i2 - 1] + '\u0001' == cArray[i2]) continue;
                        bl3 = true;
                    }
                }
                if (bl2) {
                    if (transition.min <= '\udfff') {
                        hashSet2.add(new Transition(transition.min, transition.max < '\udfff' ? (char)transition.max : (char)'\udfff', transition.to));
                    }
                    if (transition.max >= '\uf900') {
                        hashSet2.add(new Transition(transition.min > '\uf900' ? (char)transition.min : (char)'\uf900', transition.max, transition.to));
                    }
                } else if (transition.min <= '\udfff' || transition.max >= '\uf900') {
                    bl3 = true;
                }
                if (!bl3) continue;
                hashSet.add(new StatePair(state, transition.to));
            }
            state.transitions = hashSet2;
        }
        automaton.reduce();
        automaton.addEpsilons(hashSet);
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static boolean isFinite(Automaton automaton) {
        if (automaton.isSingleton()) {
            return true;
        }
        return SpecialOperations.isFinite(automaton.initial, new HashSet<State>(), new HashSet<State>());
    }

    private static boolean isFinite(State state, HashSet<State> hashSet, HashSet<State> hashSet2) {
        hashSet.add(state);
        for (Transition transition : state.transitions) {
            if (!hashSet.contains(transition.to) && (hashSet2.contains(transition.to) || SpecialOperations.isFinite(transition.to, hashSet, hashSet2))) continue;
            return false;
        }
        hashSet.remove(state);
        hashSet2.add(state);
        return true;
    }

    public static Set<String> getStrings(Automaton automaton, int n2) {
        HashSet<String> hashSet = new HashSet<String>();
        if (automaton.isSingleton() && automaton.singleton.length() == n2) {
            hashSet.add(automaton.singleton);
        } else if (n2 >= 0) {
            SpecialOperations.getStrings(automaton.initial, hashSet, new StringBuilder(), n2);
        }
        return hashSet;
    }

    private static void getStrings(State state, Set<String> set, StringBuilder stringBuilder, int n2) {
        if (n2 == 0) {
            if (state.accept) {
                set.add(stringBuilder.toString());
            }
        } else {
            for (Transition transition : state.transitions) {
                for (int i2 = transition.min; i2 <= transition.max; ++i2) {
                    stringBuilder.append((char)i2);
                    SpecialOperations.getStrings(transition.to, set, stringBuilder, n2 - 1);
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
            }
        }
    }

    public static Set<String> getFiniteStrings(Automaton automaton) {
        HashSet<String> hashSet = new HashSet<String>();
        if (automaton.isSingleton()) {
            hashSet.add(automaton.singleton);
        } else if (!SpecialOperations.getFiniteStrings(automaton.initial, new HashSet<State>(), hashSet, new StringBuilder(), -1)) {
            return null;
        }
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getFiniteStrings(Automaton automaton, int n2) {
        HashSet<String> hashSet = new HashSet<String>();
        if (automaton.isSingleton()) {
            if (n2 <= 0) return null;
            hashSet.add(automaton.singleton);
            return hashSet;
        } else {
            if (SpecialOperations.getFiniteStrings(automaton.initial, new HashSet<State>(), hashSet, new StringBuilder(), n2)) return hashSet;
            return null;
        }
    }

    private static boolean getFiniteStrings(State state, HashSet<State> hashSet, HashSet<String> hashSet2, StringBuilder stringBuilder, int n2) {
        hashSet.add(state);
        for (Transition transition : state.transitions) {
            if (hashSet.contains(transition.to)) {
                return false;
            }
            for (int i2 = transition.min; i2 <= transition.max; ++i2) {
                stringBuilder.append((char)i2);
                if (transition.to.accept) {
                    hashSet2.add(stringBuilder.toString());
                    if (n2 >= 0 && hashSet2.size() > n2) {
                        return false;
                    }
                }
                if (!SpecialOperations.getFiniteStrings(transition.to, hashSet, hashSet2, stringBuilder, n2)) {
                    return false;
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        hashSet.remove(state);
        return true;
    }

    public static String getCommonPrefix(Automaton automaton) {
        boolean bl2;
        if (automaton.isSingleton()) {
            return automaton.singleton;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<State> hashSet = new HashSet<State>();
        State state = automaton.initial;
        do {
            bl2 = true;
            hashSet.add(state);
            if (state.accept || state.transitions.size() != 1) continue;
            Transition transition = state.transitions.iterator().next();
            if (transition.min != transition.max || hashSet.contains(transition.to)) continue;
            stringBuilder.append(transition.min);
            state = transition.to;
            bl2 = false;
        } while (!bl2);
        return stringBuilder.toString();
    }

    public static void prefixClose(Automaton automaton) {
        for (State state : automaton.getStates()) {
            state.setAccept(true);
        }
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
    }

    public static Automaton hexCases(Automaton automaton) {
        HashMap<Character, Set<Character>> hashMap = new HashMap<Character, Set<Character>>();
        char c2 = 'a';
        char c3 = 'A';
        while (c2 <= 'f') {
            HashSet<Character> hashSet = new HashSet<Character>();
            hashSet.add(Character.valueOf(c2));
            hashSet.add(Character.valueOf(c3));
            hashMap.put(Character.valueOf(c2), hashSet);
            hashMap.put(Character.valueOf(c3), hashSet);
            c2 = (char)(c2 + '\u0001');
            c3 = (char)(c3 + '\u0001');
        }
        Automaton automaton2 = Datatypes.getWhitespaceAutomaton();
        return automaton2.concatenate(automaton.subst(hashMap)).concatenate(automaton2);
    }

    public static Automaton replaceWhitespace(Automaton automaton) {
        HashMap<Character, Set<Character>> hashMap = new HashMap<Character, Set<Character>>();
        HashSet<Character> hashSet = new HashSet<Character>();
        hashSet.add(Character.valueOf(' '));
        hashSet.add(Character.valueOf('\t'));
        hashSet.add(Character.valueOf('\n'));
        hashSet.add(Character.valueOf('\r'));
        hashMap.put(Character.valueOf(' '), hashSet);
        return automaton.subst(hashMap);
    }
}

