/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton.extension;

import com.contrastsecurity.thirdparty.dk.brics.automaton.Automaton;
import com.contrastsecurity.thirdparty.dk.brics.automaton.BasicAutomata;
import com.contrastsecurity.thirdparty.dk.brics.automaton.MatchOnlyRunAutomaton;
import com.contrastsecurity.thirdparty.dk.brics.automaton.RegExp;
import com.contrastsecurity.thirdparty.dk.brics.automaton.SpecialOperations;
import com.contrastsecurity.thirdparty.dk.brics.automaton.State;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Transition;
import com.contrastsecurity.thirdparty.dk.brics.automaton.extension.PatternPreProcessor;
import com.contrastsecurity.thirdparty.dk.brics.automaton.extension.PatternWithFlags;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class DFARegexFactory {
    private static final int BRICS_ENABLED_FLAGS = 65408;

    private DFARegexFactory() {
    }

    public static MatchOnlyRunAutomaton compile(String string, EnumSet<DFAFlags> enumSet) {
        Objects.requireNonNull(string);
        DFAFlags.validate(Objects.requireNonNull(enumSet));
        PatternPreProcessor patternPreProcessor = new PatternPreProcessor();
        boolean bl2 = enumSet.contains((Object)DFAFlags.CASE_INSENSITIVE);
        boolean bl3 = enumSet.contains((Object)DFAFlags.USE_EXTENDED_WHITESPACE_CHARS);
        PatternWithFlags patternWithFlags = patternPreProcessor.process(string, bl2, bl3);
        Automaton automaton = DFARegexFactory.regExpToAutomaton(patternWithFlags.getPattern());
        int n2 = DFARegexFactory.dfaPerfFlagsConvert(enumSet);
        return new MatchOnlyRunAutomaton(automaton, n2, patternWithFlags.getFlags());
    }

    public static MatchOnlyRunAutomaton compileLiterals(CharSequence[] charSequenceArray, EnumSet<DFAFlags> enumSet) {
        Objects.requireNonNull(charSequenceArray);
        if (charSequenceArray.length == 0) {
            throw new IllegalArgumentException("Must provide at least 1 literal");
        }
        DFAFlags.validate(Objects.requireNonNull(enumSet));
        Automaton automaton = DFARegexFactory.makeLiteral(charSequenceArray, enumSet.contains((Object)DFAFlags.CASE_INSENSITIVE));
        int n2 = DFARegexFactory.dfaPerfFlagsConvert(enumSet);
        return new MatchOnlyRunAutomaton(automaton, n2);
    }

    public static Automaton compileLiteralsForTesting(CharSequence[] charSequenceArray, EnumSet<DFAFlags> enumSet) {
        Objects.requireNonNull(charSequenceArray);
        if (charSequenceArray.length == 0) {
            throw new IllegalArgumentException("Must provide at least 1 literal");
        }
        DFAFlags.validate(Objects.requireNonNull(enumSet));
        return DFARegexFactory.makeLiteral(charSequenceArray, enumSet.contains((Object)DFAFlags.CASE_INSENSITIVE));
    }

    public static Automaton compileForTesting(String string, EnumSet<DFAFlags> enumSet) {
        Objects.requireNonNull(string);
        DFAFlags.validate(Objects.requireNonNull(enumSet));
        PatternWithFlags patternWithFlags = new PatternPreProcessor().process(string, enumSet.contains((Object)DFAFlags.CASE_INSENSITIVE), enumSet.contains((Object)DFAFlags.USE_EXTENDED_WHITESPACE_CHARS));
        return DFARegexFactory.regExpToAutomaton(patternWithFlags.getPattern());
    }

    private static Automaton regExpToAutomaton(String string) {
        RegExp regExp = new RegExp(string, 65408);
        return regExp.toAutomaton();
    }

    private static Automaton makeLiteral(CharSequence[] charSequenceArray, boolean bl2) {
        Automaton automaton = BasicAutomata.makeStringUnion(charSequenceArray);
        return bl2 ? DFARegexFactory.makeLiteralCaseInsensitive(automaton) : automaton;
    }

    private static Automaton makeLiteralCaseInsensitive(Automaton automaton) {
        HashMap<Character, Set<Character>> hashMap = new HashMap<Character, Set<Character>>();
        Set<State> set = automaton.getStates();
        for (State state : set) {
            List<Transition> list = state.getSortedTransitions(true);
            for (Transition transition : list) {
                int n2;
                char c3 = transition.getMax();
                for (int i2 = n2 = transition.getMin(); i2 <= c3; ++i2) {
                    Set set2;
                    char c4 = (char)i2;
                    if (hashMap.containsKey(Character.valueOf(c4))) continue;
                    if (Character.isUpperCase(c4)) {
                        set2 = hashMap.computeIfAbsent(Character.valueOf(c4), c2 -> new HashSet());
                        set2.add(Character.valueOf(c4));
                        set2.add(Character.valueOf(Character.toLowerCase(c4)));
                        continue;
                    }
                    if (!Character.isLowerCase(c4)) continue;
                    set2 = hashMap.computeIfAbsent(Character.valueOf(c4), c2 -> new HashSet());
                    set2.add(Character.valueOf(Character.toUpperCase(c4)));
                    set2.add(Character.valueOf(c4));
                }
            }
        }
        return hashMap.isEmpty() ? automaton : SpecialOperations.subst(automaton, hashMap);
    }

    private static int dfaPerfFlagsConvert(EnumSet<DFAFlags> enumSet) {
        if (enumSet.contains((Object)DFAFlags.OPTIMISE_FOR_CPU)) {
            return 1;
        }
        if (enumSet.contains((Object)DFAFlags.OPTIMISE_FOR_BALANCE)) {
            return 3;
        }
        return 2;
    }

    public static enum DFAFlags {
        OPTIMISE_FOR_MEM,
        OPTIMISE_FOR_CPU,
        OPTIMISE_FOR_BALANCE,
        CASE_INSENSITIVE,
        USE_EXTENDED_WHITESPACE_CHARS;


        public static void validate(EnumSet<DFAFlags> enumSet) {
            if (enumSet == null) {
                return;
            }
            int n2 = 0;
            if (enumSet.contains((Object)OPTIMISE_FOR_CPU)) {
                ++n2;
            }
            if (enumSet.contains((Object)OPTIMISE_FOR_MEM)) {
                ++n2;
            }
            if (enumSet.contains((Object)OPTIMISE_FOR_BALANCE)) {
                ++n2;
            }
            if (n2 > 1) {
                throw new IllegalArgumentException("Cannot set multiple OPTIMISE_ flags, please choose only one");
            }
        }
    }
}

