/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.hystrix;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixCommandCompletionStream;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
public class MicrometerMetricsPublisherCommand
implements HystrixMetricsPublisherCommand {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(MicrometerMetricsPublisherCommand.class);
    private static final String NAME_HYSTRIX_CIRCUIT_BREAKER_OPEN = "hystrix.circuit.breaker.open";
    private static final String NAME_HYSTRIX_EXECUTION = "hystrix.execution";
    private static final String NAME_HYSTRIX_EXECUTION_TERMINAL_TOTAL = "hystrix.execution.terminal";
    private static final String NAME_HYSTRIX_LATENCY_EXECUTION = "hystrix.latency.execution";
    private static final String NAME_HYSTRIX_LATENCY_TOTAL = "hystrix.latency.total";
    private static final String NAME_HYSTRIX_CONCURRENT_EXECUTION_CURRENT = "hystrix.concurrent.execution.current";
    private static final String NAME_HYSTRIX_CONCURRENT_EXECUTION_ROLLING_MAX = "hystrix.concurrent.execution.rolling.max";
    private static final String DESCRIPTION_HYSTRIX_EXECUTION = "Execution results. See https://github.com/Netflix/Hystrix/wiki/Metrics-and-Monitoring#command-execution-event-types-comnetflixhystrixhystrixeventtype for type definitions";
    private static final String DESCRIPTION_HYSTRIX_EXECUTION_TERMINAL_TOTAL = "Sum of all terminal executions. Use this to derive percentages from hystrix.execution";
    private final MeterRegistry meterRegistry;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final Iterable<Tag> tags;
    private final HystrixCommandKey commandKey;
    private HystrixMetricsPublisherCommand metricsPublisherForCommand;

    public MicrometerMetricsPublisherCommand(MeterRegistry meterRegistry, HystrixCommandKey hystrixCommandKey, HystrixCommandGroupKey hystrixCommandGroupKey, HystrixCommandMetrics hystrixCommandMetrics, HystrixCircuitBreaker hystrixCircuitBreaker, HystrixMetricsPublisherCommand hystrixMetricsPublisherCommand) {
        this.meterRegistry = meterRegistry;
        this.metrics = hystrixCommandMetrics;
        this.circuitBreaker = hystrixCircuitBreaker;
        this.commandKey = hystrixCommandKey;
        this.metricsPublisherForCommand = hystrixMetricsPublisherCommand;
        this.tags = Tags.of("group", hystrixCommandGroupKey.name(), "key", hystrixCommandKey.name());
    }

    public void initialize() {
        this.metricsPublisherForCommand.initialize();
        Gauge.builder(NAME_HYSTRIX_CIRCUIT_BREAKER_OPEN, this.circuitBreaker, hystrixCircuitBreaker -> hystrixCircuitBreaker.isOpen() ? 1.0 : 0.0).tags(this.tags).register(this.meterRegistry);
        HashMap hashMap = new HashMap();
        Arrays.asList(HystrixEventType.values()).forEach(hystrixEventType -> hashMap.put(hystrixEventType, this.getCounter((HystrixEventType)hystrixEventType)));
        Counter counter = Counter.builder(NAME_HYSTRIX_EXECUTION_TERMINAL_TOTAL).description(DESCRIPTION_HYSTRIX_EXECUTION_TERMINAL_TOTAL).tags(Tags.concat(this.tags, new String[0])).register(this.meterRegistry);
        Timer timer = ((Timer.Builder)Timer.builder(NAME_HYSTRIX_LATENCY_EXECUTION).tags((Iterable)this.tags)).register(this.meterRegistry);
        Timer timer2 = ((Timer.Builder)Timer.builder(NAME_HYSTRIX_LATENCY_TOTAL).tags((Iterable)this.tags)).register(this.meterRegistry);
        HystrixCommandCompletionStream.getInstance((HystrixCommandKey)this.commandKey).observe().subscribe(hystrixCommandCompletion -> {
            long l2 = hystrixCommandCompletion.getTotalLatency();
            if (l2 >= 0L) {
                timer2.record(l2, TimeUnit.MILLISECONDS);
            } else if (l2 < -1L) {
                LOG.warn("received negative totalLatency, event not counted. This indicates a clock skew? {}", hystrixCommandCompletion);
            }
            long l3 = hystrixCommandCompletion.getExecutionLatency();
            if (l3 >= 0L) {
                timer.record(l3, TimeUnit.MILLISECONDS);
            } else if (l3 < -1L) {
                LOG.warn("received negative executionLatency, event not counted. This indicates a clock skew? {}", hystrixCommandCompletion);
            }
            for (HystrixEventType hystrixEventType : HystrixEventType.values()) {
                int n2 = hystrixCommandCompletion.getEventCounts().getCount(hystrixEventType);
                if (n2 <= 0) continue;
                ((Counter)hashMap.get(hystrixEventType)).increment(n2);
                if (!hystrixEventType.isTerminal()) continue;
                counter.increment(n2);
            }
        });
        Gauge.builder(NAME_HYSTRIX_CONCURRENT_EXECUTION_CURRENT, this.metrics, HystrixCommandMetrics::getCurrentConcurrentExecutionCount).tags(this.tags).register(this.meterRegistry);
        Gauge.builder(NAME_HYSTRIX_CONCURRENT_EXECUTION_ROLLING_MAX, this.metrics, HystrixCommandMetrics::getRollingMaxConcurrentExecutions).tags(this.tags).register(this.meterRegistry);
    }

    private Counter getCounter(HystrixEventType hystrixEventType) {
        return Counter.builder(NAME_HYSTRIX_EXECUTION).description(DESCRIPTION_HYSTRIX_EXECUTION).tags(Tags.concat(this.tags, "event", hystrixEventType.name().toLowerCase(), "terminal", Boolean.toString(hystrixEventType.isTerminal()))).register(this.meterRegistry);
    }
}

