/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jpa;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;

@NonNullApi
@NonNullFields
@Deprecated
public class HibernateQueryMetrics
implements MeterBinder {
    private static final String SESSION_FACTORY_TAG_NAME = "entityManagerFactory";
    private final Iterable<Tag> tags;
    private final SessionFactory sessionFactory;

    public static void monitor(MeterRegistry meterRegistry, SessionFactory sessionFactory, String string, String ... stringArray) {
        HibernateQueryMetrics.monitor(meterRegistry, sessionFactory, string, Tags.of(stringArray));
    }

    public static void monitor(MeterRegistry meterRegistry, SessionFactory sessionFactory, String string, Iterable<Tag> iterable) {
        new HibernateQueryMetrics(sessionFactory, string, iterable).bindTo(meterRegistry);
    }

    public HibernateQueryMetrics(SessionFactory sessionFactory, String string, Iterable<Tag> iterable) {
        this.tags = Tags.concat(iterable, SESSION_FACTORY_TAG_NAME, string);
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        if (this.sessionFactory instanceof SessionFactoryImplementor) {
            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)((SessionFactoryImplementor)this.sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
            MetricsEventHandler metricsEventHandler = new MetricsEventHandler(meterRegistry);
            eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{metricsEventHandler});
        }
    }

    class MetricsEventHandler
    implements PostLoadEventListener {
        private final MeterRegistry meterRegistry;

        MetricsEventHandler(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
        }

        public void onPostLoad(PostLoadEvent postLoadEvent) {
            this.registerQueryMetric((Statistics)postLoadEvent.getSession().getFactory().getStatistics());
        }

        void registerQueryMetric(Statistics statistics) {
            for (String string : statistics.getQueries()) {
                QueryStatistics queryStatistics = statistics.getQueryStatistics(string);
                FunctionCounter.builder("hibernate.query.cache.requests", queryStatistics, QueryStatistics::getCacheHitCount).tags(HibernateQueryMetrics.this.tags).tags("result", "hit", "query", string).description("Number of query cache hits").register(this.meterRegistry);
                FunctionCounter.builder("hibernate.query.cache.requests", queryStatistics, QueryStatistics::getCacheMissCount).tags(HibernateQueryMetrics.this.tags).tags("result", "miss", "query", string).description("Number of query cache misses").register(this.meterRegistry);
                FunctionCounter.builder("hibernate.query.cache.puts", queryStatistics, QueryStatistics::getCachePutCount).tags(HibernateQueryMetrics.this.tags).tags("query", string).description("Number of cache puts for a query").register(this.meterRegistry);
                FunctionTimer.builder("hibernate.query.execution.total", queryStatistics, QueryStatistics::getExecutionCount, QueryStatistics::getExecutionTotalTime, TimeUnit.MILLISECONDS).tags(HibernateQueryMetrics.this.tags).tags("query", string).description("Query executions").register(this.meterRegistry);
                TimeGauge.builder("hibernate.query.execution.max", queryStatistics, TimeUnit.MILLISECONDS, QueryStatistics::getExecutionMaxTime).tags(HibernateQueryMetrics.this.tags).tags("query", string).description("Query maximum execution time").register(this.meterRegistry);
                TimeGauge.builder("hibernate.query.execution.min", queryStatistics, TimeUnit.MILLISECONDS, QueryStatistics::getExecutionMinTime).tags(HibernateQueryMetrics.this.tags).tags("query", string).description("Query minimum execution time").register(this.meterRegistry);
                FunctionCounter.builder("hibernate.query.execution.rows", queryStatistics, QueryStatistics::getExecutionRowCount).tags(HibernateQueryMetrics.this.tags).tags("query", string).description("Number of rows processed for a query").register(this.meterRegistry);
            }
        }
    }
}

