/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.ipc.http;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.IOUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.ipc.http.HttpSender;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;

public class HttpUrlConnectionSender
implements HttpSender {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 10000;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final Proxy proxy;

    public HttpUrlConnectionSender(Duration duration, Duration duration2) {
        this(duration, duration2, null);
    }

    public HttpUrlConnectionSender(Duration duration, Duration duration2, Proxy proxy) {
        this.connectTimeoutMs = (int)duration.toMillis();
        this.readTimeoutMs = (int)duration2.toMillis();
        this.proxy = proxy;
    }

    public HttpUrlConnectionSender() {
        this.connectTimeoutMs = 1000;
        this.readTimeoutMs = 10000;
        this.proxy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpSender.Response send(HttpSender.Request request) throws IOException {
        HttpSender.Response response;
        HttpURLConnection httpURLConnection = null;
        try {
            void var5_11;
            int n2;
            block17: {
                block16: {
                    httpURLConnection = this.proxy != null ? (HttpURLConnection)request.getUrl().openConnection(this.proxy) : (HttpURLConnection)request.getUrl().openConnection();
                    httpURLConnection.setConnectTimeout(this.connectTimeoutMs);
                    httpURLConnection.setReadTimeout(this.readTimeoutMs);
                    HttpSender.Method method = request.getMethod();
                    httpURLConnection.setRequestMethod(method.name());
                    for (Map.Entry<String, String> entry : request.getRequestHeaders().entrySet()) {
                        httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                    if (method != HttpSender.Method.GET) {
                        httpURLConnection.setDoOutput(true);
                        OutputStream outputStream = httpURLConnection.getOutputStream();
                        try {
                            outputStream.write(request.getEntity());
                            outputStream.flush();
                            if (outputStream == null) break block16;
                        }
                        catch (Throwable throwable) {
                            Throwables.throwIfCritical(throwable);
                            Throwable throwable2 = throwable;
                            if (outputStream == null) throw throwable2;
                            try {
                                outputStream.close();
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                Throwables.throwIfCritical(throwable3);
                                Throwable throwable4 = throwable3;
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        outputStream.close();
                    }
                }
                n2 = httpURLConnection.getResponseCode();
                Object var5_8 = null;
                try {
                    if (httpURLConnection.getErrorStream() != null) {
                        String string = IOUtils.toString(httpURLConnection.getErrorStream());
                        break block17;
                    }
                    if (httpURLConnection.getInputStream() != null) {
                        String string = IOUtils.toString(httpURLConnection.getInputStream());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            response = new HttpSender.Response(n2, (String)var5_11);
        }
        catch (Throwable throwable) {
            try {
                if (httpURLConnection == null) throw throwable;
                httpURLConnection.disconnect();
                throw throwable;
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
            }
            throw throwable;
        }
        try {
            if (httpURLConnection == null) return response;
            httpURLConnection.disconnect();
            return response;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception3 = exception;
        }
        return response;
    }
}

