/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Contract;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringUtils {
    @Contract(value="null -> true")
    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String padLeft(String string, int n2) {
        return StringUtils.padStart(string, n2, '0');
    }

    private static String padStart(String string, int n2, char c2) {
        Objects.requireNonNull(string);
        if (string.length() >= n2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = string.length(); i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static boolean isPrintableString(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (StringUtils.isPrintableChar(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char c2) {
        return c2 >= ' ' && c2 <= '~';
    }

    private StringUtils() {
    }
}

