/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.logs;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.InstrumentationScopeMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.ResourceMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.logs.InstrumentationScopeLogsMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.logs.LogMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.logs.v1.internal.ResourceLogs;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.data.LogRecordData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceLogsMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrl;
    private final InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalers;

    public static ResourceLogsMarshaler[] create(Collection<LogRecordData> collection) {
        Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> map = ResourceLogsMarshaler.groupByResourceAndScope(collection);
        ResourceLogsMarshaler[] resourceLogsMarshalerArray = new ResourceLogsMarshaler[map.size()];
        int n2 = 0;
        for (Map.Entry<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> entry : map.entrySet()) {
            InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalerArray = new InstrumentationScopeLogsMarshaler[entry.getValue().size()];
            int n3 = 0;
            for (Map.Entry<InstrumentationScopeInfo, List<Marshaler>> entry2 : entry.getValue().entrySet()) {
                instrumentationScopeLogsMarshalerArray[n3++] = new InstrumentationScopeLogsMarshaler(InstrumentationScopeMarshaler.create(entry2.getKey()), MarshalerUtil.toBytes(entry2.getKey().getSchemaUrl()), entry2.getValue());
            }
            resourceLogsMarshalerArray[n2++] = new ResourceLogsMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationScopeLogsMarshalerArray);
        }
        return resourceLogsMarshalerArray;
    }

    ResourceLogsMarshaler(ResourceMarshaler resourceMarshaler, byte[] byArray, InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalerArray) {
        super(ResourceLogsMarshaler.calculateSize(resourceMarshaler, byArray, instrumentationScopeLogsMarshalerArray));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrl = byArray;
        this.instrumentationScopeLogsMarshalers = instrumentationScopeLogsMarshalerArray;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeMessage(ResourceLogs.RESOURCE, this.resourceMarshaler);
        serializer.serializeRepeatedMessage(ResourceLogs.SCOPE_LOGS, this.instrumentationScopeLogsMarshalers);
        serializer.serializeString(ResourceLogs.SCHEMA_URL, this.schemaUrl);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] byArray, InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalerArray) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeMessage(ResourceLogs.RESOURCE, resourceMarshaler);
        n2 += MarshalerUtil.sizeBytes(ResourceLogs.SCHEMA_URL, byArray);
        return n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceLogs.SCOPE_LOGS, (Marshaler[])instrumentationScopeLogsMarshalerArray);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> groupByResourceAndScope(Collection<LogRecordData> collection) {
        return MarshalerUtil.groupByResourceAndScope(collection, LogRecordData::getResource, LogRecordData::getInstrumentationScopeInfo, LogMarshaler::create);
    }
}

