/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.MetricExporter;

public class OtlpMetricExporterProvider
implements ConfigurableMetricExporterProvider {
    @Override
    public MetricExporter createExporter(ConfigProperties configProperties) {
        String string = OtlpConfigUtil.getOtlpProtocol("metrics", configProperties);
        if (string.equals("http/protobuf")) {
            OtlpHttpMetricExporterBuilder otlpHttpMetricExporterBuilder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", configProperties, otlpHttpMetricExporterBuilder::setEndpoint, otlpHttpMetricExporterBuilder::addHeader, otlpHttpMetricExporterBuilder::setCompression, otlpHttpMetricExporterBuilder::setTimeout, otlpHttpMetricExporterBuilder::setTrustedCertificates, otlpHttpMetricExporterBuilder::setClientTls, otlpHttpMetricExporterBuilder::setRetryPolicy);
            OtlpConfigUtil.configureOtlpAggregationTemporality(configProperties, otlpHttpMetricExporterBuilder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(configProperties, otlpHttpMetricExporterBuilder::setDefaultAggregationSelector);
            return otlpHttpMetricExporterBuilder.build();
        }
        if (string.equals("grpc")) {
            OtlpGrpcMetricExporterBuilder otlpGrpcMetricExporterBuilder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", configProperties, otlpGrpcMetricExporterBuilder::setEndpoint, otlpGrpcMetricExporterBuilder::addHeader, otlpGrpcMetricExporterBuilder::setCompression, otlpGrpcMetricExporterBuilder::setTimeout, otlpGrpcMetricExporterBuilder::setTrustedCertificates, otlpGrpcMetricExporterBuilder::setClientTls, otlpGrpcMetricExporterBuilder::setRetryPolicy);
            OtlpConfigUtil.configureOtlpAggregationTemporality(configProperties, otlpGrpcMetricExporterBuilder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(configProperties, otlpGrpcMetricExporterBuilder::setDefaultAggregationSelector);
            return otlpGrpcMetricExporterBuilder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + string);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpMetricExporterBuilder httpBuilder() {
        return OtlpHttpMetricExporter.builder();
    }

    OtlpGrpcMetricExporterBuilder grpcBuilder() {
        return OtlpGrpcMetricExporter.builder();
    }
}

