/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.data.LogRecordData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export.MultiLogRecordExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export.NoopLogRecordExporter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface LogRecordExporter
extends Closeable {
    public static LogRecordExporter composite(LogRecordExporter ... logRecordExporterArray) {
        return LogRecordExporter.composite(Arrays.asList(logRecordExporterArray));
    }

    public static LogRecordExporter composite(Iterable<LogRecordExporter> iterable) {
        ArrayList<LogRecordExporter> arrayList = new ArrayList<LogRecordExporter>();
        for (LogRecordExporter logRecordExporter : iterable) {
            arrayList.add(logRecordExporter);
        }
        if (arrayList.isEmpty()) {
            return NoopLogRecordExporter.getInstance();
        }
        if (arrayList.size() == 1) {
            return (LogRecordExporter)arrayList.get(0);
        }
        return MultiLogRecordExporter.create(arrayList);
    }

    public CompletableResultCode export(Collection<LogRecordData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

