/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import java.util.Objects;
import javax.annotation.Nullable;

public final class InstrumentSelectorBuilder {
    @Nullable
    private InstrumentType instrumentType;
    @Nullable
    private String instrumentName;
    @Nullable
    private String instrumentUnit;
    @Nullable
    private String meterName;
    @Nullable
    private String meterVersion;
    @Nullable
    private String meterSchemaUrl;

    InstrumentSelectorBuilder() {
    }

    public InstrumentSelectorBuilder setType(InstrumentType instrumentType) {
        Objects.requireNonNull(instrumentType, "instrumentType");
        this.instrumentType = instrumentType;
        return this;
    }

    public InstrumentSelectorBuilder setName(String string) {
        Objects.requireNonNull(string, "name");
        this.instrumentName = string;
        return this;
    }

    public InstrumentSelectorBuilder setUnit(String string) {
        Objects.requireNonNull(string, "unit");
        this.instrumentUnit = string;
        return this;
    }

    public InstrumentSelectorBuilder setMeterName(String string) {
        Objects.requireNonNull(string, "meterName");
        this.meterName = string;
        return this;
    }

    public InstrumentSelectorBuilder setMeterVersion(String string) {
        Objects.requireNonNull(string, "meterVersion");
        this.meterVersion = string;
        return this;
    }

    public InstrumentSelectorBuilder setMeterSchemaUrl(String string) {
        Objects.requireNonNull(string, "meterSchemaUrl");
        this.meterSchemaUrl = string;
        return this;
    }

    public InstrumentSelector build() {
        Utils.checkArgument(this.instrumentType != null || this.instrumentName != null || this.instrumentUnit != null || this.meterName != null || this.meterVersion != null || this.meterSchemaUrl != null, "Instrument selector must contain selection criteria");
        return InstrumentSelector.create(this.instrumentType, this.instrumentName, this.instrumentUnit, this.meterName, this.meterVersion, this.meterSchemaUrl);
    }
}

