/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ComponentRegistry;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.SdkMeter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.SdkMeterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.MetricReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.MetricProducer;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class SdkMeterProvider
implements MeterProvider,
Closeable {
    private static final e LOGGER = e.a(SdkMeterProvider.class.getName());
    static final String DEFAULT_METER_NAME = "unknown";
    private final List<RegisteredView> registeredViews;
    private final List<RegisteredReader> registeredReaders;
    private final MeterProviderSharedState sharedState;
    private final ComponentRegistry<SdkMeter> registry;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public static SdkMeterProviderBuilder builder() {
        return new SdkMeterProviderBuilder();
    }

    SdkMeterProvider(List<RegisteredView> list, IdentityHashMap<MetricReader, CardinalityLimitSelector> identityHashMap, Clock clock, Resource resource, ExemplarFilter exemplarFilter) {
        long l2 = clock.now();
        this.registeredViews = list;
        this.registeredReaders = identityHashMap.entrySet().stream().map(entry -> RegisteredReader.create((MetricReader)entry.getKey(), ViewRegistry.create((DefaultAggregationSelector)entry.getKey(), (CardinalityLimitSelector)entry.getValue(), list))).collect(Collectors.toList());
        this.sharedState = MeterProviderSharedState.create(clock, resource, exemplarFilter, l2);
        this.registry = new ComponentRegistry<SdkMeter>(instrumentationScopeInfo -> new SdkMeter(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo, this.registeredReaders));
        for (RegisteredReader registeredReader : this.registeredReaders) {
            LeasedMetricProducer leasedMetricProducer = new LeasedMetricProducer(this.registry, this.sharedState, registeredReader);
            registeredReader.getReader().register(leasedMetricProducer);
            registeredReader.setLastCollectEpochNanos(l2);
        }
    }

    @Override
    public MeterBuilder meterBuilder(String string) {
        if (this.registeredReaders.isEmpty()) {
            return MeterProvider.noop().meterBuilder(string);
        }
        if (string == null || string.isEmpty()) {
            LOGGER.f("Meter requested without instrumentation scope name.");
            string = DEFAULT_METER_NAME;
        }
        return new SdkMeterBuilder(this.registry, string);
    }

    void resetForTest() {
        this.registry.getComponents().forEach(SdkMeter::resetForTest);
    }

    public CompletableResultCode forceFlush() {
        if (this.registeredReaders.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>();
        for (RegisteredReader registeredReader : this.registeredReaders) {
            arrayList.add(registeredReader.getReader().forceFlush());
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    public CompletableResultCode shutdown() {
        if (!this.isClosed.compareAndSet(false, true)) {
            LOGGER.d("Multiple close calls");
            return CompletableResultCode.ofSuccess();
        }
        if (this.registeredReaders.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>();
        for (RegisteredReader registeredReader : this.registeredReaders) {
            arrayList.add(registeredReader.getReader().shutdown());
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkMeterProvider{clock=" + this.sharedState.getClock() + ", resource=" + this.sharedState.getResource() + ", metricReaders=" + this.registeredReaders.stream().map(RegisteredReader::getReader).collect(Collectors.toList()) + ", views=" + this.registeredViews + "}";
    }

    private static class LeasedMetricProducer
    implements MetricProducer {
        private final ComponentRegistry<SdkMeter> registry;
        private final MeterProviderSharedState sharedState;
        private final RegisteredReader registeredReader;

        LeasedMetricProducer(ComponentRegistry<SdkMeter> componentRegistry, MeterProviderSharedState meterProviderSharedState, RegisteredReader registeredReader) {
            this.registry = componentRegistry;
            this.sharedState = meterProviderSharedState;
            this.registeredReader = registeredReader;
        }

        @Override
        public Collection<MetricData> collectAllMetrics() {
            Collection<SdkMeter> collection = this.registry.getComponents();
            ArrayList<MetricData> arrayList = new ArrayList<MetricData>();
            long l2 = this.sharedState.getClock().now();
            for (SdkMeter sdkMeter : collection) {
                arrayList.addAll(sdkMeter.collectAll(this.registeredReader, l2));
            }
            this.registeredReader.setLastCollectEpochNanos(l2);
            return Collections.unmodifiableCollection(arrayList);
        }
    }
}

