/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.LongPointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class LongLastValueAggregator
implements Aggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;

    public LongLastValueAggregator(Supplier<ExemplarReservoir<LongExemplarData>> supplier) {
        this.reservoirSupplier = supplier;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongPointData diff(LongPointData longPointData, LongPointData longPointData2) {
        return longPointData2;
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<LongPointData> collection, AggregationTemporality aggregationTemporality) {
        return ImmutableMetricData.createLongGauge(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(collection));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long l2, long l3, Attributes attributes, List<LongExemplarData> list, boolean bl2) {
            Long l4 = bl2 ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            return ImmutableLongPointData.create(l2, l3, attributes, Objects.requireNonNull(l4), list);
        }

        @Override
        protected void doRecordLong(long l2) {
            this.current.set(l2);
        }
    }
}

