/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor;

import com.contrastsecurity.thirdparty.com.google.auto.value.AutoValue;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.View;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.AutoValue_MetricDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricDescriptor {
    private final AtomicReference<SourceInfo> viewSourceInfo = new AtomicReference();
    private int hashcode;

    public static MetricDescriptor create(String string, String string2, String string3) {
        return MetricDescriptor.create(View.builder().build(), SourceInfo.fromCurrentStack(), InstrumentDescriptor.create(string, string2, string3, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE, Advice.empty()));
    }

    public static MetricDescriptor create(View view, SourceInfo sourceInfo, InstrumentDescriptor instrumentDescriptor) {
        String string = view.getName() == null ? instrumentDescriptor.getName() : view.getName();
        String string2 = view.getDescription() == null ? instrumentDescriptor.getDescription() : view.getDescription();
        AutoValue_MetricDescriptor autoValue_MetricDescriptor = new AutoValue_MetricDescriptor(string, string2, view, instrumentDescriptor);
        autoValue_MetricDescriptor.viewSourceInfo.set(sourceInfo);
        return autoValue_MetricDescriptor;
    }

    MetricDescriptor() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract View getView();

    public final SourceInfo getViewSourceInfo() {
        SourceInfo sourceInfo = this.viewSourceInfo.get();
        return sourceInfo == null ? SourceInfo.noSourceInfo() : sourceInfo;
    }

    public abstract InstrumentDescriptor getSourceInstrument();

    public String getAggregationName() {
        return AggregationUtil.aggregationName(this.getView().getAggregation());
    }

    public final int hashCode() {
        int n2 = this.hashcode;
        if (n2 == 0) {
            n2 = 1;
            n2 *= 1000003;
            n2 ^= this.getName().toLowerCase(Locale.ROOT).hashCode();
            n2 *= 1000003;
            n2 ^= this.getDescription().hashCode();
            n2 *= 1000003;
            n2 ^= this.getView().hashCode();
            n2 *= 1000003;
            this.hashcode = n2 ^= this.getSourceInstrument().hashCode();
        }
        return n2;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MetricDescriptor) {
            MetricDescriptor metricDescriptor = (MetricDescriptor)object;
            return this.getName().equalsIgnoreCase(metricDescriptor.getName()) && this.getDescription().equals(metricDescriptor.getDescription()) && this.getView().equals(metricDescriptor.getView()) && this.getSourceInstrument().equals(metricDescriptor.getSourceInstrument());
        }
        return false;
    }
}

