/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class RandomFixedSizeExemplarReservoir<T extends ExemplarData>
extends FixedSizeExemplarReservoir<T> {
    private RandomFixedSizeExemplarReservoir(Clock clock, int n2, Supplier<Random> supplier, BiFunction<ReservoirCell, Attributes, T> biFunction) {
        super(clock, n2, new RandomCellSelector(supplier), biFunction);
    }

    static RandomFixedSizeExemplarReservoir<LongExemplarData> createLong(Clock clock, int n2, Supplier<Random> supplier) {
        return new RandomFixedSizeExemplarReservoir<LongExemplarData>(clock, n2, supplier, ReservoirCell::getAndResetLong);
    }

    static RandomFixedSizeExemplarReservoir<DoubleExemplarData> createDouble(Clock clock, int n2, Supplier<Random> supplier) {
        return new RandomFixedSizeExemplarReservoir<DoubleExemplarData>(clock, n2, supplier, ReservoirCell::getAndResetDouble);
    }

    static class RandomCellSelector
    implements ReservoirCellSelector {
        private final LongAdder numMeasurements = AdderUtil.createLongAdder();
        private final Supplier<Random> randomSupplier;

        private RandomCellSelector(Supplier<Random> supplier) {
            this.randomSupplier = supplier;
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] reservoirCellArray, long l2, Attributes attributes, Context context) {
            return this.reservoirCellIndex(reservoirCellArray);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] reservoirCellArray, double d2, Attributes attributes, Context context) {
            return this.reservoirCellIndex(reservoirCellArray);
        }

        private int reservoirCellIndex(ReservoirCell[] reservoirCellArray) {
            int n2;
            int n3 = this.randomSupplier.get().nextInt((n2 = this.numMeasurements.intValue() + 1) > 0 ? n2 : 1);
            this.numMeasurements.increment();
            if (n3 < reservoirCellArray.length) {
                return n3;
            }
            return -1;
        }

        @Override
        public void reset() {
            this.numMeasurements.reset();
        }
    }
}

