/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class DefaultSynchronousMetricStorage<T extends PointData, U extends ExemplarData>
implements SynchronousMetricStorage {
    private static final e internalLogger = e.a(DefaultSynchronousMetricStorage.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private final ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles = new ConcurrentHashMap();
    private final AttributesProcessor attributesProcessor;
    private final int maxCardinality;
    private final ConcurrentLinkedQueue<AggregatorHandle<T, U>> aggregatorHandlePool = new ConcurrentLinkedQueue();

    DefaultSynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int n2) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = n2 - 1;
    }

    Queue<AggregatorHandle<T, U>> getAggregatorHandlePool() {
        return this.aggregatorHandlePool;
    }

    @Override
    public void recordLong(long l2, Attributes attributes, Context context) {
        AggregatorHandle<T, U> aggregatorHandle = this.getAggregatorHandle(attributes, context);
        aggregatorHandle.recordLong(l2, attributes, context);
    }

    @Override
    public void recordDouble(double d2, Attributes attributes, Context context) {
        AggregatorHandle<T, U> aggregatorHandle = this.getAggregatorHandle(attributes, context);
        aggregatorHandle.recordDouble(d2, attributes, context);
    }

    private AggregatorHandle<T, U> getAggregatorHandle(Attributes attributes, Context context) {
        AggregatorHandle<T, U> aggregatorHandle;
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        AggregatorHandle<T, U> aggregatorHandle2 = this.aggregatorHandles.get(attributes);
        if (aggregatorHandle2 != null) {
            return aggregatorHandle2;
        }
        if (this.aggregatorHandles.size() >= this.maxCardinality) {
            this.logger.log(e.a.c, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            attributes = MetricStorage.CARDINALITY_OVERFLOW;
            aggregatorHandle2 = this.aggregatorHandles.get(attributes);
            if (aggregatorHandle2 != null) {
                return aggregatorHandle2;
            }
        }
        if ((aggregatorHandle = this.aggregatorHandlePool.poll()) == null) {
            aggregatorHandle = this.aggregator.createHandle();
        }
        return (aggregatorHandle2 = this.aggregatorHandles.putIfAbsent(attributes, aggregatorHandle)) != null ? aggregatorHandle2 : aggregatorHandle;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long l2, long l3) {
        boolean bl2 = this.aggregationTemporality == AggregationTemporality.DELTA;
        long l4 = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : l2;
        ArrayList arrayList = new ArrayList(this.aggregatorHandles.size());
        this.aggregatorHandles.forEach((attributes, aggregatorHandle) -> {
            Object t2 = aggregatorHandle.aggregateThenMaybeReset(l4, l3, (Attributes)attributes, bl2);
            if (bl2) {
                this.aggregatorHandles.remove(attributes, aggregatorHandle);
                this.aggregatorHandlePool.offer((AggregatorHandle<T, U>)aggregatorHandle);
            }
            if (t2 != null) {
                arrayList.add(t2);
            }
        });
        int n2 = this.aggregatorHandlePool.size() - (this.maxCardinality + 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.aggregatorHandlePool.poll();
        }
        if (arrayList.isEmpty()) {
            return EmptyMetricData.getInstance();
        }
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, arrayList, this.aggregationTemporality);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }
}

